/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.rest.RESTResponse;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.transport.onewayagent.RequestWrapper;
import com.singularity.ee.transport.onewayagent.ResponseWrapper;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.serialize.LookAheadObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OneWayAgentPayloadRequest
extends AControllerRequest {
    public static String ONE_WAY_AGENT_PAYLOAD_SUFFIX = "onewayagent";
    public static final String CONTAINS_RESPONSES = "contains-responses";
    private static final List<ResponseWrapper> EMPTY_RESPONSE_LIST = Collections.emptyList();
    private static final List<RequestWrapper> EMPTY_REQUEST_LIST = Collections.emptyList();
    private static final int MAX_READ_BYTES = 8192;
    private static final String RESPONSES_BINARY_PART_NAME = "responses";
    private List<RequestWrapper> requests = EMPTY_REQUEST_LIST;
    private RESTResponse response;

    public OneWayAgentPayloadRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
        this.setResponseStreamed(true);
        this.url = this.url + "/" + ONE_WAY_AGENT_PAYLOAD_SUFFIX;
    }

    public OneWayAgentPayloadRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    public OneWayAgentPayloadRequest(ILogger logger) {
        super(logger);
    }

    public OneWayAgentPayloadRequest(InputStream responseBody, ILogger logger) throws ResponseReadException {
        super(logger);
        try {
            this.deserializeControllerResponse(responseBody);
        }
        catch (IOException e) {
            throw new ResponseReadException("exception while deserializing the controller response", e);
        }
    }

    public RESTResponse getControllerResponse() {
        return this.response;
    }

    public List<RequestWrapper> getControllerRequests() {
        return this.requests;
    }

    public void setControllerRequests(List<RequestWrapper> requests) {
        this.requests = requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAgentResponses(List<ResponseWrapper> responses) throws IOException {
        if (responses == null) {
            throw new NullPointerException("responses is null");
        }
        if (responses.isEmpty()) {
            this.addArgumentWithNoAttributes(CONTAINS_RESPONSES, Boolean.FALSE.toString());
            return;
        }
        this.addArgumentWithNoAttributes(CONTAINS_RESPONSES, Boolean.TRUE.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream output = null;
        try {
            output = new ObjectOutputStream(baos);
            output.writeObject(responses);
        }
        finally {
            this.safeCloseOutputStream(output);
        }
        this.addBinaryPart(RESPONSES_BINARY_PART_NAME, baos.toByteArray());
    }

    public boolean containsAgentResponses() {
        return Boolean.parseBoolean(this.getValueForArgument(CONTAINS_RESPONSES));
    }

    public List<ResponseWrapper> getAgentResponses() throws IOException {
        if (!this.containsAgentResponses()) {
            return EMPTY_RESPONSE_LIST;
        }
        Map<String, byte[]> parts = this.downloadBinaryParts();
        byte[] binaryPart = parts.get(RESPONSES_BINARY_PART_NAME);
        if (binaryPart == null) {
            throw new NullPointerException("responses binaryPart is null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(binaryPart);
        LookAheadObjectInputStream input = null;
        try {
            input = new LookAheadObjectInputStream((InputStream)bais);
            List list = (List)input.readObject();
            return list;
        }
        catch (ClassNotFoundException e) {
            IOException exception = new IOException("unexpected exception while deserializing the responses");
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.safeCloseInputStream((InputStream)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int writeToResponseTracked(HttpServletResponse response) throws IOException {
        String successResponse = RESTResponse.createResponseBody("<response-code>0</response-code>", "");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream output = null;
        try {
            output = new ObjectOutputStream(baos);
            output.writeObject(successResponse);
            output.writeObject(this.requests);
        }
        finally {
            this.safeCloseOutputStream(output);
        }
        try {
            response.setStatus(200);
            return FileUtil.transferContent((OutputStream)response.getOutputStream(), (InputStream)new ByteArrayInputStream(baos.toByteArray()), (int)8192);
        }
        catch (IOException e) {
            response.setStatus(500);
            this.safeCloseOutputStream((OutputStream)response.getOutputStream());
            throw e;
        }
    }

    private void deserializeControllerResponse(InputStream requestBody) throws IOException, ResponseReadException {
        LookAheadObjectInputStream input = null;
        try {
            input = new LookAheadObjectInputStream(requestBody);
            String restResponse = (String)input.readObject();
            this.response = RESTResponse.readFromResponse(restResponse);
            if (this.response.isSuccessfullyExecuted()) {
                this.requests = (List)input.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            IOException exception = new IOException("unexpected exception while deserializing the response body");
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.safeCloseInputStream((InputStream)input);
            this.safeCloseInputStream(requestBody);
        }
    }

    private void safeCloseInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void safeCloseOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.flush();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

