/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.javax.xml.parsers.SAXParser;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.xml.sax.Attributes;
import com.appdynamics.org.xml.sax.SAXException;
import com.appdynamics.org.xml.sax.helpers.DefaultHandler;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;
import com.singularity.ee.controller.api.dto.RawMetricIdentifier;
import com.singularity.ee.rest.RESTArgument;
import com.singularity.ee.rest.RESTArgumentType;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentRequest;
import com.singularity.ee.rest.controller.request.spi.controller.IMetricControllerRegistrationRequest;
import com.singularity.ee.util.JavaLogging.JavaLogger;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class MetricRegistrationRequest
extends AControllerRequest
implements IAppAgentRequest,
IMetricControllerRegistrationRequest {
    public static String METRIC_REGISTRATION_SUFFIX = "metricregistration";

    public MetricRegistrationRequest(String responseBody, ILogger logger) throws ResponseReadException {
        super(logger);
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(responseBody);
            this.addArgumentsFromXMLPayload(xmlDoc);
        }
        catch (SAXException e) {
            logger.error("Error parsing XML reading REST response \n" + responseBody + "\n", (Throwable)e);
            throw new ResponseReadException(e);
        }
        catch (IOException e) {
            logger.error("Error reading REST response \n" + responseBody + "\n", (Throwable)e);
            throw new ResponseReadException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Error reading REST response, Parser configuration error \n" + responseBody + "\n", (Throwable)e);
            throw new ResponseReadException(e);
        }
        this.createSimpleArguments("name", "id");
    }

    public MetricRegistrationRequest(ILogger logger) {
        super(logger);
    }

    public MetricRegistrationRequest(ILogger logger, String controllerHost, int port, String machineId) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + METRIC_REGISTRATION_SUFFIX;
    }

    public MetricRegistrationRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    public void setComponentNodeId(String nodeID) {
        this.addArgumentWithNoAttributes("node-id", nodeID);
    }

    @Override
    protected void parseSimpleRequest(HttpServletRequest servletRequest) throws RequestReadException {
        Object in;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            throw new RequestReadException("Cannot read Multipart request");
        }
        String remoteIp = null;
        try {
            remoteIp = servletRequest.getRemoteAddr();
            in = servletRequest.getInputStream();
            if (this.logger.isDebugEnabled()) {
                byte[] requestContent = FileUtil.inputStreamToByteArray((InputStream)in);
                this.logger.debug("Received request " + servletRequest.getRequestURI() + " -> " + new String(requestContent));
                in = new ByteArrayInputStream(requestContent);
            }
        }
        catch (IOException e) {
            this.logger.warn("Error reading REST request ", (Throwable)e);
            throw new RequestReadException(e);
        }
        SAXParser sp = null;
        try {
            sp = XMLParseUtility.getSaxParser();
            sp.parse((InputStream)in, new DefaultHandler(){
                private boolean acceptElements = false;
                private Map<String, String> lastAttributes = null;
                private boolean elementStarted = false;
                private StringBuilder value = new StringBuilder();

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (!this.acceptElements && qName.equals("request")) {
                        this.acceptElements = true;
                    } else if (this.acceptElements) {
                        this.lastAttributes = new HashMap<String, String>();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            this.lastAttributes.put(attributes.getQName(i), attributes.getValue(i));
                        }
                        this.elementStarted = true;
                        this.value.setLength(0);
                    }
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.elementStarted) {
                        this.value.append(ch, start, length);
                    }
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.acceptElements && qName.equals("request")) {
                        this.acceptElements = false;
                    } else if (this.acceptElements && this.elementStarted) {
                        MetricRegistrationRequest.this.addArgument(qName, this.value.toString(), this.lastAttributes);
                        this.value.setLength(0);
                        this.elementStarted = false;
                    }
                }
            });
        }
        catch (SAXException e) {
            this.logger.warn("Error parsing XML reading REST request. Remote IP: " + remoteIp, (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (IOException e) {
            this.logger.warn("Error reading REST request. Remote IP: " + remoteIp, (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (Exception e) {
            this.logger.warn("Error reading REST request. Remote IP: " + remoteIp, (Throwable)e);
            throw new RequestReadException(e);
        }
        finally {
            if (sp != null) {
                sp.reset();
            }
        }
    }

    @Override
    public long getComponentNodeId() {
        if (this.getValueForArgument("node-id") == null) {
            return 0L;
        }
        return Long.parseLong(this.getValueForArgument("node-id"));
    }

    @Override
    public void setUnregisteredMetrics(List<RawMetricIdentifier> metricList, AgentType agentType) {
        this.addArgumentWithNoAttributes("agent-type", agentType.name());
        this.addToUnregisteredMetricList(metricList);
    }

    @Override
    public List<RawMetricIdentifier> getUnregisteredMetricList() {
        ArrayList<RawMetricIdentifier> metricList = new ArrayList<RawMetricIdentifier>();
        for (RESTArgument argument : this.getRequestArguments()) {
            if (!argument.getName().equals("metric")) continue;
            Map<String, String> attrs = argument.getAttributes();
            RawMetricIdentifier id = new RawMetricIdentifier();
            id.setName(attrs.get("name"));
            id.setTimeRollupType(MetricTimeRollupType.valueOf((String)attrs.get("time-rollup-type")));
            if (id.getName().endsWith("Average End to End Latency (ms)")) {
                id.setTimeRollupType(MetricTimeRollupType.AVERAGE);
            }
            id.setClusterRollupType(MetricClusterRollupType.valueOf((String)attrs.get("cluster-rollup-type")));
            id.setHoleType(MetricHoleHandlingType.valueOf((String)attrs.get("hole-fill-type")));
            String alertId = attrs.get("lite-alert-config-id");
            if (alertId != null) {
                id.setLiteAlertConfigId(alertId);
            }
            metricList.add(id);
        }
        return metricList;
    }

    public void addToUnregisteredMetricList(List<RawMetricIdentifier> metricToAdd) {
        for (RawMetricIdentifier metric : metricToAdd) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", metric.getName());
            attributes.put("time-rollup-type", metric.getTimeRollupType().toString());
            attributes.put("cluster-rollup-type", metric.getClusterRollupType().toString());
            if (metric.getHoleType() == null) {
                metric.setHoleType(MetricHoleHandlingType.REGULAR_COUNTER);
            }
            attributes.put("hole-fill-type", metric.getHoleType().toString());
            if (metric.getLiteAlertConfigId() != null) {
                attributes.put("lite-alert-config-id", metric.getLiteAlertConfigId());
            }
            this.addArgumentWithAttributesOnly("metric", attributes);
        }
    }

    @Override
    public void setRegisteredMetrics(Map<String, String> registeredMetrics) {
        for (Map.Entry<String, String> entry : registeredMetrics.entrySet()) {
            HashMap<String, String> attribMap = new HashMap<String, String>(2);
            attribMap.put("name", entry.getKey());
            attribMap.put("id", entry.getValue());
            this.addArgumentWithAttributesOnly("metric", attribMap);
        }
    }

    public String toString() {
        return this.getRequestArguments().toString();
    }

    @Override
    public Map<String, String> getRegisteredMetrics() {
        return this.getNameValueAttributeMapForArgument("metric", RESTArgumentType.STRING);
    }

    @Override
    public int getExecutionCode() {
        return StringOperations.safeParseInteger((String)this.getValueForArgument("response-code"), (int)0);
    }

    @Override
    public String getExecutionOutput() {
        return this.getValueForArgument("execution-output");
    }

    @Override
    public boolean isContextualLoggingEnabled() {
        String booleanValue = this.getValueForArgument("contextual-logging");
        return booleanValue != null && Boolean.parseBoolean(booleanValue);
    }

    public static void main(String[] args) throws Exception {
        MetricRegistrationRequest req1 = new MetricRegistrationRequest(new JavaLogger(Logger.getAnonymousLogger()));
        HashMap<String, String> unregMetricsMap = new HashMap<String, String>();
        unregMetricsMap.put("unregmetric1", "reg1");
        unregMetricsMap.put("unregmetric2", "reg2");
        unregMetricsMap.put("unregmetric3", "reg3");
        req1.setRegisteredMetrics(unregMetricsMap);
        req1.setComponentNodeId("abc");
        req1.setContextualLoggingEnabled(true);
        String res1 = req1.generatePayload();
        System.out.println("->" + req1 + " " + res1);
        MetricRegistrationRequest readReq1 = new MetricRegistrationRequest(res1, (ILogger)new JavaLogger(Logger.getAnonymousLogger()));
        System.out.println(" ->" + readReq1.getRegisteredMetrics());
    }

    public void setInvalidMetrics(Set<String> metrics) {
        for (String entry : metrics) {
            HashMap<String, String> attribMap = new HashMap<String, String>(2);
            attribMap.put("name", entry);
            this.addArgumentWithAttributesOnly("invalid-metric", attribMap);
        }
    }

    @Override
    public Set<String> getInvalidMetrics() {
        Map<String, String> invalidMetrics = this.getNameValueAttributeMapForArgument("invalid-metric", RESTArgumentType.STRING);
        return invalidMetrics.keySet();
    }
}

