/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.controller.api.dto.RawMetricData;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MetricDataRequest
extends ABinaryControllerRequest {
    private static final String METRIC_VAL_SEPARATOR = ",";
    private static final String ID_ATTR = "id";
    private static final String METRIC_TAG = "metric";
    private static final String TS_TAG = "timestamp";
    public static final String METRICS_SUFFIX = "metrics";
    public static final String NODE_ID = "node-id";
    private List<RawMetricData> metrics;
    private Date timestamp;
    private boolean testMode = true;
    private boolean binaryMetricMode;
    private List<RawMetricData> metricContainer = new ArrayList<RawMetricData>();

    public MetricDataRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
        logger.debug("url is " + this.url);
        this.addArgumentsFromPayload();
        this.createSimpleArguments();
        String timestampTextVal = this.getValueForArgument(TS_TAG);
        if (timestampTextVal != null) {
            logger.debug("Retrieved TimeStamp : " + timestampTextVal);
            this.timestamp = new Date(Long.parseLong(timestampTextVal));
        }
    }

    public MetricDataRequest(String controllerHost, int controllerPort, String machineId, ILogger logger) {
        super(controllerHost, controllerPort, machineId, logger);
        this.url = this.url + "/" + METRICS_SUFFIX;
    }

    private void addMetricsFromMetricArg(Object argValue) {
        this.logger.debug("Add Metrics to the Request.");
        this.metrics = new ArrayList<RawMetricData>();
        if (argValue instanceof Collection) {
            Collection metricsArgs = (Collection)argValue;
            for (Object metricArg : metricsArgs) {
                if (!(metricArg instanceof RawMetricData)) continue;
                RawMetricData metric = (RawMetricData)metricArg;
                this.logger.debug("Adding metric to the request: " + metric.print());
                this.metrics.add(metric);
            }
        }
    }

    private void addArgumentsFromPayload() {
        this.logger.debug("Adding Argument From Payload to the Request.");
        for (Map.Entry payloadArg : this.payload.entrySet()) {
            this.logger.debug("Adding payload [" + (String)payloadArg.getKey() + METRIC_VAL_SEPARATOR + payloadArg.getValue() + "] to request");
            String argName = (String)payloadArg.getKey();
            Object argObjValue = payloadArg.getValue();
            if (argName.equals(METRIC_TAG)) {
                this.addMetricsFromMetricArg(argObjValue);
            }
            String argTextValue = null;
            if (argObjValue != null) {
                argTextValue = argObjValue.toString();
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            this.addArgument(argName, argTextValue, attributes);
        }
    }

    @Override
    protected String getName() {
        return "Metrics Request";
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void setTimestamp(Date timestamp) {
        this.addArgumentWithNoAttributes(TS_TAG, String.valueOf(timestamp.getTime()));
    }

    public void setNodeID(String nodeID) {
        this.addArgumentWithNoAttributes(NODE_ID, nodeID);
    }

    public long getNodeID() {
        if (this.getValueForArgument(NODE_ID) == null) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getValueForArgument(NODE_ID));
        }
        catch (NumberFormatException e) {
            this.logger.warn("Error parsing NODE ID from metric request", (Throwable)e);
            return -1L;
        }
    }

    public void setBinaryMetricMode(boolean binaryMetricMode) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Metric Binary payload mode set to " + binaryMetricMode);
        }
        this.binaryMetricMode = binaryMetricMode;
    }

    public void addMetric(RawMetricData metricData) {
        if (this.binaryMetricMode) {
            this.metricContainer.add(metricData);
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID_ATTR, String.valueOf(metricData.getMetricIdentifier().getId()));
        attributes.put("value", this.createMetricValueString(metricData.getMetricValue()));
        if (this.testMode) {
            attributes.put("name", metricData.getMetricIdentifier().getName());
        }
        this.addArgumentWithAttributesOnly(METRIC_TAG, attributes);
    }

    @Override
    public HttpExecutionResponse sendRequest() {
        if (this.binaryMetricMode) {
            try {
                byte[] metricContainerBytes = MetricDataRequest.convertToBinary(this.metricContainer);
                this.addBinaryPart(METRICS_SUFFIX, metricContainerBytes);
            }
            catch (Exception e) {
                this.logger.error("Serialization failed for metric data ", (Throwable)e);
            }
        }
        IHttpExecutionResponse response = super.sendRequest();
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("\n\r");
            sb.append("<metric-binary-data count=" + this.metricContainer.size() + ">");
            for (RawMetricData rawMetricData : this.metricContainer) {
                sb.append(rawMetricData.print());
            }
            sb.append("\n</metric-binary-data>");
            this.logger.debug(sb.toString());
        }
        return response;
    }

    public static byte[] convertToBinary(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
        }
        return baos.toByteArray();
    }

    public void addMetrics(Collection<? extends RawMetricData> metricsData) {
        for (RawMetricData rawMetricData : metricsData) {
            this.addMetric(rawMetricData);
        }
    }

    public Date getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = new Date(Long.parseLong(this.getValueForArgument(TS_TAG)));
        }
        return this.timestamp;
    }

    public List<RawMetricData> getMetrics() {
        return this.metrics;
    }

    public long getMachine() {
        return Long.parseLong(this.getMachineId());
    }

    private String createMetricValueString(RawMetricValue value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getSum());
        sb.append(METRIC_VAL_SEPARATOR);
        sb.append(value.getCount());
        sb.append(METRIC_VAL_SEPARATOR);
        sb.append(value.getMin());
        sb.append(METRIC_VAL_SEPARATOR);
        sb.append(value.getMax());
        sb.append(METRIC_VAL_SEPARATOR);
        sb.append(value.getCurrent());
        return sb.toString();
    }
}

