/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.controller.api.dto.RawMetricData;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.ConnectionBackOffHelper;
import com.singularity.ee.rest.controller.request.spi.controller.IMetricControllerDataRequest;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class MetricDataBinaryRequest
extends ABinaryControllerRequest
implements IMetricControllerDataRequest {
    private static final int METRIC_DATA_MAX_CALLS_BETWEEN_ATTEMPTS = 6;
    private static final int METRIC_DATA_ERROR_LIMIT = 5;
    private static final ConnectionBackOffHelper backOffHelper = new ConnectionBackOffHelper(6, 5);
    private List<RawMetricData> metricContainer = null;
    private Date timestamp;
    private static final IAgentAtomicInteger metricDataErrorCount = new AgentAtomicIntegerImpl(0);

    public MetricDataBinaryRequest(ILogger logger) {
        super(logger);
    }

    public MetricDataBinaryRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public MetricDataBinaryRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + "metrics";
        this.metricContainer = new ArrayList<RawMetricData>();
        this.payload.put("metric", this.metricContainer);
    }

    public MetricDataBinaryRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.payload.put("timestamp", String.valueOf(timestamp.getTime()));
    }

    @Override
    public void addMetric(RawMetricData metricData) {
        this.metricContainer.add(metricData);
    }

    @Override
    public List<RawMetricData> getMetrics() {
        return (List)this.payload.get("metric");
    }

    @Override
    public Date getTimestamp() {
        if (this.timestamp == null) {
            String timestampStr = (String)this.payload.get("timestamp");
            if (timestampStr == null) {
                return null;
            }
            this.timestamp = new Date(Long.parseLong(timestampStr));
        }
        return this.timestamp;
    }

    @Override
    public long getMachine() {
        return Long.parseLong(this.getMachineId());
    }

    @Override
    public void addMetrics(Collection<RawMetricData> metricsData) {
        this.metricContainer.addAll(metricsData);
    }

    @Override
    protected String getName() {
        return "Metric Data";
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return backOffHelper.isRequestOverConnectionLimit(errorCount);
    }

    @Override
    protected void incrementErrorCount() {
        metricDataErrorCount.incrementAndGet();
    }

    @Override
    protected void clearErrorCount() {
        metricDataErrorCount.set(0);
    }

    @Override
    protected int getErrorCount() {
        return metricDataErrorCount.get();
    }

    public static int getMetricDataRequestErrorCount() {
        return metricDataErrorCount.get();
    }
}

