/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.util.logging.ILogger;
import javax.servlet.http.HttpServletRequest;

public class LogDeltaRequest
extends AControllerRequest {
    public static final String LOG_COLLECTOR_DATA = "logcollectordata";
    public static final String LOG_FILE_NAME = "log-file-name";
    public static final String TIMESTAMP = "timestamp";
    public static final String COMPRESSED = "compressed";
    public static final String TRUNCATED = "truncated";
    public static final String ORIGINAL_BYTE_LENGTH_BEFORE_COMPRESSION = "original-byte-length-before-compression";
    public static final String BYTE_LENGTH_AFTER_COMPRESSION = "byte-lenth-after-compression";
    public static final String DELTA_CONTENT = "delta-content";

    public LogDeltaRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    public LogDeltaRequest(String controllerHost, int controllerPort, String machineId, String logCollectorName, ILogger logger) {
        super(controllerHost, controllerPort, machineId, logger);
        this.url = this.url + "/" + logCollectorName;
    }

    public void setLogFileName(String logFileName) {
        this.addArgumentWithNoAttributes(LOG_FILE_NAME, logFileName);
    }

    public void setTimeStamp(String timeStamp) {
        this.addArgumentWithNoAttributes(TIMESTAMP, timeStamp);
    }

    public void setCompressedData(int byteLengthBefore, int byteLengthAfter) {
        this.addArgumentWithNoAttributes(COMPRESSED, String.valueOf(1));
        this.addArgumentWithNoAttributes(ORIGINAL_BYTE_LENGTH_BEFORE_COMPRESSION, String.valueOf(byteLengthBefore));
        this.addArgumentWithNoAttributes(BYTE_LENGTH_AFTER_COMPRESSION, String.valueOf(byteLengthAfter));
    }

    public void setRegularData() {
        this.addArgumentWithNoAttributes(COMPRESSED, String.valueOf(0));
    }

    public void setDeltaContent(String deltaContent) {
        this.addArgumentWithNoAttributes(DELTA_CONTENT, deltaContent);
    }

    public void setTruncatedFlag(boolean truncated) {
        if (truncated) {
            this.addArgumentWithNoAttributes(TRUNCATED, String.valueOf(1));
        } else {
            this.addArgumentWithNoAttributes(TRUNCATED, String.valueOf(0));
        }
    }

    public String getLogFileName() {
        return this.getValueForArgument(LOG_FILE_NAME);
    }

    public String getTimeStamp() {
        return this.getValueForArgument(TIMESTAMP);
    }

    @Override
    public boolean isCompressed() {
        String compressedFlag = this.getValueForArgument(COMPRESSED);
        return !"0".equals(compressedFlag);
    }

    public boolean isTruncated() {
        String truncatedFlag = this.getValueForArgument(TRUNCATED);
        return !"0".equals(truncatedFlag);
    }

    public int getOriginalByteLength() {
        try {
            return Integer.parseInt(this.getValueForArgument(ORIGINAL_BYTE_LENGTH_BEFORE_COMPRESSION));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getAfterCompressionByteLength() {
        try {
            return Integer.parseInt(this.getValueForArgument(BYTE_LENGTH_AFTER_COMPRESSION));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getDeltaContent() {
        return this.getValueForArgument(DELTA_CONTENT);
    }
}

