/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ATimestampRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class GetCurrentTimeRequest
extends ATimestampRequest {
    public static final String CURRENT_TIME_SUFFIX = "current-time";

    public GetCurrentTimeRequest(String controllerHost, int controllerPort, String machineId, ILogger logger) {
        super(controllerHost, controllerPort, machineId, logger);
        this.url = this.url + "/" + CURRENT_TIME_SUFFIX;
    }

    public GetCurrentTimeRequest(ILogger logger) {
        super(logger);
    }

    public GetCurrentTimeRequest(String responseBody, ILogger logger) throws ResponseReadException {
        super(logger);
        if (StringOperations.isEmpty((String)responseBody)) {
            throw new ResponseReadException("Empty reponse from controller");
        }
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(responseBody);
            this.addArgumentsFromXMLPayload(xmlDoc);
            this.createSimpleArguments();
        }
        catch (SAXException e) {
            logger.warn("Error parsing XML reading REST response \n" + responseBody + "\n", (Throwable)e);
            throw new ResponseReadException(e);
        }
        catch (IOException e) {
            logger.warn("Error reading REST response \n" + responseBody + "\n", (Throwable)e);
            throw new ResponseReadException(e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Error reading REST response, Parser configuration error \n" + responseBody + "\n", (Throwable)e);
            throw new ResponseReadException(e);
        }
    }

    public GetCurrentTimeRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
    }

    public boolean isContextualLoggingEnabled() {
        String booleanValue = this.getValueForArgument("contextual-logging");
        return booleanValue != null && Boolean.parseBoolean(booleanValue);
    }
}

