/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.ConnectionBackOffHelper;
import com.singularity.ee.rest.controller.request.spi.controller.IEventControllerDataRequest;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class EventDataRequest
extends ABinaryControllerRequest
implements IEventControllerDataRequest {
    private static final int EVENT_DATA_MAX_CALLS_BETWEEN_ATTEMPTS = 5;
    private static final int EVENT_DATA_ERROR_LIMIT = 5;
    private static final ConnectionBackOffHelper backOffHelper = new ConnectionBackOffHelper(5, 5);
    private static final IAgentAtomicInteger eventDataErrorCount = new AgentAtomicIntegerImpl(0);
    private Date timestamp;

    public EventDataRequest(ILogger logger) {
        super(logger);
    }

    public EventDataRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public EventDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + "events";
    }

    public EventDataRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.payload.put("timestamp", String.valueOf(timestamp.getTime()));
    }

    @Override
    public Date getTimestamp() {
        if (this.timestamp == null) {
            String timestampStr = (String)this.payload.get("timestamp");
            if (timestampStr == null) {
                return null;
            }
            this.timestamp = new Date(Long.parseLong(timestampStr));
        }
        return this.timestamp;
    }

    @Override
    public <T extends AgentEventData> void addEvents(List<T> eventData) {
        ArrayList<T> events = (ArrayList<T>)this.payload.get("agent-events");
        if (events == null) {
            events = new ArrayList<T>();
            this.payload.put("agent-events", events);
        }
        events.addAll(eventData);
    }

    @Override
    public <T extends AgentEventData> List<T> getEvents() {
        List events = (List)this.payload.get("agent-events");
        if (events == null) {
            return Collections.emptyList();
        }
        return events;
    }

    @Override
    public long getMachine() {
        return Long.parseLong(this.getMachineId());
    }

    @Override
    protected String getName() {
        return "Event Data";
    }

    public long getTransientSessionId() {
        return Long.parseLong((String)this.payload.get("transient-session-id"));
    }

    public void setTransientSessionId(long sessionId) {
        this.payload.put("transient-session-id", sessionId);
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return backOffHelper.isRequestOverConnectionLimit(errorCount);
    }

    @Override
    protected void incrementErrorCount() {
        eventDataErrorCount.incrementAndGet();
    }

    @Override
    protected void clearErrorCount() {
        eventDataErrorCount.set(0);
    }

    @Override
    protected int getErrorCount() {
        return eventDataErrorCount.get();
    }
}

