/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.rest.controller.request.AControllerRequest;

public class ConnectionBackOffHelper {
    private static final int MAX_CALLS_BETWEEN_CONNECTION_ATTEMPTS_DEFAULT = 5;
    private int callsSinceLastAttempt = 0;
    private int maxCallsBetweenAttempts;
    private int errorCountLimit;

    public ConnectionBackOffHelper() {
        this.maxCallsBetweenAttempts = 5;
        this.errorCountLimit = AControllerRequest.ERROR_COUNT_LIMIT;
    }

    public ConnectionBackOffHelper(int maxCallsBetweenAttempts, int errorCountLimit) {
        this.maxCallsBetweenAttempts = maxCallsBetweenAttempts;
        this.errorCountLimit = errorCountLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestOverConnectionLimit(int errorCount) {
        ConnectionBackOffHelper connectionBackOffHelper = this;
        synchronized (connectionBackOffHelper) {
            ++this.callsSinceLastAttempt;
            if (errorCount <= this.errorCountLimit) {
                this.callsSinceLastAttempt = 0;
                return false;
            }
            if (errorCount - this.errorCountLimit <= this.callsSinceLastAttempt || this.callsSinceLastAttempt >= this.maxCallsBetweenAttempts) {
                this.callsSinceLastAttempt = 0;
                return false;
            }
            return true;
        }
    }
}

