/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.controller.api.constants.ApplicationDiagnosticDataType;
import com.singularity.ee.controller.api.dto.ApplicationDiagnosticData;
import com.singularity.ee.controller.api.dto.NodeResolutionInfo;
import com.singularity.ee.controller.api.dto.UnresolvedBackendCallInfo;
import com.singularity.ee.controller.api.dto.federation.RegisteredMetadata;
import com.singularity.ee.controller.api.dto.federation.UnregisteredMetadataKey;
import com.singularity.ee.controller.api.dto.transactionmonitor.federation.exitcall.FederatedUnresolvedBackendKey;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BusinessTransaction;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentRequest;
import com.singularity.ee.rest.controller.request.spi.controller.IBTControllerRegistrationRequest;
import com.singularity.ee.transactiondefinition.config.xml.boot.TagNames;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class BTRegistrationBinaryRequest
extends ABinaryControllerRequest
implements TagNames,
IAppAgentRequest,
IBTControllerRegistrationRequest {
    public static final String UNREGISTERED_TRANSACTIONS = "unregistered-transactions";
    public static final String INVALID_BACKENDS = "invalid-backends";
    public static final String REGISTERED_BACKENDS = "registered-backends";
    public static final String UNREGISTERED_BACKENDS = "unregistered-backends";

    public BTRegistrationBinaryRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
    }

    public BTRegistrationBinaryRequest(ILogger logger) {
        super(logger);
    }

    public BTRegistrationBinaryRequest(ILogger logger, String controllerHost, int port, String machineId) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + "btregistration";
    }

    public BTRegistrationBinaryRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    protected String getName() {
        return "BT Registration Data";
    }

    @Override
    public void setTransactions(Collection<BusinessTransaction> businessTransactions) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST - Setting BTs to register : " + businessTransactions);
        }
        this.payload.put("business-transactions", businessTransactions);
    }

    @Override
    public void setInvalidTransactions(Collection<BusinessTransaction> businessTransactions) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST - Setting invalid BTs : " + businessTransactions);
        }
        this.payload.put("invalid-business-transactions", businessTransactions);
    }

    @Override
    public Collection<BusinessTransaction> getTransactions() {
        return (Collection)this.payload.get("business-transactions");
    }

    @Override
    public Collection<BusinessTransaction> getInvalidTransactions() {
        return (Collection)this.payload.get("invalid-business-transactions");
    }

    @Override
    public Collection<BusinessTransaction> getUnregisteredTransactions() {
        return (Collection)this.payload.get(UNREGISTERED_TRANSACTIONS);
    }

    @Override
    public void setUnresolvedBackendCallInfos(Collection<UnresolvedBackendCallInfo> calls) {
        this.payload.put(UNREGISTERED_BACKENDS, calls);
    }

    @Override
    public Collection<UnresolvedBackendCallInfo> getUnresolvedBackendCallInfos() {
        return (Collection)this.payload.get(UNREGISTERED_BACKENDS);
    }

    @Override
    public void setUnregisteredFederatedMetadataKeys(Collection<UnregisteredMetadataKey> unregisteredMetadataKeys) {
        this.payload.put("unregistered-federated-metadata", unregisteredMetadataKeys);
    }

    @Override
    public Collection<UnregisteredMetadataKey> getUnregisteredFederatedMetadataKeys() {
        return (Collection)this.payload.get("unregistered-federated-metadata");
    }

    @Override
    public void setRegisteredFederatedMetadataCollection(Collection<RegisteredMetadata> registeredMetadataCollection) {
        this.payload.put("registered-federated-metadata", registeredMetadataCollection);
    }

    @Override
    public Collection<RegisteredMetadata> getRegisteredFederatedMetadataCollection() {
        return (Collection)this.payload.get("registered-federated-metadata");
    }

    @Override
    public void setResolvedBackendCallInfosMap(Map<Long, NodeResolutionInfo> calls) {
        this.payload.put("resolved-backend-calls", calls);
    }

    @Override
    public Map<Long, NodeResolutionInfo> getResolvedBackendCallInfosMap() {
        return (Map)this.payload.get("resolved-backend-calls");
    }

    @Override
    public void setBackendCallsToResolve(Collection<Long> set) {
        if (set.size() == 0) {
            return;
        }
        HashSet<Long> backends = new HashSet<Long>();
        for (Long aLong : set) {
            backends.add(aLong);
        }
        this.payload.put("self-resolved-backend-ids", backends);
    }

    @Override
    public void setFederatedUnresolvedBackendsToResolve(FederatedUnresolvedBackendKey[] unresolvedFederatedBackends) {
        this.payload.put("self-resolved-federated-backend-ids", unresolvedFederatedBackends);
    }

    @Override
    public FederatedUnresolvedBackendKey[] getFederatedUnresolvedBackendsToResolve() {
        return (FederatedUnresolvedBackendKey[])this.payload.get("self-resolved-federated-backend-ids");
    }

    @Override
    public Set<Long> getBackendCallIdsToResolve() {
        return (Set)this.payload.get("self-resolved-backend-ids");
    }

    @Override
    public void registerApplicationDiagnosticData(Collection<ApplicationDiagnosticData> data) {
        this.payload.put("application-diagnostic-data", data);
    }

    @Override
    public Collection<ApplicationDiagnosticData> getUnregisteredApplicationDiagnosticData() {
        return (Collection)this.payload.get("application-diagnostic-data");
    }

    @Override
    public Map<ApplicationDiagnosticDataType, Map<String, Long>> getRegisteredApplicationDiagnosticDataMap() {
        return (Map)this.payload.get("application-diagnostic-data");
    }

    @Override
    public void setEUMCanEnableTransactions(Long[] set) {
    }

    @Override
    public void setRegisteredApplicationDiagnosticDataMap(Map<ApplicationDiagnosticDataType, Map<String, Long>> map) {
        this.payload.put("application-diagnostic-data", map);
    }

    @Override
    public void setEumAutoEnablePossibleBtIds(long[] possibleBtIds) {
        this.payload.put("eum-auto-enable-possible-bt-ids", possibleBtIds);
    }

    @Override
    public void setEumAutoEnableNotPossibleBtIds(long[] notPossibleBtIds) {
        this.payload.put("eum-auto-enable-not-possible-bt-ids", notPossibleBtIds);
    }

    @Override
    public long[] getEumAutoEnablePossibleBtIds() {
        return (long[])this.payload.get("eum-auto-enable-possible-bt-ids");
    }

    @Override
    public long[] getEumAutoEnableNotPossibleBtIds() {
        return (long[])this.payload.get("eum-auto-enable-not-possible-bt-ids");
    }

    @Override
    public void setUnregisteredTransactions(Collection<BusinessTransaction> bts) {
        this.payload.put(UNREGISTERED_TRANSACTIONS, bts);
    }

    @Override
    public void setInvalidBackends(Collection<UnresolvedBackendCallInfo> backends) {
        this.payload.put(INVALID_BACKENDS, backends);
    }

    public Collection<UnresolvedBackendCallInfo> getInvalidBackends() {
        return (Collection)this.payload.get(INVALID_BACKENDS);
    }

    @Override
    public void setUnregisteredBackends(Collection<UnresolvedBackendCallInfo> backends) {
        this.payload.put(UNREGISTERED_BACKENDS, backends);
    }

    public Collection<UnresolvedBackendCallInfo> getUnregisteredBackends() {
        return (Collection)this.payload.get(UNREGISTERED_BACKENDS);
    }

    @Override
    public void setRegisteredBackends(Collection<UnresolvedBackendCallInfo> backends) {
        this.payload.put(REGISTERED_BACKENDS, backends);
    }

    @Override
    public Collection<UnresolvedBackendCallInfo> getRegisteredBackends() {
        return (Collection)this.payload.get(REGISTERED_BACKENDS);
    }

    @Override
    public void setBTRegistrationAttempted() {
    }
}

