/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509TrustManager;

public class AuthSSLX509TrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager = null;
    private static final Logger logger = Logger.getLogger(AuthSSLX509TrustManager.class.getName());

    public AuthSSLX509TrustManager(X509TrustManager defaultTrustManager) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = defaultTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.log(" Client certificate - ", certificates);
        this.defaultTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.log(" Server certificate - ", certificates);
        this.defaultTrustManager.checkServerTrusted(certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private void log(String type, X509Certificate[] certificates) {
        if (!logger.isLoggable(Level.FINE) || certificates == null) {
            return;
        }
        for (int c = 0; c < certificates.length; ++c) {
            X509Certificate certificate = certificates[c];
            logger.log(Level.FINE, type + (c + 1) + ":");
            logger.log(Level.FINE, this.toString(certificate));
        }
    }

    private String toString(X509Certificate certificate) {
        StringBuilder sb = new StringBuilder();
        sb.append("  Subject DN: ").append(certificate.getSubjectDN());
        sb.append("  Signature Algorithm: ").append(certificate.getSigAlgName());
        sb.append("  Valid from: ").append(certificate.getNotBefore());
        sb.append("  Valid until: ").append(certificate.getNotAfter());
        sb.append("  Issuer: ").append(certificate.getIssuerDN());
        return sb.toString();
    }
}

