/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentNodeNameRequest;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.httpclient.HttpOperation;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppAgentNodeNameRequest
extends AControllerRequest
implements IAppAgentNodeNameRequest {
    Map<String, String> attributes = new HashMap<String, String>();
    private String nodeName;

    public AppAgentNodeNameRequest(ILogger logger, String controllerHost, int port, String machineId) {
        super(controllerHost, port, machineId, logger);
        this.url = "/controller/rest/applications/register-node";
        this.attributes.put("machine-info", SystemInfo.getMachineInfo());
        this.attributes.put("app-agent-type", AgentType.APP_AGENT.name());
        this.attributes.put("node-number-of-license-units", "1");
    }

    public AppAgentNodeNameRequest(IHttpExecutionResponse response, ILogger iLogger) {
        super(iLogger);
        try {
            Document doc = XMLParseUtility.getXmlDocumentFromString(response.getResponseBody());
            List<Element> list = XMLParseUtility.getListOfDirectSiblingsForNode((Node)doc.getDocumentElement());
            for (Element nodeElement : list) {
                this.nodeName = XMLParseUtility.getTextForTagForElement((Node)nodeElement, "name");
                if (this.nodeName == null) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing response.", e);
        }
    }

    @Override
    public void setAgentInstallDirectory(String installDirectory) {
        this.attributes.put("agent-install-dir", installDirectory);
    }

    @Override
    public void setAgentVersion(String version) {
        this.attributes.put("agent-version", version);
    }

    @Override
    public void setNodePrefix(String prefix) {
        this.attributes.put("node-prefix", prefix);
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.attributes.put("application-name", applicationName);
    }

    @Override
    public void setApplicationComponentName(String tierName) {
        this.attributes.put("tier-name", tierName);
    }

    @Override
    public void setUniqueHostName(String uniqueHostName) {
        this.attributes.put("machine-unique-host-info", uniqueHostName);
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public HttpExecutionResponse sendRequest() {
        return super.sendRequest();
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("error encoding value [" + value + "]", (Throwable)e);
            return value;
        }
    }

    @Override
    public HttpExecutionRequest generateRequest() {
        StringBuilder urlBuffer = new StringBuilder();
        String[] keyArray = this.attributes.keySet().toArray(new String[this.attributes.size()]);
        for (int i = 0; i < keyArray.length; ++i) {
            String key = keyArray[i];
            String value = this.attributes.get(key);
            urlBuffer.append(key).append("=").append(this.encodeValue(value));
            if (i == keyArray.length - 1) continue;
            urlBuffer.append("&");
        }
        String restURL = this.url + "?" + urlBuffer.toString();
        this.logger.info("requesting nodename from controller [" + restURL + "]");
        return new HttpExecutionRequest(restURL, "", HttpOperation.POST);
    }
}

