/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.singularity.ee.agent.AgentAccountInfoStore;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.constants.AppAgentOperationStatus;
import com.singularity.ee.controller.api.constants.InstrumentationLevel;
import com.singularity.ee.controller.api.dto.AccountProfile;
import com.singularity.ee.controller.api.dto.AnalyticsBTTypeConversionConfigs;
import com.singularity.ee.controller.api.dto.AnalyticsConfig;
import com.singularity.ee.controller.api.dto.AnalyticsDynamicServiceConfig;
import com.singularity.ee.controller.api.dto.ApplicationConfiguration;
import com.singularity.ee.controller.api.dto.ApplicationDiagnosticData;
import com.singularity.ee.controller.api.dto.CallGraphConfiguration;
import com.singularity.ee.controller.api.dto.EUMConfiguration;
import com.singularity.ee.controller.api.dto.ErrorConfiguration;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.NodeResolutionInfo;
import com.singularity.ee.controller.api.dto.ReregisterNodeTicket;
import com.singularity.ee.controller.api.dto.StallConfiguration;
import com.singularity.ee.controller.api.dto.jmx.JMXMetricRule;
import com.singularity.ee.controller.api.dto.serviceendpoint.ServiceEndpointDefinition;
import com.singularity.ee.controller.api.dto.serviceendpoint.ServiceEndpointMatchConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.federation.FederationFriendsConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BusinessTransaction;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ProcessSnapshotNodeRequest;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.ABinaryControllerRequest;
import com.singularity.ee.rest.controller.request.AppAgentExitCallInfo;
import com.singularity.ee.rest.controller.request.AppAgentOperationInfo;
import com.singularity.ee.rest.controller.request.ApplicationDiagnosticDataInfo;
import com.singularity.ee.rest.controller.request.AsyncTransactionConfigs;
import com.singularity.ee.rest.controller.request.BTConfigurations;
import com.singularity.ee.rest.controller.request.CacheConfigurationInfo;
import com.singularity.ee.rest.controller.request.ConnectionBackOffHelper;
import com.singularity.ee.rest.controller.request.CustomExitPointDefinitons;
import com.singularity.ee.rest.controller.request.DataGathererConfigs;
import com.singularity.ee.rest.controller.request.ExcludedBT;
import com.singularity.ee.rest.controller.request.InfoPointGathererConfigs;
import com.singularity.ee.rest.controller.request.LatestConfigChangeInfo;
import com.singularity.ee.rest.controller.request.MachinesIPPortConfig;
import com.singularity.ee.rest.controller.request.MemoryConfigurationInfo;
import com.singularity.ee.rest.controller.request.NodeProperties;
import com.singularity.ee.rest.controller.request.TagInfoSet;
import com.singularity.ee.rest.controller.request.TransactionMatchPointConfigurations;
import com.singularity.ee.rest.controller.request.spi.controller.AgentSupportedFeatures;
import com.singularity.ee.rest.controller.request.spi.controller.IAppAgentControllerConfigurationRequest;
import com.singularity.ee.transactiondefinition.config.TransactionConfigXMLConverter;
import com.singularity.ee.transactiondefinition.config.xml.AppAgentConfigTagNames;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import com.singularity.ee.util.version.AgentVersion;
import com.singularity.ee.util.xml.XMLWriteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AppAgentConfigurationBinaryRequest
extends ABinaryControllerRequest
implements AppAgentConfigTagNames,
IAppAgentControllerConfigurationRequest {
    private static final String BT_RULE_DIAGNOSTIC_SESSIONS = "bt-rule-diagnostic-sessions";
    private static final String ON_DEMAND_DIAGNOSTIC_SESSIONS = "on-demand-diagnostic-sessions";
    private static final ConnectionBackOffHelper backOffHelper = new ConnectionBackOffHelper();

    public AppAgentConfigurationBinaryRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(response, logger);
        if (this.hasInitializationInfo()) {
            this.registerAccountKey();
        }
        this.setAgentTypeIfNull(AgentType.APP_AGENT);
    }

    public AppAgentConfigurationBinaryRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
        this.setAgentTypeIfNull(AgentType.APP_AGENT);
    }

    public AppAgentConfigurationBinaryRequest(HttpServletRequest servletRequest, String machineId, ILogger logger) throws RequestReadException {
        this(servletRequest, logger);
        this.machineId = machineId;
    }

    private void registerAccountKey() {
        AppAgentConfigurationBinaryRequest.registerAccountKey(AgentAccountInfoStore.getInstance().getAccountName(), this.getAccountKey());
    }

    public AppAgentConfigurationBinaryRequest(ILogger logger) {
        super(logger);
        this.setAgentTypeIfNull(AgentType.APP_AGENT);
    }

    public AppAgentConfigurationBinaryRequest(ILogger logger, String controllerHost, int port, String machineId) {
        super(controllerHost, port, machineId, logger);
        this.url = this.url + "/" + "applicationConfiguration";
        this.setAgentTypeIfNull(AgentType.APP_AGENT);
    }

    @Override
    public void setTransactionConfigurationTimeStamp(long timeStamp) {
        this.payload.put("transaction-config-time-stamp", timeStamp);
    }

    @Override
    public long getTransactionConfigurationTimeStamp() {
        return this.extractLongValue("transaction-config-time-stamp");
    }

    @Override
    public void setIPConfigurationTimeStamp(long timeStamp) {
        this.payload.put("ip-config-time-stamp", timeStamp);
    }

    @Override
    public long getIPConfigurationTimeStamp() {
        return this.extractLongValue("ip-config-time-stamp");
    }

    @Override
    public void setMatchPointConfigurations(TransactionMatchPointConfigurations configurations) {
        if (configurations == null) {
            return;
        }
        String configXML = TransactionConfigXMLConverter.getConverter().getMatchPointConfigurations(configurations);
        this.payload.put("transaction-monitoring-service", configXML);
        this.setBTNameExcludes(configurations.getExcludedTransactions());
    }

    @Override
    public String getMatchPointConfigurations() {
        return (String)this.payload.get("transaction-monitoring-service");
    }

    private void setBTNameExcludes(Collection<BusinessTransaction> btExcludes) {
        HashSet<ExcludedBT> excludedBTs = new HashSet<ExcludedBT>(btExcludes.size());
        for (BusinessTransaction btExclude : btExcludes) {
            excludedBTs.add(new ExcludedBT(btExclude.getInternalName(), btExclude.getEntryPointTypeString()));
        }
        this.payload.put("bt-exclude-configuration", excludedBTs);
    }

    @Override
    public Set<ExcludedBT> getBTNameExcludes() {
        return (Set)this.payload.get("bt-exclude-configuration");
    }

    @Override
    public void setIPConfig(MachinesIPPortConfig machinesConfig, boolean isBinary) {
        if (machinesConfig == null) {
            return;
        }
        if (!isBinary) {
            try {
                String backendTierConfig = TransactionConfigXMLConverter.getConverter().getBackendTierConfig(machinesConfig);
                this.payload.put("backend-resolution-service", backendTierConfig);
            }
            catch (ParserConfigurationException e) {
                this.logger.warn("Error instantiating XML Parser", (Throwable)e);
            }
            catch (XMLWriteException e) {
                this.logger.warn("Error creating XML", (Throwable)e);
            }
        } else {
            this.payload.put("backend-resolution-service", machinesConfig);
        }
    }

    @Override
    public MachinesIPPortConfig getBinaryIPConfig() {
        return (MachinesIPPortConfig)this.payload.get("backend-resolution-service");
    }

    @Override
    public String getIPConfig() {
        return (String)this.payload.get("backend-resolution-service");
    }

    @Override
    @Deprecated
    public void setBTIDsForOnDemandSnapshotCollection(Collection<Long> bts) {
        if (bts != null && bts.size() > 0) {
            this.payload.put("snapshot-on-demand-configuration", bts);
        }
    }

    @Override
    public void initializeAppAgent(String machineID, String componentID, String nodeID, String applicationID) {
        this.payload.put("machine-id", machineID);
        this.payload.put("component-id", componentID);
        this.setComponentNodeId(nodeID);
        this.payload.put("application-id", applicationID);
        this.payload.put("app-agent-init", Boolean.TRUE.toString());
    }

    @Override
    public void setServerId(String serverId) {
        this.payload.put("server-id", serverId);
    }

    @Override
    public void setVendorId(String vendorId) {
        this.payload.put("vendor-id", vendorId);
    }

    @Override
    public String getMachineID() {
        return (String)this.payload.get("machine-id");
    }

    @Override
    public String getComponentID() {
        return (String)this.payload.get("component-id");
    }

    @Override
    public String getApplicationID() {
        return (String)this.payload.get("application-id");
    }

    @Override
    public void setApplicationID(String applicationID) {
        this.payload.put("application-id", applicationID);
    }

    @Override
    public String getServerID() {
        return (String)this.payload.get("server-id");
    }

    @Override
    public String getVendorId() {
        return (String)this.payload.get("vendor-id");
    }

    @Override
    public boolean isFullConfigUpdateRequested() {
        Boolean val = (Boolean)this.payload.get("full-config-update-requested");
        if (val != null) {
            return val;
        }
        return false;
    }

    @Override
    public void setFullConfigUpdateRequested() {
        this.payload.put("full-config-update-requested", Boolean.TRUE);
    }

    @Override
    public boolean isAppAgentReregistrationRequested() {
        return Boolean.parseBoolean(String.valueOf(this.payload.get("app-agent-reregistration")));
    }

    @Override
    public void setReregisterAppAgent() {
        this.payload.put("app-agent-reregistration", Boolean.TRUE.toString());
    }

    @Override
    public ReregisterNodeTicket getReregisterNodeTicket() {
        return (ReregisterNodeTicket)this.payload.get("move-node-ticket");
    }

    @Override
    public void setReregisterNodeTicket(ReregisterNodeTicket ticket) {
        this.setReregisterAppAgent();
        this.payload.put("move-node-ticket", ticket);
    }

    @Override
    public boolean isInitialAgentRegistrationAttempt() {
        return Boolean.parseBoolean(String.valueOf(this.payload.get("initial-agent-registration-attempt")));
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return backOffHelper.isRequestOverConnectionLimit(errorCount);
    }

    @Override
    public void setInitialAgentRegistrationAttempt() {
        this.payload.put("initial-agent-registration-attempt", Boolean.TRUE.toString());
    }

    @Override
    public boolean hasInitializationInfo() {
        return Boolean.parseBoolean(String.valueOf(this.payload.get("app-agent-init")));
    }

    @Override
    public void setHostIdentifyingInfo(String hostInfo, String nodeUniqueLocalId) {
        this.payload.put("unique-host-identifier", hostInfo);
        if (nodeUniqueLocalId != null) {
            this.payload.put("node-unique-local-id", nodeUniqueLocalId);
        }
        this.payload.put("os-info", SystemInfo.getMachineInfo());
        this.payload.put("jvm-info", SystemInfo.getVMInfo());
        this.payload.put("app-agent-init", Boolean.TRUE.toString());
        this.payload.put("number-of-license-units", 1);
    }

    @Override
    public void setAutoResolution(boolean autoResolution) {
        this.payload.put("auto-naming-mode", autoResolution);
    }

    @Override
    public boolean isAutoResolution() {
        boolean bReturn = false;
        Boolean autoResolutionBool = (Boolean)this.payload.get("auto-naming-mode");
        if (autoResolutionBool != null) {
            bReturn = autoResolutionBool;
        }
        return bReturn;
    }

    @Override
    public String getNodeUniqueId() {
        return (String)this.payload.get("node-unique-local-id");
    }

    @Override
    public String getUniqueHostInformation() {
        return (String)this.payload.get("unique-host-identifier");
    }

    @Override
    public String getInstallDir() {
        return (String)this.payload.get("install-dir");
    }

    @Override
    public void setInstallDir(String installDir) {
        this.payload.put("install-dir", installDir);
    }

    @Override
    public String getJVMInfo() {
        return (String)this.payload.get("jvm-info");
    }

    @Override
    public String getMachineInfo() {
        return (String)this.payload.get("os-info");
    }

    @Override
    public boolean isForceAgentRegistrationConfig() {
        return Boolean.parseBoolean(String.valueOf(this.payload.get("force-agent-registration")));
    }

    @Override
    public void setForceAgentRegistrationConfig(boolean force) {
        this.payload.put("force-agent-registration", force);
    }

    @Override
    public String getApplicationName() {
        return (String)this.payload.get("application-name");
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.payload.put("application-name", applicationName);
    }

    @Override
    public String getApplicationComponentName() {
        return (String)this.payload.get("application-component-name");
    }

    @Override
    public void setApplicationComponentName(String applicationComponentName) {
        this.payload.put("application-component-name", applicationComponentName);
    }

    @Override
    public String getApplicationComponentNodeName() {
        return (String)this.payload.get("application-component-node-name");
    }

    @Override
    public void setApplicationComponentNodeName(String applicationComponentNodeName) {
        this.payload.put("application-component-node-name", applicationComponentNodeName);
    }

    @Override
    public AgentType getAgentType() {
        AgentType agentType = (AgentType)this.payload.get("agent-type");
        if (agentType == null) {
            return AgentType.APP_AGENT;
        }
        return agentType;
    }

    @Override
    public void setAgentType(AgentType agentType) {
        this.payload.put("agent-type", agentType);
    }

    public void setAgentTypeIfNull(AgentType agentType) {
        if (this.payload.get("agent-type") == null) {
            this.payload.put("agent-type", agentType);
        }
    }

    @Override
    public void setAgentVersion(String version) {
        this.payload.put("agent-version", version);
    }

    @Override
    public String getAgentVersion() {
        return (String)this.payload.get("agent-version");
    }

    @Override
    public void setServerVersion(String version) {
        this.payload.put("server-version", version);
    }

    @Override
    public String getServerVersion() {
        return (String)this.payload.get("server-version");
    }

    @Override
    public long getBTSLAConfigTimestamp() {
        return this.extractLongValue("bt-config-timestamp");
    }

    @Override
    public void setBTConfigTimestamp(long timeStamp) {
        this.payload.put("bt-config-timestamp", timeStamp);
    }

    @Override
    public long getBTSLAConfigNonOriginatingTimestamp() {
        return this.extractLongValue("bt-config-non-originating-timestamp");
    }

    @Override
    public void setBTConfigNonOriginatingTimestamp(long timeStamp) {
        this.payload.put("bt-config-non-originating-timestamp", timeStamp);
    }

    @Override
    public void setBTConfiguration(BTConfigurations btSLAConfig) {
        if (btSLAConfig == null) {
            return;
        }
        this.payload.put("bt-sla-configuration", btSLAConfig);
    }

    @Override
    public void setNonOriginatingBTConfiguration(BTConfigurations btSLAConfig) {
        if (btSLAConfig == null) {
            return;
        }
        this.payload.put("bt-continuing-sla-configuration", btSLAConfig);
    }

    @Override
    public BTConfigurations getBTConfigurations() {
        return (BTConfigurations)this.payload.get("bt-sla-configuration");
    }

    @Override
    public BTConfigurations getNonOriginatingBTConfiguration() {
        return (BTConfigurations)this.payload.get("bt-continuing-sla-configuration");
    }

    @Override
    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        if (applicationConfiguration == null) {
            return;
        }
        AgentType agentType = this.getAgentType();
        switch (agentType) {
            case PHP_APP_AGENT: {
                this.payload.put("callgraph-configuration-service", applicationConfiguration.getPhpCallGraphConfiguration());
                this.payload.put("bt-error-configuration", applicationConfiguration.getPhpErrorConfiguration());
                break;
            }
            case NATIVE_WEB_SERVER: {
                if (!this.shouldSendWebserverErrorConfig()) break;
                this.payload.put("bt-error-configuration", applicationConfiguration.getWebserverErrorConfiguration());
                break;
            }
            case NODEJS_APP_AGENT: {
                this.payload.put("callgraph-configuration-service", applicationConfiguration.getNodeJsCallGraphConfiguration());
                this.payload.put("bt-error-configuration", applicationConfiguration.getNodeJsErrorConfiguration());
                break;
            }
            case PYTHON_APP_AGENT: {
                this.payload.put("callgraph-configuration-service", applicationConfiguration.getPythonCallGraphConfiguration());
                this.payload.put("bt-error-configuration", applicationConfiguration.getPythonErrorConfiguration());
                break;
            }
            case RUBY_APP_AGENT: {
                this.payload.put("callgraph-configuration-service", applicationConfiguration.getRubyCallGraphConfiguration());
                this.payload.put("bt-error-configuration", applicationConfiguration.getRubyErrorConfiguration());
                break;
            }
            default: {
                this.payload.put("callgraph-configuration-service", applicationConfiguration.getCallGraphConfiguration());
                this.payload.put("bt-error-configuration", applicationConfiguration.getErrorConfig());
            }
        }
        this.payload.put("application-configuration-timestamp", applicationConfiguration.getLastModificationTimestamp());
        this.payload.put("sla-quiet-time", applicationConfiguration.getSnapshotQuietTimePostSLAFailureInMinutes());
        this.payload.put("bt-stall-configuration", applicationConfiguration.getDefaultTransactionConfiguration().getRequestThresholds().getStallConfig());
        this.payload.put("instrumentation-level", applicationConfiguration.getInstrumentationLevel());
        this.payload.put("use-new-async-activity-tracking", applicationConfiguration.isAsyncActivitySupported());
    }

    @Override
    public void setEUMConfiguration(EUMConfiguration config) {
        this.payload.put("eum-configuration", config);
    }

    @Override
    public EUMConfiguration getEUMConfiguration() {
        return (EUMConfiguration)this.payload.get("eum-configuration");
    }

    public boolean isUseNewAsyncActivityTracking() {
        return this.payload.containsKey("use-new-async-activity-tracking") && (Boolean)this.payload.get("use-new-async-activity-tracking") != false;
    }

    @Override
    public ApplicationConfiguration getApplicationConfiguration() {
        CallGraphConfiguration callGraphConfiguration = (CallGraphConfiguration)this.payload.get("callgraph-configuration-service");
        if (callGraphConfiguration == null) {
            return null;
        }
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
        applicationConfiguration.setCallGraphConfiguration(callGraphConfiguration);
        applicationConfiguration.setLastModificationTimestamp(this.getApplicationConfigTimestamp());
        applicationConfiguration.setStallConfig(this.getStallConfig());
        applicationConfiguration.setErrorConfig(this.getErrorConfig());
        applicationConfiguration.setInstrumentationLevel(this.getInstrumentationLevel());
        applicationConfiguration.setEumConfiguration(this.getEumConfiguration());
        applicationConfiguration.setSnapshotQuietTimePostSLAFailureInMinutes(((Integer)this.payload.get("sla-quiet-time")).intValue());
        applicationConfiguration.setAsyncActivitySupported(this.isUseNewAsyncActivityTracking());
        return applicationConfiguration;
    }

    @Override
    public void setApplicationConfigTimestamp(long timestamp) {
        this.payload.put("application-configuration-timestamp", timestamp);
    }

    @Override
    public long getApplicationConfigTimestamp() {
        return this.extractLongValue("application-configuration-timestamp");
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public NodeProperties getNodeProperties() {
        return (NodeProperties)this.payload.get("NODE_PROPERTIES");
    }

    @Override
    public void setNodeProperties(NodeProperties properties) {
        this.payload.put("NODE_PROPERTIES", properties);
    }

    @Override
    public long getDataGathererConfigTimestamp() {
        return this.extractLongValue("data-gatherer-config-timestamp");
    }

    @Override
    public void setDataGathererConfigTimestamp(long timestamp) {
        this.payload.put("data-gatherer-config-timestamp", timestamp);
    }

    @Override
    public void setDataGathererConfigurations(DataGathererConfigs configs) {
        this.payload.put("data-gatherer-config", configs);
    }

    @Override
    public DataGathererConfigs getDataGathererConfigurations() {
        return (DataGathererConfigs)this.payload.get("data-gatherer-config");
    }

    @Override
    public long getInfoPointGathererConfigTimestamp() {
        return this.extractLongValue("info-point-gatherer-config-timestamp");
    }

    @Override
    public void setInfoPointGathererConfigTimestamp(long timestamp) {
        this.payload.put("info-point-gatherer-config-timestamp", timestamp);
    }

    @Override
    public void setInfoPointGathererConfigurations(InfoPointGathererConfigs configs) {
        this.payload.put("info-point-gatherer-config", configs);
    }

    @Override
    public InfoPointGathererConfigs getInfoPointGathererConfigurations() {
        return (InfoPointGathererConfigs)this.payload.get("info-point-gatherer-config");
    }

    @Override
    public long getAsyncTransactionConfigChangeTimeStamp() {
        return this.extractLongValue("async-transaction-configs-change-timestamp");
    }

    @Override
    public void setAsyncTransactionConfigChangeTimeStamp(long asyncTransactionConfigChangeTimeStamp) {
        this.payload.put("async-transaction-configs-change-timestamp", asyncTransactionConfigChangeTimeStamp);
    }

    @Override
    public void setAsyncTransactionConfigs(AsyncTransactionConfigs asyncTransactionConfigs) {
        this.payload.put("async-transaction-configs", asyncTransactionConfigs);
    }

    @Override
    public AsyncTransactionConfigs getAsyncTransactionConfigs() {
        return (AsyncTransactionConfigs)this.payload.get("async-transaction-configs");
    }

    @Override
    public ErrorConfiguration getErrorConfig() {
        return (ErrorConfiguration)this.payload.get("bt-error-configuration");
    }

    @Override
    public StallConfiguration getStallConfig() {
        return (StallConfiguration)this.payload.get("bt-stall-configuration");
    }

    @Override
    public InstrumentationLevel getInstrumentationLevel() {
        return (InstrumentationLevel)this.payload.get("instrumentation-level");
    }

    public EUMConfiguration getEumConfiguration() {
        return (EUMConfiguration)this.payload.get("eum-configuration");
    }

    @Override
    public Map<Long, Map<Long, String[]>> getBTRuleDiagnosticSessions() {
        return (Map)this.payload.get(BT_RULE_DIAGNOSTIC_SESSIONS);
    }

    @Override
    @Deprecated
    public void setBTRuleSnapshotInfo(Map<Long, Map<Long, String>> map) {
        this.payload.put("bt-rule-snapshot-info", map);
    }

    @Override
    protected String getName() {
        return "AppAgent Config Data";
    }

    @Override
    public int getNumberOfLicenseUnits() {
        Integer numLicenseUnits = (Integer)this.payload.get("number-of-license-units");
        if (numLicenseUnits == null) {
            return 1;
        }
        return numLicenseUnits;
    }

    @Override
    public long getCustomExitPointDefTimestamp() {
        return this.extractLongValue("custom-exit-point-definition-timestamp");
    }

    @Override
    public void setCustomExitPointDefTimestamp(long ts) {
        this.payload.put("custom-exit-point-definition-timestamp", ts);
    }

    @Override
    public void setCustomExitPointDefinitions(CustomExitPointDefinitons defs) {
        this.payload.put("custom-exit-point-definitions", defs);
    }

    @Override
    public CustomExitPointDefinitons getCustomExitPointDefinitons() {
        return (CustomExitPointDefinitons)this.payload.get("custom-exit-point-definitions");
    }

    @Override
    public long getCacheConfigurationInfoTimestamp() {
        return this.extractLongValue("cache-configuration-info-timestamp");
    }

    @Override
    public long getMemoryConfigurationInfoTimestamp() {
        return this.extractLongValue("memory-configuration-info-timestamp");
    }

    @Override
    public void setCacheConfigurationInfoTimestamp(long timestamp) {
        this.payload.put("cache-configuration-info-timestamp", timestamp);
    }

    @Override
    public void setMemoryConfigurationInfoTimestamp(long timestamp) {
        this.payload.put("memory-configuration-info-timestamp", timestamp);
    }

    @Override
    public void setCacheConfigurationInfo(CacheConfigurationInfo configs) {
        this.payload.put("cache-configuration-info", configs);
    }

    @Override
    public CacheConfigurationInfo getCacheConfigurationInfo() {
        return (CacheConfigurationInfo)this.payload.get("cache-configuration-info");
    }

    @Override
    public void setMemoryConfigurationInfo(MemoryConfigurationInfo configs) {
        this.payload.put("memory-configuration-info", configs);
    }

    @Override
    public MemoryConfigurationInfo getMemoryConfigurationInfo() {
        return (MemoryConfigurationInfo)this.payload.get("memory-configuration-info");
    }

    @Override
    public long getApplicationDiagnosticDataInfoTimestamp() {
        return this.extractLongValue("application-diagnostic-data-info-timestamp");
    }

    @Override
    public void setApplicationDiagnosticDataInfo(ApplicationDiagnosticDataInfo info) {
        this.payload.put("application-diagnostic-data-info", info);
    }

    @Override
    public ApplicationDiagnosticDataInfo getApplicationDiagnosticDataInfo() {
        return (ApplicationDiagnosticDataInfo)this.payload.get("application-diagnostic-data-info");
    }

    @Override
    public void setAppAgentOperationInfo(AppAgentOperationInfo info) {
        this.payload.put("app-agent-operation-info", info);
    }

    @Override
    public AppAgentOperationInfo getAppAgentOperationInfo() {
        return (AppAgentOperationInfo)this.payload.get("app-agent-operation-info");
    }

    @Override
    public void setAppAgentOperationInfoTimestamp(long timestamp) {
        this.payload.put("app-agent-operation-info-timestamp", timestamp);
    }

    @Override
    public long getAppAgentOperationInfoTimestamp() {
        return this.extractLongValue("app-agent-operation-info-timestamp");
    }

    @Override
    public Map<Long, AppAgentOperationStatus> getAppAgentOperationStatus() {
        return (Map)this.payload.get("app-agent-operation-status");
    }

    @Override
    public void setAppAgentOperationStatus(Map<Long, AppAgentOperationStatus> opIdVsStatus) {
        this.payload.put("app-agent-operation-status", opIdVsStatus);
    }

    @Override
    public long getBackgroundTransactionsTimestamp() {
        Long timestamp = (Long)this.payload.get("background-transactions-timestamp");
        return timestamp == null ? -1L : timestamp;
    }

    @Override
    public void setBackgroundTransactionsTimestamp(long timestamp) {
        this.payload.put("background-transactions-timestamp", timestamp);
    }

    @Override
    public void setBackgroundTransactions(LatestConfigChangeInfo<Set<Long>> backgroundTransactions) {
        this.payload.put("background-transactions", backgroundTransactions);
    }

    @Override
    public LatestConfigChangeInfo<Set<Long>> getBackgroundTransactions() {
        return (LatestConfigChangeInfo)this.payload.get("background-transactions");
    }

    @Override
    public void setTransactions(Collection<BusinessTransaction> transactions) {
        this.payload.put("business-transactions", transactions);
    }

    @Override
    public Collection<BusinessTransaction> getBusinessTransactions() {
        return (Collection)this.payload.get("business-transactions");
    }

    @Override
    public void setBusinessTransactionsTimestamp(long timestamp) {
        this.payload.put("business-transactions-timestamp", timestamp);
    }

    @Override
    public long getBusinessTransactionsTimestamp() {
        return this.extractLongValue("business-transactions-timestamp");
    }

    @Override
    public void setUnResolvedBackendCallInfosMap(Map<Long, NodeResolutionInfo> calls) {
        this.payload.put("resolved-backend-calls", calls);
    }

    @Override
    public Map<Long, NodeResolutionInfo> getUnResolvedBackendCallInfosMap() {
        return (Map)this.payload.get("resolved-backend-calls");
    }

    @Override
    public void setOnDemandDiagnosticSessions(Map<Long, Object[]> map) {
        this.payload.put(ON_DEMAND_DIAGNOSTIC_SESSIONS, map);
    }

    @Override
    public Map<Long, Object[]> getOnDemandDiagnosticSessions() {
        return (Map)this.payload.get(ON_DEMAND_DIAGNOSTIC_SESSIONS);
    }

    @Override
    public String[] getVmStartupOptions() {
        return (String[])this.payload.get("vm-startup-options");
    }

    @Override
    public void setVmStartupOptions(String[] vmStartupOptions) {
        this.payload.put("vm-startup-options", vmStartupOptions);
    }

    @Override
    public NameValuePair[] getVmSystemProperties() {
        return (NameValuePair[])this.payload.get("vm-system-properties");
    }

    @Override
    public void setVmSystemProperties(NameValuePair[] vmSystemProperties) {
        this.payload.put("vm-system-properties", vmSystemProperties);
    }

    @Override
    public NameValuePair[] getEnvironmentVariables() {
        return (NameValuePair[])this.payload.get("environment-variables");
    }

    @Override
    public void setEnvironmentVariables(NameValuePair[] environmentVariables) {
        this.payload.put("environment-variables", environmentVariables);
    }

    @Override
    public void setDeletedEntities(Map<String, Set<Long>> deletedEntities) {
        this.payload.put("deleted-entities", deletedEntities);
    }

    @Override
    public Map<String, Set<Long>> getDeletedEntities() {
        return (Map)this.payload.get("deleted-entities");
    }

    @Override
    public void setJMXConfigTimeStamp(long timeStamp) {
        this.payload.put("jmx-config-time-stamp", timeStamp);
    }

    @Override
    public long getJMXTimeStamp() {
        return this.extractLongValue("jmx-config-time-stamp");
    }

    @Override
    public String[] getJMXDomains() {
        return (String[])this.payload.get("jmx-domains");
    }

    @Override
    public void setJMXDomains(String[] domains) {
        this.payload.put("jmx-domains", domains);
    }

    @Override
    public JMXMetricRule[] getJMXConfig() {
        return (JMXMetricRule[])this.payload.get("jmx-config");
    }

    @Override
    public void setJMXConfig(JMXMetricRule[] rules) {
        this.payload.put("jmx-config", rules);
    }

    @Override
    public JMXMetricRule[] getUpdatedJMXConfig() {
        return (JMXMetricRule[])this.payload.get("jmx-updated-config");
    }

    @Override
    public void setUpdatedJMXConfig(JMXMetricRule[] rules) {
        this.payload.put("jmx-updated-config", rules);
    }

    @Override
    public NameValuePair[] getNodeMetaInfo() {
        return (NameValuePair[])this.payload.get("node-meta-info");
    }

    @Override
    public void setNodeMetaInfo(NameValuePair[] nodeMetaData) {
        this.payload.put("node-meta-info", nodeMetaData);
    }

    @Override
    public String getNodeNamePrefix() {
        return (String)this.payload.get("node-name-prefix");
    }

    @Override
    public boolean isReuseNodeName() {
        return Boolean.parseBoolean((String)this.payload.get("reuse-node-name"));
    }

    @Override
    public void setReuseNodeName(String prefix) {
        this.payload.put("reuse-node-name", "true");
        this.payload.put("node-name-prefix", prefix);
    }

    @Override
    public void setAccountEdition(String accountEdition) {
        this.payload.put("account-edition", accountEdition);
    }

    @Override
    public String getAccountEdition() {
        return (String)this.payload.get("account-edition");
    }

    @Override
    public void setControllerVersion(String controllerVersion) {
        this.payload.put("controller-version", controllerVersion);
    }

    @Override
    public String getControllerVersion() {
        return (String)this.payload.get("controller-version");
    }

    @Override
    public void setControllerProfile(String profile) {
        this.payload.put("controller-profile", profile);
    }

    @Override
    public String getControllerProfile() {
        return (String)this.payload.get("controller-profile");
    }

    @Override
    public void setAccountProfile(AccountProfile accountProfile) {
        this.payload.put("account-profile", accountProfile);
    }

    @Override
    public AccountProfile getAccountProfile() {
        return (AccountProfile)this.payload.get("account-profile");
    }

    @Override
    public Map<String, Object> getPayload() {
        return this.payload;
    }

    @Override
    public void setPayload(Map<String, Object> toSet) {
        this.payload.clear();
        this.payload.putAll(toSet);
    }

    @Override
    public void setAccountProfileTimestamp(long timestamp) {
        this.payload.put("account-profile-timestamp", timestamp);
    }

    @Override
    public long getAccountProfileTimestamp() {
        return this.extractLongValue("account-profile-timestamp");
    }

    @Override
    public void setThreadTasks(Collection<ApplicationDiagnosticData> threadTasks) {
        this.payload.put("thread-tasks", threadTasks);
    }

    @Override
    public Collection<ApplicationDiagnosticData> getThreadTasks() {
        return (Collection)this.payload.get("thread-tasks");
    }

    @Override
    public void setStopAgentFromReporting(boolean stopReporting) {
        this.payload.put("stop-agent-from-reporting", stopReporting);
    }

    @Override
    public boolean isStopAgentFromReporting() {
        return Boolean.parseBoolean(String.valueOf(this.payload.get("stop-agent-from-reporting")));
    }

    @Override
    public void setExitCallInfoRequest(AppAgentExitCallInfo exitCallInfo) {
        this.payload.put("new-backend-resolution-service", exitCallInfo);
    }

    @Override
    public AppAgentExitCallInfo getExitCallInfoRequest() {
        return (AppAgentExitCallInfo)this.payload.get("new-backend-resolution-service");
    }

    @Override
    public AppAgentExitCallInfo getExitCallInfoResponse() {
        return (AppAgentExitCallInfo)this.payload.get("new-backend-resolution-service");
    }

    @Override
    public void setExitCallInfoResponse(AppAgentExitCallInfo exitCallInfo) {
        this.payload.put("new-backend-resolution-service", exitCallInfo);
    }

    @Override
    public void setMaxMetricNameLength(int value) {
        this.payload.put("max-metric-name-length", new Integer(value));
    }

    @Override
    public int getMaxMetricNameLength() {
        int value = this.extractIntValue("max-metric-name-length");
        if (value <= 0) {
            return 750;
        }
        return value;
    }

    @Override
    public void setHotspotConfiguration(String hotspotConfig) {
        this.payload.put("hspot-config", hotspotConfig);
    }

    @Override
    public String getHotspotConfiguration() {
        return (String)this.payload.get("hspot-config");
    }

    @Override
    public void setHotspotConfigurationTimeStamp(long timestamp) {
        this.payload.put("hspot-config-timestamp", timestamp);
    }

    @Override
    public long getHotspotConfigurationTimeStamp() {
        return this.extractLongValue("hspot-config-timestamp");
    }

    @Override
    public void setServiceEndPointConfigurationsTimeStamp(long timeStamp) {
        this.payload.put("service-end-points-timestamp", timeStamp);
    }

    @Override
    public long getServiceEndPointConfigurationsTimeStamp() {
        return this.extractLongValue("service-end-points-timestamp");
    }

    @Override
    public void setServiceEndPointDefinitions(ServiceEndpointDefinition[] serviceEndPointDefinitions) {
        this.payload.put("service-end-points", serviceEndPointDefinitions);
    }

    @Override
    public void setServiceEndpointMatchConfigs(ServiceEndpointMatchConfig[] serviceEndpointMatchConfigs) {
        this.payload.put("service-end-points-configurations", serviceEndpointMatchConfigs);
    }

    @Override
    public ServiceEndpointMatchConfig[] getServiceEndpointMatchConfigs() {
        return (ServiceEndpointMatchConfig[])this.payload.get("service-end-points-configurations");
    }

    @Override
    public ServiceEndpointDefinition[] getServiceEndPointDefinitions() {
        return (ServiceEndpointDefinition[])this.payload.get("service-end-points");
    }

    @Override
    public void setProcessSnapshotRequestsTimeStamp(long timeStamp) {
        this.payload.put("process-snapshot-request-timestamp", timeStamp);
    }

    @Override
    public void setProcessSnapshotRequests(ProcessSnapshotNodeRequest[] processSnapshotRequests) {
        this.payload.put("process-snapshot-requests", processSnapshotRequests);
    }

    @Override
    public long getProcessSnapshotRequestsTimeStamp() {
        return this.extractLongValue("process-snapshot-request-timestamp");
    }

    @Override
    public ProcessSnapshotNodeRequest[] getProcessSnapshotRequests() {
        return (ProcessSnapshotNodeRequest[])this.payload.get("process-snapshot-requests");
    }

    @Override
    public void setAccountGUID(String accountGUID) {
        this.payload.put("account-guid", accountGUID);
    }

    @Override
    public String getAccountGUID() {
        return (String)this.payload.get("account-guid");
    }

    @Override
    public void setControllerGUID(String ctrlGUID) {
        this.payload.put("controller-guid", ctrlGUID);
    }

    @Override
    public String getControllerGUID() {
        return (String)this.payload.get("controller-guid");
    }

    @Override
    public LatestConfigChangeInfo<Set<Long>> getAnalyticsEnabledBTs() {
        return (LatestConfigChangeInfo)this.payload.get("analytics-enabled-transactions");
    }

    @Override
    public LatestConfigChangeInfo<Set<Long>> getLogGuidInjectionEnabledBTs() {
        return (LatestConfigChangeInfo)this.payload.get("log-guid-injection-enabled-transactions");
    }

    @Override
    public long getAnalyticsEnabledBTsTimestamp() {
        Long timestamp = (Long)this.payload.get("analytics-enabled-transactions-timestamp");
        return timestamp == null ? -1L : timestamp;
    }

    @Override
    public long getLogGuidInjectionEnabledBTsTimestamp() {
        Long timestamp = (Long)this.payload.get("log-guid-injection-timestamp");
        return timestamp == null ? -1L : timestamp;
    }

    @Override
    public void setAnalyticsEnabledBTs(LatestConfigChangeInfo<Set<Long>> analyticsEnabledBTs) {
        this.payload.put("analytics-enabled-transactions", analyticsEnabledBTs);
    }

    @Override
    public void setLogGuidInjectionEnabledBTs(LatestConfigChangeInfo<Set<Long>> logGuidInjectionEnabledBTs) {
        this.payload.put("log-guid-injection-enabled-transactions", logGuidInjectionEnabledBTs);
    }

    @Override
    public void setAnalyticsEnabledBTsTimestamp(long timestamp) {
        this.payload.put("analytics-enabled-transactions-timestamp", timestamp);
    }

    @Override
    public void setLogGuidInjectionTimestamp(long timestamp) {
        this.payload.put("log-guid-injection-timestamp", timestamp);
    }

    @Override
    public void setCrossAppResolutionEnabled(boolean enabled) {
        this.payload.put("cross-app-resolution-enabled", enabled);
    }

    @Override
    public boolean isCrossAppResolutionEnabled() {
        Boolean val = (Boolean)this.payload.get("cross-app-resolution-enabled");
        if (val != null) {
            return val;
        }
        return false;
    }

    @Override
    public void setDiscoveredBTLimit(int limit) {
        this.payload.put("discovered-bt-limit", limit);
    }

    @Override
    public int getDiscoveredBTLimit() {
        return this.extractIntValue("discovered-bt-limit");
    }

    @Override
    public long getAnalyticsDataGathererConfigTimestamp() {
        return this.extractLongValue("analytics-data-gatherer-config-timestamp");
    }

    @Override
    public void setAnalyticsDataGathererConfigurations(DataGathererConfigs configs) {
        this.payload.put("analytics-data-gatherer-config", configs);
    }

    @Override
    public void setAnalyticsDataGathererConfigTimestamp(long timestamp) {
        this.payload.put("analytics-data-gatherer-config-timestamp", timestamp);
    }

    @Override
    public DataGathererConfigs getAnalyticsDataGathererConfigurations() {
        return (DataGathererConfigs)this.payload.get("analytics-data-gatherer-config");
    }

    @Override
    public void setAgentDisabled(boolean disabled) {
        this.payload.put("agent-disabled", disabled);
    }

    @Override
    public boolean isAgentDisabled() {
        Boolean val = (Boolean)this.payload.get("agent-disabled");
        if (val != null) {
            return val;
        }
        return false;
    }

    @Override
    public void markComplete() {
    }

    @Override
    public void setAnalyticsConfig(AnalyticsConfig config) {
        this.payload.put("analytics-config", config);
    }

    @Override
    public AnalyticsConfig getAnalyticsConfig() {
        return (AnalyticsConfig)this.payload.get("analytics-config");
    }

    @Override
    public long getAnalyticsConfigTimestamp() {
        return this.extractLongValue("analytics-config-timestamp");
    }

    @Override
    public void setAnalyticsConfigTimestamp(long timestamp) {
        this.payload.put("analytics-config-timestamp", timestamp);
    }

    @Override
    public void setFederationConfig(FederationFriendsConfig config) {
        this.payload.put("federation-config", config);
    }

    @Override
    public FederationFriendsConfig getFederationConfig() {
        return (FederationFriendsConfig)this.payload.get("federation-config");
    }

    @Override
    public long getFederationConfigTimestamp() {
        return this.extractLongValue("federation-config-timestamp");
    }

    @Override
    public void setFederationConfigTimestamp(long timestamp) {
        this.payload.put("federation-config-timestamp", timestamp);
    }

    @Override
    public void setFederationConfigExists(boolean federationConfigExists) {
        this.payload.put("federation-config-exists", federationConfigExists);
    }

    @Override
    public boolean doesFederationConfigExists() {
        return Boolean.parseBoolean(String.valueOf(this.payload.get("federation-config-exists")));
    }

    @Override
    public AnalyticsDynamicServiceConfig getAnalyticsDynamicServiceConfig() {
        return (AnalyticsDynamicServiceConfig)this.payload.get("analytics-dynamic-service-config");
    }

    @Override
    public void setAnalyticsDynamicServiceConfig(AnalyticsDynamicServiceConfig config) {
        this.payload.put("analytics-dynamic-service-config", config);
    }

    @Override
    public long getAnalyticsDynamicServiceConfigTimestamp() {
        return this.extractLongValue("analytics-dynamic-service-config-timestamp");
    }

    @Override
    public void setAnalyticsDynamicServiceConfigTimestamp(long timestamp) {
        this.payload.put("analytics-dynamic-service-config-timestamp", timestamp);
    }

    @Override
    public AnalyticsBTTypeConversionConfigs getAnalyticsBTTypeConversionConfig() {
        return (AnalyticsBTTypeConversionConfigs)this.payload.get("analytics-bt-type-conversion-config");
    }

    @Override
    public void setAnalyticsBTTypeConversionConfig(AnalyticsBTTypeConversionConfigs config) {
        this.payload.put("analytics-bt-type-conversion-config", config);
    }

    @Override
    public long getAnalyticsBTTypeConversionConfigTimestamp() {
        return this.extractLongValue("analytics-bt-type-conversion-config-timestamp");
    }

    @Override
    public void setAnalyticsBTTypeConversionConfigTimestamp(long timestamp) {
        this.payload.put("analytics-bt-type-conversion-config-timestamp", timestamp);
    }

    @Override
    public void setMdsBasedNamingConfiguration(byte[] namingConfiguration) {
    }

    @Override
    public void setAutoDiscoveryBackendConfig(byte[] autoDiscoveryBackendConfig) {
    }

    @Override
    public long getAutoDiscoveryBackendConfigTimestamp() {
        return this.extractLongValue("auto-discovery-backend-conf-timestamp");
    }

    @Override
    public void addOrUpdateSupportedFeatures(Map<String, Boolean> agentSupportedFeatures) {
        HashMap<String, Boolean> existingAgentSupportedFeatures = (HashMap<String, Boolean>)this.payload.get("agent-supported-features");
        if (existingAgentSupportedFeatures == null) {
            existingAgentSupportedFeatures = new HashMap<String, Boolean>();
        }
        existingAgentSupportedFeatures.putAll(agentSupportedFeatures);
        this.payload.put("agent-supported-features", existingAgentSupportedFeatures);
    }

    @Override
    public AgentSupportedFeatures getAgentSupportedFeatures() {
        Map agentSupportedFeatures = (Map)this.payload.get("agent-supported-features");
        AgentSupportedFeatures.Builder agentSupportedFeaturesBuilder = AgentSupportedFeatures.builder();
        if (agentSupportedFeatures != null) {
            if (agentSupportedFeatures.containsKey("backend-config-v2") && ((Boolean)agentSupportedFeatures.get("backend-config-v2")).booleanValue()) {
                agentSupportedFeaturesBuilder.setSupportsBackendConfigV2(true);
            }
            if (agentSupportedFeatures.containsKey("analytics-bt-type-conversion") && ((Boolean)agentSupportedFeatures.get("analytics-bt-type-conversion")).booleanValue()) {
                agentSupportedFeaturesBuilder.setSupportsAnalyticsBtTypeConversion(true);
            }
            if (agentSupportedFeatures.containsKey("transaction-match-point-config-v2") && ((Boolean)agentSupportedFeatures.get("transaction-match-point-config-v2")).booleanValue()) {
                agentSupportedFeaturesBuilder.setSupportsTransactionMatchPointConfigV2(true);
            }
            if (agentSupportedFeatures.containsKey("agentless-analytics-v1") && ((Boolean)agentSupportedFeatures.get("agentless-analytics-v1")).booleanValue()) {
                agentSupportedFeaturesBuilder.setSupportsAgentlessAnalytics(true);
            }
            if (agentSupportedFeatures.containsKey("auto-data-collection-v1") && ((Boolean)agentSupportedFeatures.get("auto-data-collection-v1")).booleanValue()) {
                agentSupportedFeaturesBuilder.setSupportsAutoDataCollection(true);
            }
            if (agentSupportedFeatures.containsKey("service-monitoring") && ((Boolean)agentSupportedFeatures.get("service-monitoring")).booleanValue()) {
                agentSupportedFeaturesBuilder.setSupportsServiceMonitoring(true);
            }
        }
        return agentSupportedFeaturesBuilder.build();
    }

    @Override
    public void setTransactionMatchPointConfig(byte[] transactionMatchPointConfig) {
    }

    @Override
    public Integer getNumberOfVirtualCpus() {
        return null;
    }

    @Override
    public void markEphemeral() {
        this.payload.put("ephemeral-node", "true");
    }

    @Override
    public boolean isEphemeral() {
        return Boolean.parseBoolean((String)this.payload.get("ephemeral-node"));
    }

    private boolean shouldSendWebserverErrorConfig() {
        String agentVersion = this.getAgentVersion();
        AgentVersion version = new AgentVersion(agentVersion);
        return version.getMajorRelease() > 23 || version.getMajorRelease() >= 23 && version.getMinorRelease() > 8;
    }

    @Override
    public void setTags(TagInfoSet tags) {
        this.payload.put("tags", tags);
    }

    @Override
    public TagInfoSet getTags() {
        return (TagInfoSet)this.payload.get("tags");
    }
}

