/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessKeyHelper {
    private static final Logger logger = LoggerFactory.getLogger(AccessKeyHelper.class);

    public String getAccessKey(HttpServletRequest servletRequest, String machineIdentifier) {
        String basicAuth = servletRequest.getHeader("authorization");
        return this.getAccessKey(basicAuth, machineIdentifier);
    }

    public String getAccessKey(String basicAuth, String machineIdentifier) {
        try {
            String password;
            if (basicAuth == null || !basicAuth.startsWith("Basic")) {
                logger.info("Invalid authorization header from machine: " + machineIdentifier);
                return null;
            }
            String decoded = new String(Base64.decodeBase64((String)basicAuth.substring(6)));
            int delimiterIndex = decoded.indexOf(58);
            if (delimiterIndex == -1) {
                logger.info("Invalid credentials from machine: " + machineIdentifier);
                return null;
            }
            String usernameAndAccount = decoded.substring(0, delimiterIndex);
            String string = password = delimiterIndex == decoded.length() - 1 ? "" : decoded.substring(delimiterIndex + 1);
            if (!usernameAndAccount.startsWith("singularity-agent@")) {
                logger.info("Invalid username and account from machine: " + machineIdentifier);
                return null;
            }
            return password;
        }
        catch (Exception e) {
            logger.warn("Error reading access key", (Throwable)e);
            return null;
        }
    }
}

