/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentRequest;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.logging.ILogger;
import javax.servlet.http.HttpServletRequest;

public abstract class ATimestampRequest
extends AControllerRequest
implements IAppAgentRequest {
    public static final String TIMESTAMP = "timestamp";

    public ATimestampRequest(String controllerHost, int controllerPort, String machineId, ILogger logger) {
        super(controllerHost, controllerPort, machineId, logger);
    }

    public ATimestampRequest(HttpServletRequest request, ILogger logger) throws RequestReadException {
        super(request, logger);
    }

    public ATimestampRequest(ILogger logger) {
        super(logger);
    }

    public void addTimeStamp() {
        this.addArgumentWithNoAttributes(TIMESTAMP, String.valueOf(ClockUtils.getCurrentTime()));
    }

    public boolean isTimeStampAvailable() {
        return this.getValueForArgument(TIMESTAMP) != null;
    }

    public long getTimeStamp() {
        return Long.parseLong(this.getValueForArgument(TIMESTAMP));
    }

    @Override
    public long getComponentNodeId() {
        String nodeId = this.getValueForArgument("node-id");
        if (nodeId != null) {
            return Long.parseLong(nodeId);
        }
        return 0L;
    }

    @Override
    public void setComponentNodeId(String id) {
        this.addArgumentWithNoAttributes("node-id", id);
    }

    public String toString() {
        return this.getRequestArguments().toString();
    }
}

