/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.agent.AgentAccountInfoStore;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.events.ResponsePiggyBackObject;
import com.singularity.ee.rest.RESTRequest;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.controller.request.AccessKeyHelper;
import com.singularity.ee.rest.controller.request.spi.IAppAgentRequest;
import com.singularity.ee.rest.controller.request.spi.controller.IControllerRequest;
import com.singularity.ee.util.httpclient.HttpClientUtils;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.keystore.AsymmetricKeysStoreWrapper;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapperFactory;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.system.SystemUtils;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpRequestRetryHandler;

public abstract class AControllerRequest
extends RESTRequest
implements IControllerRequest {
    public static final String JCEKS_FORMAT = "JCEKS";
    public static final String APPDYNAMICS_SSL_PROTOCOL_SYS_PROP = "appdynamics.agent.ssl.protocol";
    public static final String CONTROLLER_URI_PREFIX = "/controller/instance/";
    public static final String CONTROLLER_REST_URI_PREFIX = "/controller/rest/";
    public static final String CONTROLLER_FILE_DOWNLOAD_URI = "/controller/FileUploadServlet?fileId=";
    public static final String CONTROLLER_FILE_UPLOAD_URI = "/controller/FileUploadServlet?";
    public static final int CONTROLLER_URI_PREFIX_LENGTH = "/controller/instance/".length();
    private static final int DEFAULT_ERROR_COUNT_LIMIT = 5;
    public static final String ERROR_COUNT_LIMIT_PROPERTY = "appdynamics.http.connectionErrorLimit";
    public static final int ERROR_COUNT_LIMIT = Integer.getInteger("appdynamics.http.connectionErrorLimit", 5);
    protected static final String ACCOUNT_KEY = "account-key";
    protected static final String ACCOUNT_ACCESS_KEY = "account-access-key";
    protected static volatile SimpleHttpClientWrapper httpClient;
    private static final ConcurrentHashMap<String, String> accountNameVsKey;
    protected String machineId;
    private String remoteAddr;
    private String remoteHost;
    private String accessKey;

    public AControllerRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(CONTROLLER_URI_PREFIX + machineId, httpClient, logger);
        this.machineId = machineId;
    }

    protected AControllerRequest(String controllerHost, int port, long fileId, ILogger logger) {
        super(CONTROLLER_FILE_DOWNLOAD_URI + fileId, httpClient, logger);
    }

    public AControllerRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, httpClient, logger);
        this.remoteAddr = servletRequest.getRemoteAddr();
        this.remoteHost = servletRequest.getRemoteHost();
        this.machineId = this.url.substring(CONTROLLER_URI_PREFIX_LENGTH, this.url.indexOf(47, CONTROLLER_URI_PREFIX_LENGTH));
        this.accessKey = new AccessKeyHelper().getAccessKey(servletRequest, this.machineId);
    }

    public AControllerRequest(ILogger logger) {
        super(httpClient, logger);
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }

    @VisibleForTesting
    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    @Override
    public HttpExecutionResponse sendRequest() {
        this.setAccountKey(this.getAccountKeyFromRegistry());
        return super.sendRequest();
    }

    public static void registerAccountKey(String accountName, String key) {
        if (accountName == null || accountName.trim().length() == 0) {
            throw new IllegalArgumentException("Account name is not specified");
        }
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("Account key is not specified");
        }
        accountNameVsKey.put(accountName, key);
    }

    private String getAccountKeyFromRegistry() {
        return accountNameVsKey.get(AgentAccountInfoStore.getInstance().getAccountName());
    }

    @Override
    public String getAccountKey() {
        return this.getValueForArgument(ACCOUNT_KEY);
    }

    @Override
    public void setAccountKey(String key) {
        this.addArgumentWithNoAttributes(ACCOUNT_KEY, key);
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Deprecated
    public static SimpleHttpClientWrapper setupHttpClientWrapper(ControllerInfo controllerInfo, ILogger logger) {
        return AControllerRequest.setupHttpClientWrapper(controllerInfo, logger, false, null, null, null);
    }

    public static SimpleHttpClientWrapper setupHttpClientWrapper(ControllerInfo controllerInfo, ILogger logger, boolean forceDefaultSSLCertificateValidation, KeyStore keystore, IAgentScheduledExecutorService scheduler, AsymmetricKeysStoreWrapper asymmetricKeysStore) {
        httpClient = AControllerRequest.createHttpClientWrapper(controllerInfo, logger, forceDefaultSSLCertificateValidation, keystore, scheduler, System.getProperties(), asymmetricKeysStore);
        return httpClient;
    }

    public static SimpleHttpClientWrapper createHttpClientWrapper(ControllerInfo controllerInfo, ILogger logger, boolean forceDefaultSSLCertificateValidation, KeyStore keystore, IAgentScheduledExecutorService scheduler, Properties properties, AsymmetricKeysStoreWrapper asymmetricKeysStore) {
        return AControllerRequest.createHttpClientWrapper(controllerInfo, logger, forceDefaultSSLCertificateValidation, keystore, scheduler, properties, asymmetricKeysStore, null);
    }

    public static SimpleHttpClientWrapper createHttpClientWrapper(ControllerInfo controllerInfo, ILogger logger, boolean forceDefaultSSLCertificateValidation, KeyStore keystore, IAgentScheduledExecutorService scheduler, Properties properties, AsymmetricKeysStoreWrapper asymmetricKeysStore, HttpRequestRetryHandler httpRequestRetryHandler) {
        if (logger == null) {
            logger = new SysOutLogger("AppDynamics.HttpClientWrapper");
        }
        KeyStoreBasedEncryptionWrapper encryptionWrapper = null;
        try {
            if (controllerInfo.getUseEncryptedCredentials()) {
                String credentialStoreFileName = controllerInfo.getCredentialStoreFilename();
                String obfuscatedStorePassword = controllerInfo.getCredentialStorePassword();
                String credentialStoreFileFormat = controllerInfo.getCredentialStoreFormat();
                encryptionWrapper = new KeyStoreBasedEncryptionWrapperFactory().createWithObfuscatedPassword(credentialStoreFileName, obfuscatedStorePassword, credentialStoreFileFormat != null && credentialStoreFileFormat.length() > 0 ? credentialStoreFileFormat : JCEKS_FORMAT);
            }
        }
        catch (Exception allExceptions) {
            throw new IllegalStateException("HttpClient failed to create EncryptionWrapper. ", allExceptions);
        }
        SimpleHttpClientWrapper clientWrapper = httpRequestRetryHandler != null ? new SimpleHttpClientWrapper(logger, controllerInfo.isSslEnabled(), controllerInfo.getValidation(), keystore, forceDefaultSSLCertificateValidation, AControllerRequest.getValidTLSProtocol(logger), scheduler, properties, encryptionWrapper, asymmetricKeysStore, httpRequestRetryHandler) : new SimpleHttpClientWrapper(logger, controllerInfo.isSslEnabled(), controllerInfo.getValidation(), keystore, forceDefaultSSLCertificateValidation, AControllerRequest.getValidTLSProtocol(logger), scheduler, properties, encryptionWrapper, asymmetricKeysStore);
        AgentAccountInfoStore accountInfoStore = AgentAccountInfoStore.getInstance();
        String accountName = accountInfoStore.getAccountName();
        String accountAccessKey = accountInfoStore.getAccountAccessKey();
        clientWrapper.authenticateHost(controllerInfo.getControllerHostName(), controllerInfo.getControllerPort(), "controller_realm", "singularity-agent@" + accountName, accountAccessKey, true, controllerInfo.getSslEnabled() != null && controllerInfo.getSslEnabled().get());
        if (accountName == null || accountAccessKey == null) {
            logger.warn("Agent is not configured with controller authentication credentials!");
        }
        return clientWrapper;
    }

    public boolean isAppAgentRequest() {
        if (this instanceof IAppAgentRequest) {
            return ((IAppAgentRequest)((Object)this)).getComponentNodeId() > 0L;
        }
        return false;
    }

    @Override
    public void setPiggyBackObject(ResponsePiggyBackObject object) {
    }

    @Override
    public void logRequest(boolean agentSide) {
    }

    @Override
    public void logResponse(int length, boolean agentSide) {
    }

    @Override
    public void setContextualLoggingEnabled(boolean enabled) {
        this.addArgumentWithNoAttributes("contextual-logging", Boolean.valueOf(true).toString());
    }

    public static SimpleHttpClientWrapper getClient() {
        return httpClient;
    }

    @Override
    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return errorCount >= ERROR_COUNT_LIMIT;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    private static String getValidTLSProtocol(ILogger logger) {
        String tlsProtocol = SystemUtils.getProperty((String)APPDYNAMICS_SSL_PROTOCOL_SYS_PROP, (String)SystemInfo.getDefaultHttpsProtocol(logger));
        if (HttpClientUtils.isProtocolUnsafe(tlsProtocol)) {
            throw new SecurityException("Cannot use the specified TLS protocol, specify or configure a secure TLS protocol");
        }
        return tlsProtocol;
    }

    static {
        accountNameVsKey = new ConcurrentHashMap();
    }
}

