/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.controller.request;

import com.singularity.ee.events.ResponsePiggyBackObject;
import com.singularity.ee.rest.RESTRequestTrackingManager;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AControllerRequest;
import com.singularity.ee.rest.controller.request.spi.IAgentRequest;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.serialize.ObjectSerializerFactory;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ABinaryControllerRequest
extends AControllerRequest
implements IAgentRequest {
    private int byteCount = 0;
    public static volatile ILogger executionTimeLogger = null;

    public ABinaryControllerRequest(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        super(logger);
        if (response.isStatusNotOk() || response.isExceptionHappened()) {
            throw new ResponseReadException("Error in HTTP Communication - " + response.getExceptionMessage());
        }
        try {
            byte[] content = response.getResponseBytes();
            this.byteCount = content.length;
            this.constructPaylodFromInput(content, logger, false, true);
        }
        catch (Exception e) {
            logger.debug("In " + this.getName() + " error in reading data from servlet response reading byte[], size :" + this.byteCount + ", error " + this.getExceptionString(e));
            throw new ResponseReadException(e);
        }
        if ("Failure".equals(this.payload.get("STATUS"))) {
            throw new ResponseReadException("Error in controller in processing binary request " + this.getName() + "  - " + this.payload.get("Status Message"));
        }
    }

    public ABinaryControllerRequest(ILogger logger) {
        super(logger);
    }

    public ABinaryControllerRequest(String controllerHost, int port, String machineId, ILogger logger) {
        super(controllerHost, port, machineId, logger);
    }

    public ABinaryControllerRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
    }

    @Override
    protected void parseServletRequestTracked(HttpServletRequest servletRequest) throws RequestReadException {
        try {
            byte[] content = FileUtil.inputStreamToByteArray((InputStream)servletRequest.getInputStream(), (int)servletRequest.getContentLength());
            this.byteCount = content.length;
            this.constructPaylodFromInput(content, this.logger, true, false);
        }
        catch (EOFException e) {
            String exceptionMsg = "Error in reading byte[], size :" + this.byteCount + ", servlet request content length " + servletRequest.getContentLength() + ", error :" + this.getExceptionString(e) + " for machine id:" + this.getMachineId();
            throw new RequestReadException(exceptionMsg, e);
        }
        catch (IOException e) {
            throw new RequestReadException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RequestReadException(e);
        }
    }

    private void constructPaylodFromInput(byte[] content, ILogger logger, boolean request, boolean agentSide) throws IOException, ClassNotFoundException {
        if (RESTRequestTrackingManager.restRequestTrackingEnabled()) {
            long startTime = System.nanoTime();
            this.constructPaylodFromInputTracked(content, logger, request, agentSide);
            long endTime = System.nanoTime();
            RESTRequestTrackingManager.reportReadResponse(this.getClass(), startTime, endTime, this.getByteCount());
        } else {
            this.constructPaylodFromInputTracked(content, logger, request, agentSide);
        }
    }

    private void constructPaylodFromInputTracked(byte[] content, ILogger logger, boolean request, boolean agentSide) throws IOException, ClassNotFoundException {
        if (content != null && content.length > 0) {
            this.payload.putAll((Map)ObjectSerializerFactory.getSerializer().unmarshalObject(content));
        }
        if (request) {
            this.logRequest(agentSide);
        } else {
            this.logResponse(content.length, agentSide);
        }
    }

    @Override
    public void setAccountKey(String accountKey) {
        this.payload.put("account-key", accountKey == null ? "" : accountKey);
    }

    @Override
    public String getAccountKey() {
        return (String)this.payload.get("account-key");
    }

    @Override
    protected HttpExecutionRequest generateRequest() throws IOException {
        this.logRequest(true);
        HttpExecutionRequest request = new HttpExecutionRequest(this.url, this.payload);
        request.setResponseInBinary(true);
        return request;
    }

    @Override
    protected int writeToResponseTracked(HttpServletResponse response) throws IOException {
        long startTime = System.currentTimeMillis();
        int contentLength = 0;
        long marshalTime = 0L;
        long writeTime = 0L;
        ServletOutputStream out = null;
        try {
            response.setStatus(200);
            out = response.getOutputStream();
            if (this.payload.size() > 0) {
                long marshalStartTime = System.currentTimeMillis();
                byte[] content = ObjectSerializerFactory.getSerializer().marshalObject((Object)this.payload);
                marshalTime = System.currentTimeMillis() - marshalStartTime;
                contentLength = content.length;
                this.byteCount = content.length;
                response.setContentLength(contentLength);
                long writeStartTime = System.currentTimeMillis();
                out.write(content);
                writeTime = System.currentTimeMillis() - writeStartTime;
            } else {
                response.setContentLength(contentLength);
            }
            out.flush();
            this.logResponse(contentLength, false);
            int marshalStartTime = contentLength;
            return marshalStartTime;
        }
        catch (IOException e) {
            response.setStatus(500);
            throw e;
        }
        finally {
            ILogger timeLogger;
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    this.logger.debug("Error in closing stream ", (Throwable)ex);
                }
            }
            if ((timeLogger = executionTimeLogger) != null) {
                if (timeLogger.isDebugEnabled()) {
                    timeLogger.debug("|write-total-time|" + (System.currentTimeMillis() - startTime) + "|marshal-time|" + marshalTime + "|content-length|" + contentLength + "|write-time|" + writeTime + "|");
                }
                if (timeLogger.isTraceEnabled() && contentLength > 1000000) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("content-length|" + contentLength);
                    for (Map.Entry entry : this.payload.entrySet()) {
                        byte[] content = ObjectSerializerFactory.getSerializer().marshalObject(entry.getValue());
                        stringBuilder.append("|key|" + (String)entry.getKey() + "|size|" + content.length);
                    }
                    timeLogger.trace(stringBuilder.toString());
                }
            }
        }
    }

    @Override
    public void setComponentNodeId(String nodeId) {
        this.payload.put("node-id", nodeId);
    }

    @Override
    public long getComponentNodeId() {
        String nodeId = (String)this.payload.get("node-id");
        try {
            return nodeId == null ? 0L : Long.parseLong(nodeId);
        }
        catch (NumberFormatException e) {
            this.logger.debug("Error in parsing nodeId " + nodeId, (Throwable)e);
            return -1L;
        }
    }

    public boolean isComponentNodeSet() {
        return this.payload.get("node-id") != null;
    }

    public void sendSuccessMessage(HttpServletResponse response, String msg, boolean flushResponse) throws IOException {
        this.setStatusSuccess();
        this.setStatusMessage(msg);
        if (flushResponse) {
            this.writeToResponse(response);
        }
    }

    public void sendErrorMessage(HttpServletResponse response, String msg) throws IOException {
        this.setStatusFailure();
        this.setStatusMessage(msg);
        this.writeToResponse(response);
    }

    public void setStatusSuccess() {
        this.payload.put("STATUS", "Success");
    }

    public void setStatusFailure() {
        this.payload.put("STATUS", "Failure");
    }

    public void setStatusMessage(String msg) {
        this.payload.put("Status Message", msg);
    }

    @Override
    public String getStatusMessage() {
        return (String)this.payload.get("Status Message");
    }

    @Override
    public boolean isStatusSuccess() {
        String status = (String)this.payload.get("STATUS");
        return status == null ? true : status.equals("Success");
    }

    protected final long extractLongValue(String key) {
        Long timestamp = (Long)this.payload.get(key);
        return timestamp == null ? -1L : timestamp;
    }

    protected final int extractIntValue(String key) {
        Integer timestamp = (Integer)this.payload.get(key);
        return timestamp == null ? -1 : timestamp;
    }

    @Override
    public final void logRequest(boolean agentSide) {
        if (this.logToConsole) {
            System.out.println("REST - " + (agentSide ? "Sending" : "Reading") + " Binary request - URL [" + this.url + "] \n Payload -\n" + this.toStringPayload());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST - " + (agentSide ? "Sending" : "Reading") + " Binary request - URL [" + this.url + "] \n" + this.toStringPayload());
        }
    }

    @Override
    public final void logResponse(int length, boolean agentSide) {
        if (this.logToConsole) {
            System.out.println("REST - " + (agentSide ? "Reading" : "Sending") + " Binary response - URL [" + this.url + "] - Size [" + length + "]\n" + this.toStringPayload());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST - " + (agentSide ? "Reading" : "Sending") + " Binary response - URL [" + this.url + "] - Size [" + length + "]\n" + this.toStringPayload());
        }
    }

    @Override
    public String toStringPayload() {
        StringBuilder sb = new StringBuilder();
        sb.append("********").append(this.getName()).append("********");
        sb.append('\n');
        for (String key : this.payload.keySet()) {
            sb.append('<').append(key).append('>').append('\n');
            Object value = this.payload.get(key);
            if (key.equals("account-key")) {
                value = "****";
            }
            if (value instanceof Map) {
                Map m = (Map)value;
                this.appendLength(sb, m.size());
                for (Object k : m.keySet()) {
                    Object val = m.get(k);
                    sb.append('<').append(k).append('>').append("::").append('<').append(val).append('>').append('\n');
                }
            } else if (value instanceof Collection) {
                Collection c = (Collection)value;
                this.appendLength(sb, c.size());
                for (Object val : c) {
                    sb.append('<').append(val).append('>').append("\n");
                }
            } else if (null != value && value.getClass().isArray()) {
                this.arrayToString(value, sb);
                sb.append('\n');
            } else {
                sb.append(value).append('\n');
            }
            sb.append('<').append('/').append(key).append('>').append('\n');
        }
        return sb.toString();
    }

    private void appendLength(StringBuilder sb, int length) {
        sb.append("Size : ").append(length).append('\n');
    }

    @Override
    protected int getByteCount() {
        return this.byteCount;
    }

    @Override
    public StringBuilder getExceptionString(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t);
        this.appendCauseMessage(t.getCause(), sb);
        return sb;
    }

    private void appendCauseMessage(Throwable t, StringBuilder sb) {
        if (t != null) {
            sb.append(" caused by ");
            sb.append(t);
            this.appendCauseMessage(t.getCause(), sb);
        }
    }

    protected abstract String getName();

    @Override
    public ResponsePiggyBackObject getPiggyBackObject() {
        return (ResponsePiggyBackObject)this.payload.get("piggyback-object");
    }

    @Override
    public void setPiggyBackObject(ResponsePiggyBackObject object) {
        this.payload.put("piggyback-object", object);
    }

    @Override
    public void setContextualLoggingEnabled(boolean enabled) {
        this.payload.put("contextual-logging", true);
    }

    @Override
    public boolean isContextualLoggingEnabled() {
        Boolean value = (Boolean)this.payload.get("contextual-logging");
        return value != null && value != false;
    }

    private void arrayToString(Object a, StringBuilder b) {
        int iMax = Array.getLength(a) - 1;
        if (iMax == -1) {
            b.append("[]");
            return;
        }
        b.append('[');
        for (int i = 0; i <= iMax; ++i) {
            b.append(Array.get(a, i));
            if (i == iMax) {
                b.append(']');
                return;
            }
            b.append(", ");
        }
    }
}

