/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest.agent.request;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.rest.RESTArgument;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.agent.request.AAgentRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

@Deprecated
public class AgentInitRequest
extends AAgentRequest {
    private static final String AGENT_IDENTITY_SUFFIX = "/systemagent/identity";
    private static final String INSTANCE_ID = "instance-id";
    private static final String CONTROLLER_HOST = "controller-host";
    private static final String CONTROLLER_PORT = "controller-port";
    private static final String USER_NAME = "user-name";
    private static final String PASSWORD = "password";
    private static final String UNIQUE_LOCAL_ID = "unique-local-id";
    private static final String NODE_ID = "node-id";
    private static final String NODE_ID_MAPPING = "node-id-mapping";
    public static final String ALL_IPS = "all-ips";
    private Map<String, String> nodeIDMapping;

    public AgentInitRequest(long machineId, ILogger logger) {
        super(machineId, logger);
        this.url = this.url + AGENT_IDENTITY_SUFFIX;
        throw new UnsupportedOperationException("controller initializing agent does not make sense with one way agent!");
    }

    public AgentInitRequest(HttpServletRequest servletRequest, ILogger logger) throws RequestReadException {
        super(servletRequest, logger);
        List<RESTArgument> args = this.getRequestArguments();
        this.nodeIDMapping = new HashMap<String, String>();
        for (RESTArgument argument : args) {
            System.out.println("parsing node mappings.....");
            if (!argument.getName().equals(NODE_ID_MAPPING)) continue;
            Map<String, String> attrs = argument.getAttributes();
            this.nodeIDMapping.put(attrs.get(UNIQUE_LOCAL_ID), attrs.get(NODE_ID));
        }
        System.out.println("Final node map parsed -<" + this.nodeIDMapping);
    }

    public AgentInitRequest(String responseBody, ILogger logger) throws ResponseReadException {
        super(logger);
        try {
            System.out.println("Reading from response body ->" + responseBody);
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(responseBody);
            this.addArgumentsFromXMLPayload(xmlDoc);
        }
        catch (SAXException e) {
            logger.warn("Error parsing XML reading REST response ", (Throwable)e);
            throw new ResponseReadException(e);
        }
        catch (IOException e) {
            logger.warn("Error reading REST response ", (Throwable)e);
            throw new ResponseReadException(e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Error reading REST response, Parser configuration error ", (Throwable)e);
            throw new ResponseReadException(e);
        }
        this.createSimpleArguments();
    }

    public AgentInitRequest(ILogger logger) {
        super(logger);
    }

    public String getInstanceID() {
        return this.getValueForArgument(INSTANCE_ID);
    }

    public void setInstanceID(Long instanceID) {
        this.addArgumentWithNoAttributes(INSTANCE_ID, String.valueOf(instanceID));
    }

    public String getControllerHost() {
        return this.getValueForArgument(CONTROLLER_HOST);
    }

    public void setControllerHost(String controllerHost) {
        this.addArgumentWithNoAttributes(CONTROLLER_HOST, controllerHost);
    }

    public String getControllerPort() {
        return this.getValueForArgument(CONTROLLER_PORT);
    }

    public void setControllerPort(String controllerPort) {
        this.addArgumentWithNoAttributes(CONTROLLER_PORT, controllerPort);
    }

    public String getUserName() {
        return this.getValueForArgument(USER_NAME);
    }

    public void setUserName(String userName) {
        this.addArgumentWithNoAttributes(USER_NAME, userName);
    }

    public String getPassword() {
        return this.getValueForArgument(PASSWORD);
    }

    public void setPassword(String password) {
        this.addArgumentWithNoAttributes(PASSWORD, password);
    }

    public void addNodeIDMapping(String uniqueLocalID, Long nodeID) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put(UNIQUE_LOCAL_ID, uniqueLocalID);
        attribs.put(NODE_ID, String.valueOf(nodeID));
        this.addArgumentWithAttributesOnly(NODE_ID_MAPPING, attribs);
    }

    public Map<String, String> getNodeIDMapping() {
        return this.nodeIDMapping;
    }

    public void setBoundIPs() throws IOException {
        this.addArgumentWithNoAttributes(ALL_IPS, this.getAllIPs());
        this.generatePayload();
    }

    public String[] getBoundIPs() {
        String allIPs = this.getValueForArgument(ALL_IPS);
        StringTokenizer tokenizer = new StringTokenizer(allIPs, ",");
        String[] ipList = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            ipList[i++] = tokenizer.nextToken();
        }
        return ipList;
    }

    private String getAllIPs() {
        StringBuilder builder = new StringBuilder();
        try {
            InetAddress[] addresses;
            InetAddress localHostAddress = InetAddress.getLocalHost();
            HashSet<String> hostNames = new HashSet<String>();
            boolean isFirst = true;
            for (InetAddress address : addresses = InetAddress.getAllByName(localHostAddress.getHostName())) {
                System.out.println("IP->" + address.getHostName() + "-" + address.getHostAddress());
                if (address.getHostAddress().contains(":")) continue;
                if (!isFirst) {
                    builder.append(",");
                } else {
                    isFirst = false;
                }
                builder.append(address.getHostAddress());
                if (hostNames.contains(address.getHostName())) continue;
                builder.append(",").append(address.getHostName());
                hostNames.add(address.getHostName());
            }
            builder.append(",").append(localHostAddress.getHostName());
        }
        catch (UnknownHostException e) {
            this.logger.warn("Could not get the IP of the local machine", (Throwable)e);
        }
        return builder.toString();
    }

    public static void main(String[] args) throws Exception {
        InetAddress[] addresses;
        InetAddress address = InetAddress.getLocalHost();
        for (InetAddress addr : addresses = InetAddress.getAllByName(address.getHostName())) {
            System.out.println("IP->" + addr.getHostName() + "-" + addr.getHostAddress());
        }
    }
}

