/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest;

import com.appdynamics.org.w3c.dom.Element;
import com.singularity.ee.rest.RESTArgument;
import com.singularity.ee.rest.RESTArgumentType;
import com.singularity.ee.rest.RESTTagNames;
import com.singularity.ee.util.xml.EscapeUtility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleRESTArguments
implements RESTTagNames {
    private Map<String, ArgumentProperties> argumentMap = new HashMap<String, ArgumentProperties>();

    public SimpleRESTArguments(List<RESTArgument> restArguments) {
        this.parse(restArguments, "name", "value");
    }

    public SimpleRESTArguments(List<RESTArgument> restArguments, String nameAttr, String valueAttr) {
        this.parse(restArguments, nameAttr, valueAttr);
    }

    private void parse(List<RESTArgument> restArguments, String nameAttr, String valueAttr) {
        for (RESTArgument argument : restArguments) {
            String name = argument.getName();
            ArgumentProperties argProperties = this.argumentMap.get(name);
            if (argProperties == null) {
                argProperties = new ArgumentProperties();
                this.argumentMap.put(name, argProperties);
                argProperties.setValue(argument.getValue());
            }
            if (argument.getAttributes() != null) {
                argProperties.addProperty(argument.getType(), argument.getAttributes().get(nameAttr), argument.getAttributes().get(valueAttr));
            }
            if (argument.getType() != RESTArgumentType.XML) continue;
            argProperties.setCustomData(argument.getCustomData());
        }
    }

    public String getValueForArgument(String argName) {
        ArgumentProperties argProps = this.argumentMap.get(argName);
        if (argProps != null) {
            return argProps.getValue();
        }
        return null;
    }

    public Element getCustomDataForArgument(String argName) {
        ArgumentProperties argProps = this.argumentMap.get(argName);
        if (argProps != null) {
            return argProps.getCustomData();
        }
        return null;
    }

    public String toString() {
        return this.argumentMap.toString();
    }

    public Map<String, String> getNameValuePairsForTypeForArgument(String argName, RESTArgumentType type) {
        ArgumentProperties argProps = this.argumentMap.get(argName);
        if (argProps != null) {
            return argProps.getAttributeNameValuesForType(type);
        }
        return new HashMap<String, String>();
    }

    private static class ArgumentProperties {
        private String value;
        private Map<RESTArgumentType, Map<String, String>> attributeNameValues = new HashMap<RESTArgumentType, Map<String, String>>();
        private Element customData;

        private ArgumentProperties() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = EscapeUtility.XML.unescape(value);
        }

        public Element getCustomData() {
            return this.customData;
        }

        public void setCustomData(Element customData) {
            this.customData = customData;
        }

        public void addProperty(RESTArgumentType type, String name, String value) {
            Map<String, String> nameValuePairs = this.attributeNameValues.get((Object)type);
            if (nameValuePairs == null) {
                nameValuePairs = new HashMap<String, String>();
                this.attributeNameValues.put(type, nameValuePairs);
            }
            nameValuePairs.put(name, EscapeUtility.XML.unescape(value));
        }

        public Map<String, String> getAttributeNameValuesForType(RESTArgumentType type) {
            if (this.attributeNameValues.get((Object)type) != null) {
                return this.attributeNameValues.get((Object)type);
            }
            return new HashMap<String, String>();
        }

        public String toString() {
            return "Argument Property Value-" + this.value + "Attributes -" + this.attributeNameValues;
        }
    }
}

