/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest;

import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.singularity.ee.rest.IRESTResponseTags;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

public class RESTResponse
implements IRESTResponseTags {
    private int responseCode;
    private String executionOutput;

    private RESTResponse() {
    }

    public static RESTResponse readFromResponse(String responseBody) throws ResponseReadException {
        RESTResponse response = new RESTResponse();
        try {
            Element docElement = XMLParseUtility.getXmlDocumentFromString(responseBody).getDocumentElement();
            int responseCode = Integer.parseInt(XMLParseUtility.getTextForTagForElement((Node)docElement, "response-code"));
            String executionOutput = XMLParseUtility.getTextForTagForElement((Node)docElement, "execution-output");
            response.setResponseCode(responseCode);
            response.setExecutionOutput(executionOutput);
        }
        catch (Exception e) {
            throw new ResponseReadException("Exception while reading from response", e);
        }
        return response;
    }

    public static RESTResponse readFromResponse(HttpExecutionResponse response) throws ResponseReadException {
        return RESTResponse.readFromResponse(response.getResponseBody());
    }

    public static void sendSuccessResponse(HttpServletResponse response, String output, ILogger iLogger) throws IOException {
        RESTResponse.sendResponse(response, output, true, iLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendResponse(HttpServletResponse response, String output, boolean success, ILogger iLogger) throws IOException {
        try (PrintWriter writer = response.getWriter();){
            response.setStatus(200);
            String responseBody = RESTResponse.createResponseBody(success ? "<response-code>0</response-code>" : "<response-code>1</response-code>", output);
            if (iLogger.isDebugEnabled()) {
                iLogger.debug("Sending response -> " + responseBody);
            }
            writer.print(responseBody);
            writer.flush();
        }
    }

    public static HttpExecutionResponse createSuccessResponse(String output) {
        HttpExecutionResponse response = new HttpExecutionResponse();
        response.setStatusCode(200);
        response.setResponseBody(RESTResponse.createResponseBody("<response-code>0</response-code>", output));
        return response;
    }

    public static String createResponseBody(String responseCodeElement, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append("<response>").append("\n\t").append(responseCodeElement).append("\n\t").append("<execution-output>").append(output).append("</execution-output>").append("\n").append("</response>");
        return sb.toString();
    }

    public static void sendFailureResponse(HttpServletResponse response, String output, ILogger iLogger) throws IOException {
        RESTResponse.sendResponse(response, output, false, iLogger);
    }

    public static HttpExecutionResponse createFailureResponse(String output) {
        HttpExecutionResponse response = new HttpExecutionResponse();
        response.setStatusCode(200);
        response.setResponseBody(RESTResponse.createResponseBody("<response-code>1</response-code>", output));
        return response;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getExecutionOutput() {
        return this.executionOutput;
    }

    public boolean isSuccessfullyExecuted() {
        return this.getResponseCode() == 0;
    }

    public void setExecutionOutput(String executionOutput) {
        this.executionOutput = executionOutput;
    }
}

