/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest;

import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.clock.ClockUtilsHelper;
import com.singularity.ee.util.exceptionop.ExceptionOperations;
import com.singularity.ee.util.io.IOStreamFactory;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import com.singularity.ee.util.javaspecific.scheduler.ExecutorFactory;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.SysOutLogger;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentAtomicLong;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;

public class RESTRequestTrackingManager {
    private static volatile boolean restRequestTrackingEnabledField = false;
    private static String logDir = null;
    private static IAgentAtomicInteger statsReportFrequencyInSeconds = new AgentAtomicIntegerImpl(60);
    private static ADConcurrentHashMap<Class, RESTRequestTracker> trackers = new ADConcurrentHashMap();
    private static long lastStatsReportTime;
    private static IAgentScheduledExecutorService scheduler;
    private static final String statsLogFileName = "rest-call-stats.log";
    private static PrintStream statsLogger;

    private RESTRequestTrackingManager() {
    }

    public static boolean restRequestTrackingEnabled() {
        return restRequestTrackingEnabledField;
    }

    public static void setRestRequestTrackingEnabled(boolean restRequestTrackingEnabled) {
        restRequestTrackingEnabledField = restRequestTrackingEnabled;
        RESTRequestTrackingManager.setupLogger();
        RESTRequestTrackingManager.resetTimer();
    }

    public static String getLogDir() {
        return logDir;
    }

    public static void setLogDir(String logDir) {
        RESTRequestTrackingManager.logDir = logDir;
        RESTRequestTrackingManager.setupLogger();
    }

    private static void setupLogger() {
        if (restRequestTrackingEnabledField && statsLogger == null && logDir != null) {
            statsLogger = RESTRequestTrackingManager.startLogger(logDir, statsLogFileName, "REST stats");
        }
    }

    public static IAgentAtomicInteger getStatsReportFrequencyInSeconds() {
        return statsReportFrequencyInSeconds;
    }

    public static void setStatsReportFrequencyInSeconds(int statsReportFrequencyInSeconds) {
        RESTRequestTrackingManager.resetFrequencyFlag(statsReportFrequencyInSeconds);
    }

    public static void reportSendRequest(Class clazz, long startTime, long endTime, int byteCount) {
        RESTRequestTracker tracker = RESTRequestTrackingManager.getTracker(clazz);
        tracker.invocationCount.incrementAndGet();
        tracker.sendRequestTime.addAndGet(endTime - startTime);
        tracker.requestBytesCount.addAndGet(byteCount);
    }

    public static void reportReadResponse(Class clazz, long startTime, long endTime, int byteCount) {
        RESTRequestTracker tracker = RESTRequestTrackingManager.getTracker(clazz);
        tracker.readResponseTime.addAndGet(endTime - startTime);
        tracker.responseBytesCount.addAndGet(byteCount);
    }

    public static void reportReadRequest(Class clazz, long startTime, long endTime, int byteCount) {
        RESTRequestTracker tracker = RESTRequestTrackingManager.getTracker(clazz);
        tracker.readRequestTime.addAndGet(endTime - startTime);
        tracker.requestBytesCount.addAndGet(byteCount);
    }

    public static void reportWriteResponse(Class clazz, long startTime, long endTime, int byteCount) {
        RESTRequestTracker tracker = RESTRequestTrackingManager.getTracker(clazz);
        tracker.writeResponseTime.addAndGet(endTime - startTime);
        tracker.responseBytesCount.addAndGet(byteCount);
    }

    private static RESTRequestTracker getTracker(Class clazz) {
        RESTRequestTracker tracker = (RESTRequestTracker)trackers.get((Object)clazz);
        if (tracker == null) {
            tracker = new RESTRequestTracker();
            trackers.put((Object)clazz, (Object)tracker);
        }
        return tracker;
    }

    private static void resetTimer() {
        if (scheduler != null) {
            scheduler.shutdown();
            scheduler = null;
        }
        if (restRequestTrackingEnabledField) {
            SysOutLogger logger = statsLogger != null ? new SysOutLogger(ReflectionUtilityCommon.getClassSimpleName(RESTRequestTrackingManager.class), statsLogger) : null;
            scheduler = ExecutorFactory.newScheduledThreadPool((int)1, (ILogger)logger);
            scheduler.scheduleAtFixedRate((IAgentRunnable)new StatsReporter(), (long)statsReportFrequencyInSeconds.get(), (long)statsReportFrequencyInSeconds.get(), AgentTimeUnit.SECONDS);
        }
    }

    private static void resetAndReportStats() {
        if (!restRequestTrackingEnabledField) {
            return;
        }
        StringBuilder report = new StringBuilder(2000);
        long currentTime = ClockUtils.getCurrentTime();
        report.append("\n###############################################################");
        report.append("\nReport Time: ").append(ClockUtilsHelper.getDateFromLong((long)currentTime));
        if (lastStatsReportTime > 0L) {
            report.append("\nTime since last report: ").append((currentTime - lastStatsReportTime) / 1000L).append(" seconds");
        }
        lastStatsReportTime = currentTime;
        ADIterator it = trackers.keySetIterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            RESTRequestTracker tracker = (RESTRequestTracker)trackers.get((Object)clazz);
            float invocationCount = tracker.invocationCount.getAndSet(0);
            float sendRequestTime = tracker.sendRequestTime.getAndSet(0L);
            float readResponseTime = tracker.readResponseTime.getAndSet(0L);
            float readRequestTime = tracker.readRequestTime.getAndSet(0L);
            float writeResponseTime = tracker.writeResponseTime.getAndSet(0L);
            int requestBytes = tracker.requestBytesCount.getAndSet(0);
            int responseBytes = tracker.responseBytesCount.getAndSet(0);
            if (invocationCount == 0.0f) continue;
            report.append("\n").append(ReflectionUtilityCommon.getClassSimpleName((Class)clazz)).append(", Invocations=").append((int)invocationCount);
            if (sendRequestTime != 0.0f) {
                float avgSendRequestOverhead = sendRequestTime / invocationCount / 1000000.0f;
                report.append(", Avg SendRequest Time=").append(avgSendRequestOverhead).append(" ms");
            }
            if (readResponseTime != 0.0f) {
                float avgReadResponseOverhead = readResponseTime / invocationCount / 1000000.0f;
                report.append(", Avg ReadResponse Time=").append(avgReadResponseOverhead).append(" ms");
            }
            if (readRequestTime != 0.0f) {
                float avgReadRequestOverhead = readRequestTime / invocationCount / 1000000.0f;
                report.append(", Avg ReadRequest Time=").append(avgReadRequestOverhead).append(" ms");
            }
            if (writeResponseTime != 0.0f) {
                float avgWriteResponseOverhead = writeResponseTime / invocationCount / 1000000.0f;
                report.append(", Avg WriteResponse Time=").append(avgWriteResponseOverhead).append(" ms");
            }
            if (requestBytes > 0) {
                report.append(", Request Bytes=").append(requestBytes).append(" bytes");
            }
            if (responseBytes <= 0) continue;
            report.append(", Response Bytes=").append(responseBytes).append(" bytes");
        }
        statsLogger.print(report);
    }

    private static PrintStream startLogger(String logDir, String logFileName, String description) {
        PrintStream logger;
        try {
            File logFile = new File(logDir, logFileName);
            if (new File(logDir).canWrite()) {
                logger = IOStreamFactory.createPrintStream((OutputStream)IOStreamFactory.createFileOutputStream((File)logFile, (boolean)false), (boolean)true);
            } else {
                System.out.println("Singularity Agent: Error occurred while creating file [" + logFile.getAbsolutePath() + "] to log " + description + ".");
                System.out.println("Singularity Agent: Please check for permissions in the " + logDir + " directory.");
                System.out.println("Singularity Agent: " + description + " will not be logged, does not affect core agent functionality");
                logger = IOStreamFactory.createPrintStream((OutputStream)IOStreamFactory.createNullOutputStream());
            }
        }
        catch (Exception e) {
            ExceptionOperations.printStackTrace((Throwable)e);
            System.out.println("Singularity Agent: Error occurred while creating file [" + logFileName + "] to log " + description + ".");
            System.out.println("Singularity Agent: Please check for permissions in the " + logDir + " directory.");
            System.out.println("Singularity Agent: " + description + " will not be logged, does not affect core agent functionality");
            logger = IOStreamFactory.createPrintStream((OutputStream)IOStreamFactory.createNullOutputStream());
        }
        logger.println("#############################################################");
        logger.println("Starting " + description + " Logging at " + ClockUtilsHelper.getDateFromLong((long)ClockUtils.getCurrentTime()));
        logger.println("#############################################################");
        return logger;
    }

    private static void resetFrequencyFlag(int frequency) {
        if (restRequestTrackingEnabledField && statsReportFrequencyInSeconds.get() != frequency) {
            statsReportFrequencyInSeconds.set(frequency);
            RESTRequestTrackingManager.resetTimer();
        }
    }

    static {
        scheduler = null;
    }

    private static final class RESTRequestTracker {
        IAgentAtomicInteger invocationCount = new AgentAtomicIntegerImpl();
        IAgentAtomicLong sendRequestTime = new AgentAtomicLongImpl();
        IAgentAtomicLong readResponseTime = new AgentAtomicLongImpl();
        IAgentAtomicLong readRequestTime = new AgentAtomicLongImpl();
        IAgentAtomicLong writeResponseTime = new AgentAtomicLongImpl();
        IAgentAtomicInteger requestBytesCount = new AgentAtomicIntegerImpl();
        IAgentAtomicInteger responseBytesCount = new AgentAtomicIntegerImpl();

        private RESTRequestTracker() {
        }
    }

    static class StatsReporter
    implements IAgentRunnable {
        StatsReporter() {
        }

        public void run() {
            RESTRequestTrackingManager.resetAndReportStats();
        }
    }
}

