/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.rest;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.rest.RESTArgument;
import com.singularity.ee.rest.RESTArgumentType;
import com.singularity.ee.rest.RESTRequestTrackingManager;
import com.singularity.ee.rest.RESTTagNames;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.SimpleRESTArguments;
import com.singularity.ee.util.httpclient.HttpExecutionRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.httpclient.HttpOperation;
import com.singularity.ee.util.httpclient.SimpleHttpClientWrapper;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.xml.EscapeUtility;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class RESTRequest
implements RESTTagNames {
    public static final String LOG_TO_CONSOLE = "log.request.console";
    private static final IAgentAtomicInteger errorCount = new AgentAtomicIntegerImpl(0);
    protected final ILogger logger;
    protected SimpleHttpClientWrapper httpClient;
    protected String url;
    protected HttpOperation operation = HttpOperation.POST;
    protected final Map<String, Object> payload = new HashMap<String, Object>();
    protected final Collection<File> files = new LinkedList<File>();
    protected List<FileItem> fileItems;
    protected Map<String, byte[]> binaryParts;
    protected boolean isMultiPartRequest;
    protected boolean isCompressed;
    protected boolean isResponseStreamed;
    protected boolean logToConsole;
    protected List<RESTArgument> requestArguments = new ArrayList<RESTArgument>();
    protected SimpleRESTArguments simpleArgs;
    protected transient HttpServletRequest servletRequest;

    public RESTRequest(SimpleHttpClientWrapper httpClientWrapper, ILogger logger) {
        this.logger = logger;
        this.httpClient = httpClientWrapper;
    }

    public RESTRequest(String url, SimpleHttpClientWrapper httpClientWrapper, ILogger logger) {
        this(httpClientWrapper, logger);
        this.url = url;
    }

    public RESTRequest(HttpServletRequest servletRequest, SimpleHttpClientWrapper httpClientWrapper, ILogger logger) throws RequestReadException {
        this(servletRequest.getRequestURI(), httpClientWrapper, logger);
        this.servletRequest = servletRequest;
        this.parseServletRequest(servletRequest);
    }

    public RESTRequest(HttpExecutionRequest request, SimpleHttpClientWrapper httpClientWrapper, ILogger logger) throws RequestReadException {
        this(request.getUrl(), httpClientWrapper, logger);
        this.operation = request.getOperation();
        this.parseOneWayAgentServletRequest(request);
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public HttpOperation getOperation() {
        return this.operation;
    }

    public Collection<File> getFiles() {
        return this.files;
    }

    public boolean isMultiPartRequest() {
        return this.isMultiPartRequest;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean compressed) {
        this.isCompressed = compressed;
    }

    public boolean isResponseStreamed() {
        return this.isResponseStreamed;
    }

    public void setResponseStreamed(boolean streamed) {
        this.isResponseStreamed = streamed;
    }

    public boolean logToConsole() {
        return this.logToConsole;
    }

    public void setLogToConsole(boolean logToConsole) {
        this.logToConsole = logToConsole;
    }

    public List<RESTArgument> getRequestArguments() {
        return this.requestArguments;
    }

    public void setFileItems(List<FileItem> items) {
        this.fileItems = items;
    }

    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    public void addArgument(String name, String value, Map<String, String> attributes) {
        RESTArgument argument = new RESTArgument(name, value, attributes, RESTArgumentType.STRING);
        this.requestArguments.add(argument);
    }

    public void addArgumentWithNoAttributes(String name, String value) {
        RESTArgument argument = new RESTArgument(name, value, null, RESTArgumentType.STRING);
        this.requestArguments.add(argument);
    }

    public void addArgumentWithAttributesOnly(String name, Map<String, String> attributes) {
        RESTArgument argument = new RESTArgument(name, null, attributes, RESTArgumentType.STRING);
        this.requestArguments.add(argument);
    }

    public void addArgumentWithSingleNameValueAttributeOnly(String name, String attrName, String attrValue) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("name", attrName);
        args.put("value", attrValue);
        this.addArgument(name, null, args);
    }

    public void addArgumentWithFileTypeSingleNameValueAttributeOnly(String name, String attrName, String attrValue, File file) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("name", attrName);
        args.put("value", attrValue);
        this.addFileArgument(name, null, args);
        this.addFile(file);
    }

    public void addFileArgument(String name, String value, Map<String, String> attributes) {
        RESTArgument argument = new RESTArgument(name, value, attributes, RESTArgumentType.FILE);
        this.requestArguments.add(argument);
    }

    public void addFileArgument(String name, String value, Map<String, String> attributes, File file) {
        RESTArgument argument = new RESTArgument(name, value, attributes, RESTArgumentType.FILE);
        this.requestArguments.add(argument);
        this.addFile(file);
    }

    public void addFileArgumentWithValueOnly(String name, String value) {
        RESTArgument argument = new RESTArgument(name, value, null, RESTArgumentType.FILE);
        this.requestArguments.add(argument);
    }

    public void addFileArgumentWithAttributesOnly(String name, Map<String, String> attributes) {
        RESTArgument argument = new RESTArgument(name, null, attributes, RESTArgumentType.FILE);
        this.requestArguments.add(argument);
    }

    public void addComplexArgument(String name, String value, Map<String, String> attributes, Element element, RESTArgumentType type) {
        RESTArgument argument = new RESTArgument(name, value, attributes, type);
        if (type == RESTArgumentType.XML) {
            argument.setCustomData(element);
        }
        this.requestArguments.add(argument);
    }

    public void addXMLArgument(String name, Element element) {
        this.addComplexArgument(name, null, null, element, RESTArgumentType.XML);
    }

    public void addXMLArgumentAsString(String name, Map<String, String> attributes, String element) {
        RESTArgument argument = new RESTArgument(name, null, attributes, RESTArgumentType.XML);
        argument.setCustomDataAsString(element);
        this.requestArguments.add(argument);
    }

    public void addXMLArgumentAsString(String name, String element) {
        this.addXMLArgumentAsString(name, null, element);
    }

    public void addFile(File file) {
        this.isMultiPartRequest = true;
        this.files.add(file);
    }

    public void addBinaryPart(String name, byte[] part) {
        if (this.binaryParts == null) {
            this.binaryParts = new HashMap<String, byte[]>();
            this.isMultiPartRequest = true;
        }
        this.binaryParts.put(name, part);
    }

    public HttpExecutionResponse sendRequest() {
        if (RESTRequestTrackingManager.restRequestTrackingEnabled()) {
            long startTime = System.nanoTime();
            HttpExecutionResponse response = this.sendRequestTracked();
            long endTime = System.nanoTime();
            RESTRequestTrackingManager.reportSendRequest(this.getClass(), startTime, endTime, (int)response.getRequestContentLength());
            this.checkForResponseError(response);
            return response;
        }
        return this.sendRequestTracked();
    }

    private void checkForResponseError(HttpExecutionResponse response) {
        if (response.isExceptionHappened() && !response.isConnectionLimitActive()) {
            this.logger.error("Error in processing REST Request for url '" + this.url + "' - " + response.getExceptionMessage());
        }
    }

    private HttpExecutionResponse sendRequestTracked() {
        HttpExecutionRequest request;
        try {
            request = this.generateRequest();
            if (this.getPayload().containsKey("Host")) {
                Object hostHeader = this.getPayload().get("Host");
                Map<String, String> requestHeaders = request.getHeaders();
                if (requestHeaders == null) {
                    requestHeaders = new HashMap<String, String>();
                    requestHeaders.put("Host", (String)hostHeader);
                    request.setHeaders(requestHeaders);
                } else {
                    requestHeaders.put("Host", (String)hostHeader);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error in generating REST request", (Throwable)e);
            return this.createHttpErrorResponse(e.getMessage());
        }
        if (this.httpClient == null) {
            this.logger.error("HttpClient has not be setup for class type: " + this.getClass());
            return null;
        }
        int errorCount = this.getErrorCount();
        if (this.isRequestOverConnectionLimit(errorCount)) {
            HttpExecutionResponse httpErrorResponse = this.createHttpErrorResponse("Connection back off limitation in effect: " + request.getUrl());
            httpErrorResponse.setConnectionLimitActive();
            this.logger.debug(httpErrorResponse.getExceptionMessage());
            return httpErrorResponse;
        }
        HttpExecutionResponse response = this.httpClient.executeHttpOperation(request, this.logger);
        if (response.isExceptionHappened() || response.getStatusCode() == 503) {
            this.incrementErrorCount();
        } else if (errorCount != 0) {
            this.clearErrorCount();
        }
        if (request.isResponseStreamed() || request.isResponseInBinary()) {
            return response;
        }
        if (this.logToConsole) {
            if (response.getResponseBody() != null) {
                System.out.println("Response Received ->\n\n" + response.getResponseBody() + "\nfor URL [" + this.url + "]");
            } else {
                System.out.println("No Response Received from controller/Could not connect to controller \n\n for URL [" + this.url + "]");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST Response Received - URL [" + this.url + "]\n" + response.getResponseBody());
        }
        return response;
    }

    protected void incrementErrorCount() {
        errorCount.incrementAndGet();
    }

    protected void clearErrorCount() {
        errorCount.set(0);
    }

    protected int getErrorCount() {
        return errorCount.get();
    }

    protected boolean isRequestOverConnectionLimit(int errorCount) {
        return false;
    }

    private HttpExecutionResponse createHttpErrorResponse(String errMsg) {
        HttpExecutionResponse response = new HttpExecutionResponse();
        response.setExceptionHappened(true);
        response.setExceptionMessage(errMsg);
        return response;
    }

    protected HttpExecutionRequest generateRequest() throws IOException {
        HttpExecutionRequest request;
        String xmlPayload = this.generatePayload();
        this.logRequest(xmlPayload);
        if (!this.isMultiPartRequest) {
            request = new HttpExecutionRequest(this.url, xmlPayload, this.operation);
        } else {
            request = new HttpExecutionRequest(this.url, xmlPayload, this.operation);
            if (this.files != null) {
                request.setFiles(this.files.toArray(new File[this.files.size()]));
            }
            if (this.binaryParts != null) {
                request.setBinaryParts(this.binaryParts);
            }
        }
        if (this.isCompressed) {
            request.setCompressed(true);
        }
        if (this.isResponseStreamed) {
            request.setResponseStreamed(true);
        }
        return request;
    }

    private void logRequest(String xmlPayload) {
        if (!this.logToConsole && !this.logger.isDebugEnabled()) {
            return;
        }
        xmlPayload = xmlPayload.replaceAll("<account-key>[\\s\\S]*?<\\/account-key>", "<account-key>****</account-key>");
        if (this.logToConsole) {
            System.out.println("Sending REST request - URL [" + this.url + "]\n" + xmlPayload);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending REST request - URL [" + this.url + "]\n" + xmlPayload);
        }
    }

    public int writeToResponse(HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to write to committed response. Write invoked by " + this.getClass().getName());
                this.logger.debug("Stacktrace of write attempt: " + Arrays.toString(Thread.currentThread().getStackTrace()).replace(",", "\n").replace("[", "\n").replace("]", "\n"));
            }
            return 0;
        }
        if (RESTRequestTrackingManager.restRequestTrackingEnabled()) {
            long startTime = System.nanoTime();
            this.writeToResponseTracked(response);
            long endTime = System.nanoTime();
            RESTRequestTrackingManager.reportWriteResponse(this.getClass(), startTime, endTime, this.getByteCount());
            return this.getByteCount();
        }
        return this.writeToResponseTracked(response);
    }

    protected int writeToResponseTracked(HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to write to committed response. Write invoked by " + this.getClass().getName());
                this.logger.debug("Stacktrace of write attempt: " + Arrays.toString(Thread.currentThread().getStackTrace()).replace(",", "\n").replace("[", "\n").replace("]", "\n"));
            }
            return 0;
        }
        PrintWriter writer = null;
        try {
            String responseBody = this.generatePayload();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending Response - >\n\n" + responseBody);
            }
            response.setStatus(200);
            writer = response.getWriter();
            int length = responseBody.getBytes().length;
            response.setContentLength(length);
            writer.print(responseBody);
            writer.flush();
            int n = length;
            return n;
        }
        catch (IOException e) {
            response.setStatus(500);
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    this.logger.warn("Error in closing stream ", (Throwable)ex);
                }
            }
        }
    }

    public String generatePayload() throws IOException {
        StringBuilder buffer = new StringBuilder("<request>");
        for (RESTArgument requestArgument : this.requestArguments) {
            String xmlRepresentation = RESTRequest.getXMLRepresentationForArgument(requestArgument, this.logger);
            buffer.append("\n").append(xmlRepresentation);
        }
        buffer.append("\n").append("</request>").append("\n");
        return buffer.toString();
    }

    static String getXMLRepresentationForArgument(RESTArgument requestArgument, ILogger logger) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String name = requestArgument.getName();
        String value = requestArgument.getValue();
        Map<String, String> attributes = requestArgument.getAttributes();
        RESTArgumentType argType = requestArgument.getType();
        buffer.append("<");
        buffer.append(name);
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attribute = entry.getKey();
                String attributeValue = entry.getValue();
                String escapedAttributeValue = EscapeUtility.XML.escape(attributeValue);
                buffer.append("\t").append(attribute).append("=").append("\"").append(escapedAttributeValue).append("\"");
            }
        }
        if (argType != RESTArgumentType.STRING) {
            buffer.append("\t").append("rest-argument-type").append("=").append("\"").append((Object)argType).append("\"");
        }
        if (value == null) {
            if (argType == RESTArgumentType.XML) {
                String serializedElement;
                buffer.append(">");
                buffer.append("\n");
                if (requestArgument.getCustomData() != null) {
                    try {
                        serializedElement = XMLWriter.getStringRepresentationForElement(requestArgument.getCustomData());
                    }
                    catch (XMLWriteException e) {
                        logger.warn("Error Serializing XML Argument", e.getCause());
                        throw new IOException(e.getLocalizedMessage());
                    }
                } else {
                    serializedElement = requestArgument.getCustomDataAsString();
                }
                buffer.append("\t");
                buffer.append(serializedElement);
                buffer.append("</").append(name).append(">");
                buffer.append("\n");
            } else {
                buffer.append("/>");
            }
        } else {
            buffer.append(">");
            buffer.append(EscapeUtility.XML.escape(value)).append("</").append(name).append(">");
        }
        return buffer.toString();
    }

    protected void parseServletRequest(HttpServletRequest servletRequest) throws RequestReadException {
        if (RESTRequestTrackingManager.restRequestTrackingEnabled()) {
            long startTime = System.nanoTime();
            this.parseServletRequestTracked(servletRequest);
            long endTime = System.nanoTime();
            RESTRequestTrackingManager.reportReadRequest(this.getClass(), startTime, endTime, this.getByteCount());
        } else {
            this.parseServletRequestTracked(servletRequest);
        }
    }

    protected void parseServletRequestTracked(HttpServletRequest servletRequest) throws RequestReadException {
        if (servletRequest.getMethod().equalsIgnoreCase("DELETE") || servletRequest.getMethod().equalsIgnoreCase("GET")) {
            return;
        }
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            this.logger.debug("Parsing servlet multipart request.");
            this.isMultiPartRequest = true;
            this.parseMultiPartRequest(servletRequest);
        } else {
            this.logger.debug("Parsing servlet simple request.");
            this.parseSimpleRequest(servletRequest);
        }
        this.createSimpleArguments();
    }

    private void parseOneWayAgentServletRequest(HttpExecutionRequest request) throws RequestReadException {
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(request.getRequestBody());
            this.addArgumentsFromXMLPayload(xmlDoc);
        }
        catch (SAXException e) {
            this.logger.warn("Error parsing XML REST request ", (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (IOException e) {
            this.logger.warn("Error reading REST request ", (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Error reading REST request, Parser configuration error ", (Throwable)e);
            throw new RequestReadException(e);
        }
        this.createSimpleArguments();
        if (request.getBinaryParts() != null) {
            Map<String, byte[]> binaryParts = request.getBinaryParts();
            for (Map.Entry<String, byte[]> entry : binaryParts.entrySet()) {
                String name = entry.getKey();
                byte[] part = entry.getValue();
                this.addBinaryPart(name, part);
            }
        }
        if (request.getFiles() != null) {
            for (File file : request.getFiles()) {
                this.addFile(file);
            }
        }
    }

    protected void parseSimpleRequest(HttpServletRequest servletRequest) throws RequestReadException {
        Object in;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest)) {
            throw new RequestReadException("Cannot read Multipart request");
        }
        try {
            in = servletRequest.getInputStream();
            if (this.logger.isDebugEnabled()) {
                byte[] requestContent = FileUtil.inputStreamToByteArray((InputStream)in);
                this.logger.debug("Received request " + servletRequest.getRequestURI() + " -> " + new String(requestContent));
                in = new ByteArrayInputStream(requestContent);
            }
        }
        catch (IOException e) {
            this.logger.warn("Error reading REST request ", (Throwable)e);
            throw new RequestReadException(e);
        }
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromInputStream((InputStream)in);
            this.addArgumentsFromXMLPayload(xmlDoc);
        }
        catch (SAXException e) {
            this.logger.warn("Error parsing XML reading REST request ", (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (IOException e) {
            this.logger.warn("Error reading REST request ", (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Error reading REST request, Parser configuration error ", (Throwable)e);
            throw new RequestReadException(e);
        }
    }

    protected void parseMultiPartRequest(HttpServletRequest servletRequest) throws RequestReadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(51200);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax(0x6400000L);
        upload.setFileCountMax(100L);
        try {
            List items = upload.parseRequest(servletRequest);
            String requestBodyStr = ((FileItem)items.get(0)).getString();
            this.logger.debug("Request body string read XML  in parseMultiPartRequest:" + requestBodyStr);
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromString(requestBodyStr);
            this.addArgumentsFromXMLPayload(xmlDoc);
            this.logger.debug("file items received-" + items);
            this.setFileItems(items);
        }
        catch (FileUploadException e) {
            this.logger.warn("Error downloading files", (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (SAXException e) {
            throw new RequestReadException(e);
        }
        catch (IOException e) {
            this.logger.warn("Error reading request", (Throwable)e);
            throw new RequestReadException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RequestReadException(e);
        }
    }

    public Map<String, byte[]> downloadBinaryParts() throws IOException {
        this.logger.debug("Getting Binary parts for [" + this.url + "]");
        HashMap<String, byte[]> binaryParts = new HashMap<String, byte[]>();
        if (this.fileItems != null) {
            for (int i = 0; i < this.fileItems.size(); ++i) {
                if (i == 0) continue;
                binaryParts.put(this.fileItems.get(i).getName(), this.fileItems.get(i).get());
            }
        }
        return binaryParts;
    }

    protected void addArgumentsFromXMLPayload(Document xmlDoc) {
        List<Element> directChildElements = XMLParseUtility.getListOfDirectSiblingsForNode((Node)xmlDoc.getDocumentElement());
        for (Element element : directChildElements) {
            String name = XMLParseUtility.getElementName(element);
            String value = XMLParseUtility.getElementValue(element);
            Map<String, String> attributes = XMLParseUtility.getAttributeMapForElement(element);
            String argTypeStr = attributes.get("rest-argument-type");
            if (argTypeStr == null) {
                this.addArgument(name, value, attributes);
                continue;
            }
            RESTArgumentType argType = RESTArgumentType.valueOf(argTypeStr);
            this.addComplexArgument(name, value, attributes, element, argType);
        }
    }

    public void createSimpleArguments() {
        this.simpleArgs = new SimpleRESTArguments(this.requestArguments);
    }

    protected void createSimpleArguments(String customKeyAttr, String customValueAttr) {
        this.simpleArgs = new SimpleRESTArguments(this.requestArguments, customKeyAttr, customValueAttr);
    }

    public String getValueForArgument(String argName) {
        if (this.simpleArgs != null) {
            return this.simpleArgs.getValueForArgument(argName);
        }
        return null;
    }

    public Element getXMLValueForArgument(String argName) {
        if (this.simpleArgs != null) {
            return this.simpleArgs.getCustomDataForArgument(argName);
        }
        return null;
    }

    public String getAttributeValueForStringTypeArgument(String argName, String attributeName) {
        return this.getAttributeValueForArgumentType(argName, attributeName, RESTArgumentType.STRING);
    }

    public String getAttributeValueForFileTypeArgument(String argName, String attributeName) {
        return this.getAttributeValueForArgumentType(argName, attributeName, RESTArgumentType.FILE);
    }

    private String getAttributeValueForArgumentType(String argName, String attributeName, RESTArgumentType argType) {
        Map<String, String> nameValuePairsForArgument = this.simpleArgs.getNameValuePairsForTypeForArgument(argName, argType);
        if (nameValuePairsForArgument != null) {
            return nameValuePairsForArgument.get(attributeName);
        }
        return null;
    }

    public Map<String, String> getNameValueAttributeMapForArgument(String argName, RESTArgumentType type) {
        if (this.simpleArgs != null) {
            return this.simpleArgs.getNameValuePairsForTypeForArgument(argName, type);
        }
        return null;
    }

    protected int getByteCount() {
        return 0;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public SimpleHttpClientWrapper getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(SimpleHttpClientWrapper wrapper) {
        this.httpClient = wrapper;
    }
}

