/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.metrics.boot;

import com.singularity.ee.metrics.boot.CategoryLink;
import com.singularity.ee.metrics.boot.CategoryNav;
import com.singularity.ee.metrics.boot.PerformanceCounter;
import com.singularity.ee.util.exceptionop.ExceptionOperations;
import com.singularity.ee.util.spi.IStringTokenizer;
import com.singularity.ee.util.string.StringOperations;

class PerformanceCounterFactory {
    private PerformanceCounterFactory() {
    }

    static PerformanceCounter createPerformanceCounter(String metricString) {
        PerformanceCounter performanceCounter;
        IStringTokenizer metricStrTokenizer = StringOperations.createStringTokenizer((String)metricString, (String)"|");
        int tokens = metricStrTokenizer.countTokens();
        String monitorName = metricStrTokenizer.nextToken();
        CategoryNav categoryNav = new CategoryNav(monitorName);
        int counter = 1;
        do {
            CategoryLink mLink;
            String link;
            try {
                link = metricStrTokenizer.nextToken();
            }
            catch (Exception e) {
                ExceptionOperations.printStackTrace((Throwable)e);
                return new PerformanceCounter(new CategoryNav(metricString), metricString, metricString);
            }
            ++counter;
            if (link.indexOf(":") > 0) {
                String cat = link.substring(0, link.indexOf(":"));
                String instanceName = link.substring(link.indexOf(":") + 1, link.length());
                mLink = new CategoryLink(cat, instanceName);
            } else {
                mLink = new CategoryLink(link);
            }
            categoryNav.addMetricLink(mLink);
        } while (counter < tokens - 2);
        String category_Instance = metricStrTokenizer.nextToken();
        if (category_Instance.indexOf(":") > 0) {
            String category = category_Instance.substring(0, category_Instance.indexOf(":"));
            String instanceName = category_Instance.substring(category_Instance.indexOf(":") + 1, category_Instance.length());
            String counterName = metricStrTokenizer.nextToken();
            performanceCounter = new PerformanceCounter(categoryNav, category, instanceName, counterName);
        } else {
            String counterName = metricStrTokenizer.nextToken();
            performanceCounter = new PerformanceCounter(categoryNav, category_Instance, counterName);
        }
        return performanceCounter;
    }
}

