/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.metrics.boot;

import com.singularity.ee.metrics.boot.CategoryNav;
import com.singularity.ee.metrics.boot.PerformanceCounterFactory;

public class PerformanceCounter {
    public static final String CATEGORY_INSTANCE_SEPARATOR = ":";
    public static final String METRIC_PATH_SEPARATOR = "|";
    public static final char CATEGORY_INSTANCE_SEPARATOR_CHAR = ':';
    public static final char METRIC_PATH_SEPARATOR_CHAR = '|';
    private final String category;
    private final String instanceName;
    private final String counterName;
    private final String stringRepresentation;
    private CategoryNav categoryNav;

    public PerformanceCounter(CategoryNav categoryNav, String category, String instanceName, String counterName) {
        this.categoryNav = categoryNav;
        this.category = category;
        this.instanceName = instanceName;
        this.counterName = counterName;
        this.stringRepresentation = this.buildStringRepresentation();
    }

    public PerformanceCounter(CategoryNav categoryNav, String category, String counterName) {
        this.categoryNav = categoryNav;
        this.category = category;
        this.counterName = counterName;
        this.instanceName = null;
        this.stringRepresentation = this.buildStringRepresentation();
    }

    public PerformanceCounter(CategoryNav categoryNav, String counterName) {
        this.categoryNav = categoryNav.getNavWithoutLastLink();
        this.category = categoryNav.getLastCategoryName();
        this.instanceName = categoryNav.getLastInstanceName();
        this.counterName = counterName;
        this.stringRepresentation = this.buildStringRepresentation();
    }

    public PerformanceCounter(CategoryNav categoryNav, String counterName, int percentile) {
        this.categoryNav = categoryNav.getNavWithoutLastLink();
        this.category = categoryNav.getLastCategoryName();
        this.instanceName = categoryNav.getLastInstanceName();
        this.counterName = counterName;
        this.stringRepresentation = this.buildStringRepresentation(percentile);
    }

    public String getCategory() {
        return this.category;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public CategoryNav getMetricPath() {
        return this.categoryNav;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    private String buildStringRepresentation() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.categoryNav.getStringRepresentation());
        if (this.category != null) {
            sb.append(this.category);
        }
        if (this.instanceName != null) {
            sb.append(CATEGORY_INSTANCE_SEPARATOR).append(this.instanceName);
        }
        sb.append(METRIC_PATH_SEPARATOR).append(this.counterName);
        return sb.toString();
    }

    private String buildStringRepresentation(int percentile) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.categoryNav.getStringRepresentation());
        if (this.category != null) {
            sb.append(this.category);
        }
        if (this.instanceName != null) {
            sb.append(CATEGORY_INSTANCE_SEPARATOR).append(this.instanceName);
        }
        String numSuffix = percentile == 1 ? "st " : (percentile == 2 ? "nd " : (percentile == 3 ? "rd " : "th "));
        sb.append(METRIC_PATH_SEPARATOR).append(percentile).append(numSuffix).append(this.counterName);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Metric - \n\n").append(this.categoryNav).append("\n\n");
        if (this.category != null) {
            sb.append(" My Category[").append(this.category).append("]\n");
        }
        if (this.instanceName != null) {
            sb.append(" My Instance Name[").append(this.instanceName).append("]\n");
        }
        sb.append(" My Counter Name[").append(this.counterName).append("]\n");
        return sb.toString();
    }

    public int hashCode() {
        return this.getStringRepresentation().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PerformanceCounter)) {
            return false;
        }
        PerformanceCounter other = (PerformanceCounter)o;
        return this.category.equals(other.category) && this.instanceName.equals(other.instanceName) && this.counterName.equals(other.counterName) && this.categoryNav.equals(other.categoryNav);
    }

    public static PerformanceCounter parse(String metricString) {
        if (metricString == null) {
            return new PerformanceCounter(new CategoryNav(""), "", "");
        }
        if (metricString.indexOf(METRIC_PATH_SEPARATOR) <= 0) {
            return new PerformanceCounter(new CategoryNav(metricString), metricString, metricString);
        }
        return PerformanceCounterFactory.createPerformanceCounter(metricString);
    }
}

