/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.metrics.boot;

import com.singularity.ee.metrics.boot.CategoryLink;
import com.singularity.ee.metrics.boot.CategoryPath;
import com.singularity.ee.util.collections.EqualsUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CategoryNav {
    private String monitorName;
    private CategoryPath categoryPath;

    public CategoryNav(String monitorName) {
        this.monitorName = monitorName;
        this.categoryPath = new CategoryPath();
    }

    public void addMetricLink(CategoryLink categoryLink) {
        this.categoryPath.add(categoryLink);
    }

    public void addMetricLink(String category) {
        this.categoryPath.add(new CategoryLink(category));
    }

    public void addMetricLink(String category, String instance) {
        this.categoryPath.add(new CategoryLink(category, instance));
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public List<CategoryLink> getMetricPath() {
        return this.categoryPath;
    }

    public String getLastCategoryName() {
        CategoryLink link = (CategoryLink)this.categoryPath.getLast();
        if (link != null) {
            return link.getCategory();
        }
        return null;
    }

    public String getLastInstanceName() {
        CategoryLink link = (CategoryLink)this.categoryPath.getLast();
        if (link != null) {
            return link.getInstanceName();
        }
        return null;
    }

    public CategoryNav getNavWithoutLastLink() {
        CategoryNav nav = new CategoryNav(this.monitorName);
        for (int i = 0; i < this.categoryPath.size() - 1; ++i) {
            if (i >= this.categoryPath.size()) continue;
            nav.addMetricLink((CategoryLink)this.categoryPath.get(i));
        }
        return nav;
    }

    public CategoryNav cloneNav() {
        CategoryNav nav = new CategoryNav(this.monitorName);
        for (int i = 0; i < this.categoryPath.size(); ++i) {
            if (i >= this.categoryPath.size()) continue;
            nav.addMetricLink((CategoryLink)this.categoryPath.get(i));
        }
        return nav;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CategoryNav)) {
            return false;
        }
        CategoryNav other = (CategoryNav)o;
        return this.monitorName.equals(other.getMonitorName()) && EqualsUtil.safeCompareCollections((Collection)((Object)this.categoryPath), other.getMetricPath());
    }

    public int hashCode() {
        int result = this.monitorName != null ? this.monitorName.hashCode() : 0;
        result = 31 * result + (this.categoryPath != null ? this.categoryPath.hashCode() : 0);
        return result;
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(150);
        if (this.monitorName != null) {
            sb.append(this.monitorName);
            sb.append("|");
        }
        Iterator iterator = this.categoryPath.iterator();
        while (iterator.hasNext()) {
            CategoryLink link = (CategoryLink)iterator.next();
            sb.append(link.getStringRepresentation()).append("|");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Metric Generated by Monitor[").append(this.monitorName).append("]\n\n");
        sb.append("Metric Path-");
        Iterator iterator = this.categoryPath.iterator();
        while (iterator.hasNext()) {
            CategoryLink link = (CategoryLink)iterator.next();
            sb.append(link).append("|");
        }
        return sb.toString();
    }
}

