/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.metrics.boot;

import com.singularity.ee.util.spi.IStringTokenizer;
import com.singularity.ee.util.string.StringOperations;
import java.util.ArrayList;
import java.util.List;

public class CategoryLink {
    private final String category;
    private String instanceName;
    private final String stringRepresentation;

    public CategoryLink(String category) {
        this.category = category;
        this.stringRepresentation = this.buildStringRepresentation();
    }

    public CategoryLink(String category, String instanceName) {
        this.category = category;
        this.instanceName = instanceName;
        this.stringRepresentation = this.buildStringRepresentation();
    }

    public String getCategory() {
        return this.category;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public static List<CategoryLink> parseLinks(String linkString) {
        ArrayList<CategoryLink> links = new ArrayList<CategoryLink>();
        IStringTokenizer linkTokenizer = StringOperations.createStringTokenizer((String)linkString, (String)"|");
        while (linkTokenizer.hasMoreTokens()) {
            CategoryLink mLink;
            String link = linkTokenizer.nextToken();
            if (link.indexOf(":") > 0) {
                String cat = link.substring(0, link.indexOf(":"));
                String instanceName = link.substring(link.indexOf(":") + 1, link.length());
                mLink = new CategoryLink(cat, instanceName);
            } else {
                mLink = new CategoryLink(link);
            }
            links.add(mLink);
        }
        return links;
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public String buildStringRepresentation() {
        StringBuilder sb = new StringBuilder(10);
        sb.append(this.category);
        if (this.instanceName != null) {
            sb.append(":").append(this.instanceName);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CategoryLink)) {
            return false;
        }
        CategoryLink other = (CategoryLink)o;
        return this.category.equals(other.category) && this.instanceName.equals(other.instanceName);
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Category [").append(this.category).append("]");
        if (this.instanceName != null) {
            sb.append(" + Instance Name [").append(this.instanceName).append("] ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(" ->" + CategoryLink.parseLinks("JavaAppMonitor|MyAgent|ThreadPools:MyThreadPool|Requestprocessor|servlet:myservlet"));
    }
}

