/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.metrics;

import com.singularity.ee.util.collections.CopyOnWriteMap;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IStringTokenizer;
import com.singularity.ee.util.string.StringOperations;
import java.util.Map;

public class UnresolvedComponentUtil {
    public static final String COMPONENT_OPEN = "{";
    public static final String COMPONENT_CLOSE = "}";
    public static final String IP_PORT_OPEN = "[";
    public static final String IP_PORT_CLOSE = "]";
    public static final String UNKNOWN_IP = "Unresolved IP";
    public static final String UNKNOWN_PORT = "Unresolved Port";
    public static final String BACKEND_CALL_PREFIX = "{[UNRESOLVED][";
    public static final String BACKEND_CALL_SUFFIX = "]}";
    public static int backendCallInfoBuilderLength = "{[UNRESOLVED][".length() + 4 + "]}".length();
    public static final Map<String, String> backendCallIdMap = new CopyOnWriteMap();

    public static String convertHostInformation(String host, String port) {
        StringBuilder builder = new StringBuilder(50);
        builder.append(COMPONENT_OPEN);
        builder.append(IP_PORT_OPEN).append(host).append(IP_PORT_CLOSE);
        builder.append(IP_PORT_OPEN).append(port).append(IP_PORT_CLOSE);
        builder.append(COMPONENT_CLOSE);
        return builder.toString();
    }

    public static String generateUnknownHostInfo() {
        return UnresolvedComponentUtil.convertHostInformation(UNKNOWN_IP, UNKNOWN_PORT);
    }

    public static String generateBackendCallInfo(String backendCallID) {
        String backendCallInfo = backendCallIdMap.get(backendCallID);
        if (backendCallInfo == null) {
            StringBuilder sb = new StringBuilder(backendCallInfoBuilderLength);
            sb.append(BACKEND_CALL_PREFIX).append(backendCallID).append(BACKEND_CALL_SUFFIX);
            backendCallInfo = sb.toString();
            backendCallIdMap.put(backendCallID, backendCallInfo);
        }
        return backendCallInfo;
    }

    public static String generateBackendId(long backendId) {
        StringBuilder sb = new StringBuilder(BACKEND_CALL_PREFIX);
        sb.append(backendId).append(BACKEND_CALL_SUFFIX);
        return sb.toString();
    }

    public static String parseBackendCallID(String toComponentLink) {
        return toComponentLink.substring(14, toComponentLink.lastIndexOf(BACKEND_CALL_SUFFIX));
    }

    public static String parseHost(String unresolvedComponentString, ILogger logger) {
        try {
            if (unresolvedComponentString.indexOf(IP_PORT_OPEN) > 0) {
                IStringTokenizer tokenizer = StringOperations.createStringTokenizer((String)unresolvedComponentString, (String)IP_PORT_OPEN);
                tokenizer.nextToken();
                String hostToken = tokenizer.nextToken();
                return hostToken.substring(0, hostToken.length() - 1);
            }
        }
        catch (Exception e) {
            logger.warn("Invalid Unresolved Component Format " + unresolvedComponentString, (Throwable)e);
        }
        return null;
    }

    public static String parsePort(String unresolvedComponentString, ILogger logger) {
        try {
            if (unresolvedComponentString.indexOf(IP_PORT_OPEN) > 0) {
                IStringTokenizer tokenizer = StringOperations.createStringTokenizer((String)unresolvedComponentString, (String)IP_PORT_OPEN);
                tokenizer.nextToken();
                tokenizer.nextToken();
                String portToken = tokenizer.nextToken();
                return portToken.substring(0, portToken.lastIndexOf(IP_PORT_CLOSE));
            }
        }
        catch (Exception e) {
            logger.warn("Invalid Unresolved Component Format " + unresolvedComponentString, (Throwable)e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String unresolvedString = UnresolvedComponentUtil.convertHostInformation("101.20.30.45", "700600");
        System.out.println("Unresolved String " + unresolvedString);
        System.out.println("" + UnresolvedComponentUtil.parseHost(unresolvedString, null));
        System.out.println("" + UnresolvedComponentUtil.parsePort(unresolvedString, null));
        System.out.println("---" + UnresolvedComponentUtil.parseBackendCallID("{[UNRESOLVED][2]}"));
    }
}

