/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.generator;

import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.generator.DtoProtocolBufferVisitor;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ProtocolBufferGenerator {
    static final String PB_PACKAGE = "com.singularity.ee.dto.pb";

    public static void main(String[] args) throws Exception {
        JarFile apiJar = new JarFile(args[0]);
        File destDir = new File(args[1]);
        ProtoFiles protoFiles = new ProtoFiles(destDir);
        Enumeration<JarEntry> entries = apiJar.entries();
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        while (entries.hasMoreElements()) {
            GenProto genProto;
            Class<?> clazz;
            String qalifiedClassName = entries.nextElement().getName();
            if (!qalifiedClassName.endsWith(".class") || qalifiedClassName.contains("$")) continue;
            qalifiedClassName = qalifiedClassName.replace('/', '.');
            qalifiedClassName = qalifiedClassName.substring(0, qalifiedClassName.lastIndexOf(46));
            try {
                clazz = Class.forName(qalifiedClassName);
            }
            catch (Throwable t) {
                System.out.println("Unable to read class " + qalifiedClassName + " due to " + t.getMessage());
                continue;
            }
            if (clazz.getAnnotation(IgnoreProtoGen.class) != null || (genProto = clazz.getAnnotation(GenProto.class)) == null || Enum.class.isAssignableFrom(clazz) || clazz.isInterface()) continue;
            String specifiedTargetProto = genProto.protoFile();
            String protoFileName = specifiedTargetProto.length() == 0 ? "DTOProtocolBuffers.proto" : specifiedTargetProto;
            ProtoFile protoFile = protoFiles.get(protoFileName);
            protoFile.visitClass(clazz, genProto);
        }
        protoFiles.write();
    }

    private static final class ProtoFiles {
        private final File destDir;
        private final HashMap<String, ProtoFile> map;

        public ProtoFiles(File destDir) {
            this.destDir = destDir;
            this.map = new HashMap();
        }

        public ProtoFile get(String baseName) {
            ProtoFile existing = this.map.get(baseName);
            if (existing != null) {
                return existing;
            }
            ProtoFile newFile = new ProtoFile(new File(this.destDir, baseName));
            this.map.put(baseName, newFile);
            return newFile;
        }

        public void write() throws IOException {
            if (!this.destDir.exists()) {
                this.destDir.mkdirs();
            }
            for (Map.Entry<String, ProtoFile> entry : this.map.entrySet()) {
                entry.getValue().write();
            }
        }
    }

    private static final class ProtoFile {
        private final File outputFile;
        private final CharArrayWriter messagesWriter;
        private final DtoProtocolBufferVisitor visitor;

        ProtoFile(File outputFile) {
            this.outputFile = outputFile;
            this.messagesWriter = new CharArrayWriter();
            this.visitor = new DtoProtocolBufferVisitor(new PrintWriter(this.messagesWriter));
        }

        public void visitClass(Class<?> clazz, GenProto genProto) {
            this.visitor.visitClass(clazz, genProto);
            if (genProto.replacementMessage().length() == 0) {
                for (Field field : clazz.getDeclaredFields()) {
                    this.visitor.visitField(field);
                }
            }
            this.visitor.finishClass(clazz, genProto);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException {
            try (PrintWriter fileWriter = new PrintWriter(new FileWriter(this.outputFile));){
                fileWriter.println("package com.singularity.ee.dto.pb;");
                fileWriter.println("import \"ProtocolBufferPayload.proto\";");
                String thisProto = this.outputFile.getName();
                for (String string : this.visitor.getProtosToImport()) {
                    if (thisProto.equals(string)) continue;
                    fileWriter.println("import \"" + string + "\";");
                }
                for (Map.Entry entry : this.visitor.getImportMap().entrySet()) {
                    String importedProto = (String)entry.getKey();
                    if (thisProto.equals(importedProto)) continue;
                    fileWriter.println("//  " + importedProto);
                    for (String ref : (Set)entry.getValue()) {
                        fileWriter.println("//    " + ref);
                    }
                }
                this.messagesWriter.close();
                fileWriter.write(this.messagesWriter.toCharArray());
                String protopartName = this.outputFile.getName() + "part";
                String string = System.getProperty("user.dir");
                String protopartPath = string + "/src/main/proto/" + protopartName;
                File protopartFile = new File(protopartPath);
                if (protopartFile.exists()) {
                    fileWriter.write("// End of generated messages\n\n" + ProtoFile.readFile(protopartFile));
                }
            }
        }

        static String readFile(File file) throws IOException {
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fis.read(data);
            fis.close();
            String str = new String(data, "UTF-8");
            return str;
        }
    }
}

