/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.generator;

import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.controller.api.dto.annotations.UseList;
import com.singularity.ee.generator.IProtocolBufferVisitor;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AProtocolBufferVisitor
implements IProtocolBufferVisitor {
    protected static final String BOOLEAN_TYPE = "bool";
    protected static final String STRING_TYPE = "string";
    protected static final String ARRAY_TYPE = "repeated";
    protected static final String NUMBER_TYPE = "int64";
    protected static final String INTEGER_TYPE = "int32";
    protected static final String FLOAT_TYPE = "float";
    protected static final String DATE_TYPE = "int64";
    protected static final String MAP_TYPE = "com.singularity.ee.rest.controller.proto.request.Entries";
    protected String tab = "  ";
    private final Map<String, Set<String>> protosToImport = new TreeMap<String, Set<String>>();
    private final Set<String> additionalMessagesToBeWritten = new HashSet<String>();
    private final Set<String> allAdditionalMessages = new HashSet<String>();
    protected final PrintWriter messagesWriter;

    protected String getIndentation(int count) {
        StringBuilder indentation = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            indentation.append(this.tab);
        }
        return indentation.toString();
    }

    public AProtocolBufferVisitor(PrintWriter messagesWriter) {
        this.messagesWriter = messagesWriter;
    }

    @Override
    public void finishClass(Class<?> clazz, GenProto genProto) {
        boolean hasReplacement;
        String replacementMessage = genProto.replacementMessage();
        boolean bl = hasReplacement = replacementMessage.length() != 0;
        if (!hasReplacement) {
            this.messagesWriter.println("}");
        }
        this.additionalMessagesToBeWritten.removeAll(this.allAdditionalMessages);
        for (String message : this.additionalMessagesToBeWritten) {
            this.messagesWriter.println(message);
        }
        this.allAdditionalMessages.addAll(this.additionalMessagesToBeWritten);
        if (genProto.needsList()) {
            String messageName = clazz.getSimpleName();
            if (hasReplacement) {
                messageName = replacementMessage;
                this.addImport(replacementMessage, genProto.replacementDefiningProto());
            }
            this.messagesWriter.println("message " + clazz.getSimpleName() + "List");
            this.messagesWriter.println("{");
            this.messagesWriter.println(this.getIndentation(2) + "repeated " + messageName + " " + clazz.getSimpleName().toLowerCase() + "List = 2;");
            this.messagesWriter.println("}");
            this.messagesWriter.flush();
        }
    }

    @Override
    public void visitClass(Class<?> clazz, GenProto genProto) {
        Class<?> superclass = clazz.getSuperclass();
        if (genProto.replacementMessage().length() != 0) {
            return;
        }
        this.messagesWriter.println("message " + clazz.getSimpleName());
        this.messagesWriter.println("{");
        this.messagesWriter.println(superclass == Object.class ? "" : this.getIndentation(2) + "optional " + this.getTypeName(superclass) + " parent = 1;");
    }

    private String getTypeName(Class<?> clazz) {
        if (clazz == Long.class || clazz == Long.TYPE || clazz == Double.TYPE || clazz == Date.class) {
            return "int64";
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return FLOAT_TYPE;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return INTEGER_TYPE;
        }
        if (clazz.isArray()) {
            return this.getTypeName(clazz.getComponentType());
        }
        if (clazz.isEnum()) {
            return STRING_TYPE;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN_TYPE;
        }
        if (clazz == String.class) {
            return STRING_TYPE;
        }
        IgnoreProtoGen ignoreProtoGen = clazz.getAnnotation(IgnoreProtoGen.class);
        if (ignoreProtoGen != null) {
            throw new InvalidFieldTypeException("Field references DTO class that is marked with IgnoreProtoGen.", clazz);
        }
        GenProto genProto = clazz.getAnnotation(GenProto.class);
        if (genProto == null) {
            throw new InvalidFieldTypeException("Field references DTO class that is not marked with GenProto", clazz);
        }
        String replacementMessage = genProto.replacementMessage();
        if (replacementMessage.length() != 0) {
            String replacementMessageProto = genProto.replacementDefiningProto();
            if (replacementMessageProto.length() == 0) {
                throw new InvalidFieldTypeException("Field references DTO class marked with " + GenProto.class.getSimpleName() + " with a replacementMessage attribute, but without a replacementDefiningProto attribute", clazz);
            }
            this.addImport(clazz, replacementMessageProto);
            return replacementMessage;
        }
        String protoToImport = genProto.protoFile();
        if (protoToImport.length() != 0) {
            this.addImport(clazz, protoToImport);
        } else {
            this.addImport(clazz, "DTOProtocolBuffers.proto");
        }
        return clazz.getSimpleName();
    }

    private void addImport(String messageName, String protoToImport) {
        Set<String> exitingReferences = this.protosToImport.get(protoToImport);
        if (exitingReferences != null) {
            exitingReferences.add(messageName);
        } else {
            TreeSet<String> referenceSet = new TreeSet<String>();
            referenceSet.add(messageName);
            this.protosToImport.put(protoToImport, referenceSet);
        }
    }

    private void addImport(Class<?> clazz, String protoToImport) {
        this.addImport(clazz.getSimpleName(), protoToImport);
    }

    @Override
    public void visitField(Field field) {
        block14: {
            try {
                if (field.getAnnotation(IgnoreProtoGen.class) != null) break block14;
                FieldPosition fieldPosition = field.getAnnotation(FieldPosition.class);
                if (field.getType().isArray()) {
                    if (field.getType().getComponentType().equals(Byte.TYPE)) {
                        this.messagesWriter.println(this.getIndentation(2) + "optional bytes " + field.getName() + " = " + fieldPosition.value() + ";");
                    } else {
                        this.messagesWriter.println(this.getIndentation(2) + ARRAY_TYPE + " " + this.getTypeName(field.getType()) + " " + field.getName() + " = " + fieldPosition.value() + ";");
                    }
                    break block14;
                }
                if (field.getType() == List.class || field.getType() == Set.class || field.getType() == Collection.class) {
                    this.messagesWriter.println(this.getIndentation(2) + ARRAY_TYPE + " " + this.getTypeName((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) + " " + field.getName() + " = " + fieldPosition.value() + ";");
                    break block14;
                }
                if (field.getType() == Map.class && fieldPosition.isMap()) {
                    String repeatedName;
                    String optionalOrRepeated;
                    String valTypeName;
                    Type[] typeParams = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                    String keyTypeName = this.getTypeName((Class)typeParams[0]);
                    try {
                        ParameterizedType valType = (ParameterizedType)typeParams[1];
                        if (valType.getActualTypeArguments().length != 1) {
                            throw new InvalidFieldTypeException("Expected the second type parameter to have exactly 1 parameter.", field.getType());
                        }
                        valTypeName = this.getTypeName((Class)valType.getActualTypeArguments()[0]);
                        optionalOrRepeated = ARRAY_TYPE;
                        repeatedName = "Repeated";
                    }
                    catch (ClassCastException e) {
                        valTypeName = this.getTypeName((Class)typeParams[1]);
                        optionalOrRepeated = "optional";
                        repeatedName = "";
                    }
                    String additionalMessageName = keyTypeName + "To" + repeatedName + this.capitalizeFirstLetter(valTypeName) + "Pair";
                    String additionalMessage = "message " + additionalMessageName + "\n{\n" + this.getIndentation(2) + "optional " + keyTypeName + " key = 1;\n" + this.getIndentation(2) + optionalOrRepeated + " " + valTypeName + " value = 2;\n}";
                    this.additionalMessagesToBeWritten.add(additionalMessage);
                    this.messagesWriter.println(this.getIndentation(2) + ARRAY_TYPE + " " + additionalMessageName + " " + field.getName() + " = " + fieldPosition.value() + ";");
                    break block14;
                }
                if (field.getType() == Map.class) {
                    this.messagesWriter.println(this.getIndentation(2) + "optional " + MAP_TYPE + " " + field.getName() + " = " + fieldPosition.value() + ";");
                } else if (field.getAnnotation(UseList.class) != null) {
                    this.messagesWriter.println(this.getIndentation(2) + ARRAY_TYPE + " " + this.getTypeName((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) + " " + field.getName() + " = " + fieldPosition.value() + ";");
                } else {
                    this.messagesWriter.println(this.getIndentation(2) + "optional " + this.getTypeName(field.getType()) + " " + field.getName() + " = " + fieldPosition.value() + ";");
                }
            }
            catch (InvalidFieldTypeException e) {
                throw new InvalidFieldException("Unable to compute proto message for " + e.fieldType.getSimpleName() + " referenced by " + field.getName() + " in " + field.getDeclaringClass().getSimpleName(), e);
            }
        }
    }

    private String capitalizeFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public final Set<String> getProtosToImport() {
        return this.protosToImport.keySet();
    }

    public final Map<String, Set<String>> getImportMap() {
        return this.protosToImport;
    }

    private static class InvalidFieldTypeException
    extends RuntimeException {
        public final Class<?> fieldType;

        InvalidFieldTypeException(String message, Class<?> fieldType) {
            super(message);
            this.fieldType = fieldType;
        }
    }

    private static class InvalidFieldException
    extends RuntimeException {
        InvalidFieldException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

