/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.controller.api.constants.ConditionOperator;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.controller.api.dto.AggregationScopeTriggeredConditions;
import com.singularity.ee.controller.api.dto.ConditionValueFunction;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.PolicyEventDetails;
import com.singularity.ee.controller.api.dto.TriggeredCondition;
import com.singularity.ee.events.translate.IEventDataDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import com.singularity.ee.util.enums.EnumHelper;
import java.util.HashMap;
import java.util.Map;

public class PolicyEventsEncoderDecoder
implements IEventDataEncoder,
IEventDataDecoder {
    private static final String EVENT_KEY_RULE_NAME = "Policy Name";
    private static final String EVENT_KEY_NUM_CONDITIONS = "Num Conditions";
    private static final String EVENT_KEY_OBSERVED_VALUE = "Observed Value";
    private static final String EVENT_KEY_THRESHOLD_VALUE = "Threshold Value";
    private static final String EVENT_KEY_VALUE_FUNCTION = "Value Function";
    private static final String EVENT_KEY_OPERATOR = "Operator";
    private static final String EVENT_KEY_CONDITION_NAME = "Metric Condition Name";
    private static final String EVENT_KEY_CONDITION_ID = "Condition ID";
    private static final String EVENT_KEY_SCOPE_TYPE = "Scope Type";
    private static final String EVENT_KEY_SCOPE_ID = "Scope ID";
    private static final String EVENT_KEY_INCIDENT_ID = "Incident ID";
    private static final String EVENT_KEY_JMX_SCOPE = "JMX Pool Name";
    private static final String EVALUATION_START_TIME = "Evaluation Start Time";
    private static final String EVALUATION_END_TIME = "Evaluation End Time";
    public static final String EVALUATION_SUMMARY = "Evaluation Summary";
    public static final String EVALUATION_DESCRIPTION = "Evaluation Description";

    @Override
    public EventDetails decodeEventData(NameValuePair[] eventData) {
        PolicyEventDetails alertEventDetails = new PolicyEventDetails(eventData);
        return this.decodeEventDataInternal(NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventData), alertEventDetails);
    }

    @Override
    public EventDetails decodeEventData(Map<String, String> eventDetailsMap) {
        PolicyEventDetails alertEventDetails = new PolicyEventDetails(NameValuePair.convertMap(eventDetailsMap));
        return this.decodeEventDataInternal(eventDetailsMap, alertEventDetails);
    }

    private EventDetails decodeEventDataInternal(Map<String, String> eventDetailsMap, PolicyEventDetails alertEventDetails) {
        alertEventDetails.setPolicyName(eventDetailsMap.get(EVENT_KEY_RULE_NAME));
        AggregationScopeTriggeredConditions astc = new AggregationScopeTriggeredConditions();
        String keyScopeType = eventDetailsMap.get(EVENT_KEY_SCOPE_TYPE);
        String keyScopeId = eventDetailsMap.get(EVENT_KEY_SCOPE_ID);
        if (keyScopeType != null && keyScopeId != null) {
            EntityDefinition ed = new EntityDefinition((EntityType)EnumHelper.getEnum(EntityType.class, (String)keyScopeType), Long.parseLong(keyScopeId));
            astc.setEntityDefinition(ed);
        } else {
            astc.setJmxPoolName(eventDetailsMap.get(EVENT_KEY_JMX_SCOPE));
        }
        String numOfConditions = eventDetailsMap.get(EVENT_KEY_NUM_CONDITIONS);
        if (numOfConditions != null && Integer.parseInt(numOfConditions) != 0) {
            int numTriggeredConditions = Integer.parseInt(numOfConditions);
            TriggeredCondition[] conditions = new TriggeredCondition[numTriggeredConditions];
            for (int i = 0; i < conditions.length; ++i) {
                String keyPrefix = i + 1 + ":";
                TriggeredCondition cond = new TriggeredCondition();
                cond.setConditionName(eventDetailsMap.get(keyPrefix + EVENT_KEY_CONDITION_NAME));
                cond.setConditionId(Long.parseLong(eventDetailsMap.get(keyPrefix + EVENT_KEY_CONDITION_ID)));
                cond.setOperator((ConditionOperator)EnumHelper.getEnum(ConditionOperator.class, (String)eventDetailsMap.get(keyPrefix + EVENT_KEY_OPERATOR)));
                ConditionValueFunction valueFunction = new ConditionValueFunction();
                valueFunction.setType((FunctionType)EnumHelper.getEnum(FunctionType.class, (String)eventDetailsMap.get(keyPrefix + EVENT_KEY_VALUE_FUNCTION)));
                cond.setValueFunction(valueFunction);
                cond.setThresholdValue((double)Long.parseLong(eventDetailsMap.get(keyPrefix + EVENT_KEY_THRESHOLD_VALUE)));
                cond.setObservedValue((double)Long.parseLong(eventDetailsMap.get(keyPrefix + EVENT_KEY_OBSERVED_VALUE)));
                conditions[i] = cond;
            }
            astc.setConditions(conditions);
        }
        alertEventDetails.setConditions(astc);
        alertEventDetails.setIncidentId(Long.parseLong(eventDetailsMap.get(EVENT_KEY_INCIDENT_ID)));
        alertEventDetails.setEvaluationStartTime(Long.parseLong(eventDetailsMap.get(EVALUATION_START_TIME)));
        alertEventDetails.setEvaluationEndTime(Long.parseLong(eventDetailsMap.get(EVALUATION_END_TIME)));
        alertEventDetails.setSummary(eventDetailsMap.get(EVALUATION_SUMMARY));
        alertEventDetails.setDescription(eventDetailsMap.get(EVALUATION_DESCRIPTION));
        return alertEventDetails;
    }

    @Override
    public Map<String, String> encodeEventData(EventDetails eventDetails) {
        PolicyEventDetails alertEventDetails = (PolicyEventDetails)eventDetails;
        HashMap<String, String> eventDetailsMap = new HashMap<String, String>();
        eventDetailsMap.put(EVALUATION_START_TIME, String.valueOf(alertEventDetails.getEvaluationStartTime()));
        eventDetailsMap.put(EVALUATION_END_TIME, String.valueOf(alertEventDetails.getEvaluationEndTime()));
        eventDetailsMap.put(EVENT_KEY_RULE_NAME, alertEventDetails.getPolicyName());
        AggregationScopeTriggeredConditions astc = alertEventDetails.getConditions();
        eventDetailsMap.put(EVENT_KEY_INCIDENT_ID, String.valueOf(alertEventDetails.getIncidentId()));
        eventDetailsMap.put(EVALUATION_SUMMARY, alertEventDetails.getSummary());
        eventDetailsMap.put(EVALUATION_DESCRIPTION, alertEventDetails.getDescription());
        if (astc == null) {
            return eventDetailsMap;
        }
        TriggeredCondition[] triggeredConditions = astc.getConditions();
        EntityDefinition entityDefinition = astc.getEntityDefinition();
        if (entityDefinition != null) {
            eventDetailsMap.put(EVENT_KEY_SCOPE_TYPE, EnumHelper.getName((Enum)entityDefinition.getEntityType(), (Enum)entityDefinition.getEntityType()));
            eventDetailsMap.put(EVENT_KEY_SCOPE_ID, String.valueOf(entityDefinition.getEntityId()));
        } else {
            String jmxPoolName = astc.getJmxPoolName();
            if (jmxPoolName != null) {
                eventDetailsMap.put(EVENT_KEY_JMX_SCOPE, jmxPoolName);
            }
        }
        int counter = 1;
        if (triggeredConditions != null && triggeredConditions.length != 0) {
            for (TriggeredCondition cond : triggeredConditions) {
                String keyPrefix = counter + ":";
                eventDetailsMap.put(keyPrefix + EVENT_KEY_CONDITION_NAME, cond.getConditionName());
                eventDetailsMap.put(keyPrefix + EVENT_KEY_CONDITION_ID, String.valueOf(cond.getConditionId()));
                eventDetailsMap.put(keyPrefix + EVENT_KEY_OPERATOR, EnumHelper.getName((Enum)cond.getOperator(), (Enum)cond.getOperator()));
                if (cond.getValueFunction() != null) {
                    eventDetailsMap.put(keyPrefix + EVENT_KEY_VALUE_FUNCTION, EnumHelper.getName((Enum)cond.getValueFunction().getType(), (Enum)cond.getValueFunction().getType()));
                }
                eventDetailsMap.put(keyPrefix + EVENT_KEY_THRESHOLD_VALUE, String.valueOf(cond.getThresholdValue()));
                eventDetailsMap.put(keyPrefix + EVENT_KEY_OBSERVED_VALUE, String.valueOf(cond.getObservedValue()));
                ++counter;
            }
            eventDetailsMap.put(EVENT_KEY_NUM_CONDITIONS, String.valueOf(triggeredConditions.length));
        }
        return eventDetailsMap;
    }
}

