/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.ObjectContentSummaryEventDetails;
import com.singularity.ee.events.translate.IEventDataDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import java.util.HashMap;
import java.util.Map;

public class ObjectContentSummaryEventEncoderDecoder
implements IEventDataEncoder,
IEventDataDecoder {
    public static final String NUM_CLASSES_AND_INSTANCE_DETAIL_KEY = "num-of-classes-with-instance-detail";
    public static final String CLASS_NAME_KEY = "class-name";
    public static final String DETAIL_KEY = "detail";
    public static final String TOTAL_SIZE = "total-size";
    public static final String ERROR_MESSAGE = "error";

    @Override
    public EventDetails decodeEventData(NameValuePair[] eventData) {
        ObjectContentSummaryEventDetails eventDetails = new ObjectContentSummaryEventDetails();
        return this.decodeEventDataInternal(NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventData), eventDetails);
    }

    @Override
    public EventDetails decodeEventData(Map<String, String> eventData) {
        ObjectContentSummaryEventDetails eventDetails = new ObjectContentSummaryEventDetails();
        return this.decodeEventDataInternal(eventData, eventDetails);
    }

    @Override
    public Map<String, String> encodeEventData(EventDetails eventDetails) {
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        ObjectContentSummaryEventDetails event = (ObjectContentSummaryEventDetails)eventDetails;
        eventDataMap.put(TOTAL_SIZE, Long.toString(event.getTotalSize()));
        NameValuePair[] classNameToInstanceCount = event.getContainedObjectCount();
        Map classNameToInstanceCountMap = NameValuePair.convertNameValuePairsToMap((NameValuePair[])classNameToInstanceCount);
        eventDataMap.put(NUM_CLASSES_AND_INSTANCE_DETAIL_KEY, String.valueOf(classNameToInstanceCountMap.size()));
        this.populateMap(eventDataMap, classNameToInstanceCountMap, CLASS_NAME_KEY, DETAIL_KEY);
        eventDataMap.put(ERROR_MESSAGE, event.getErrorMessage());
        return eventDataMap;
    }

    private EventDetails decodeEventDataInternal(Map<String, String> eventMap, ObjectContentSummaryEventDetails eventDetails) {
        int noOfClassInstanceCounts;
        if (eventMap.get(TOTAL_SIZE) != null) {
            eventDetails.setTotalSize(Long.parseLong(eventMap.get(TOTAL_SIZE)));
        }
        if ((noOfClassInstanceCounts = Integer.parseInt(eventMap.get(NUM_CLASSES_AND_INSTANCE_DETAIL_KEY))) > 0) {
            Map<String, String> classNameToInstanceDetailMap = this.extractFromMap(eventMap, noOfClassInstanceCounts, CLASS_NAME_KEY, DETAIL_KEY);
            eventDetails.setContainedObjectCount(NameValuePair.convertMap(classNameToInstanceDetailMap));
        }
        eventDetails.setErrorMessage(eventMap.get(ERROR_MESSAGE));
        return eventDetails;
    }

    private void populateMap(Map<String, String> eventMap, Map<String, String> map, String name, String val) {
        int index = 0;
        for (String key : map.keySet()) {
            eventMap.put(name + "." + index, key);
            eventMap.put(val + "." + index, map.get(key));
            ++index;
        }
    }

    private Map<String, String> extractFromMap(Map<String, String> eventMap, int size, String key, String val) {
        HashMap<String, String> vals = new HashMap<String, String>(size);
        for (int inx = 0; inx < size; ++inx) {
            String name = eventMap.get(key + "." + inx);
            String value = eventMap.get(val + "." + inx);
            vals.put(name, value);
        }
        return vals;
    }
}

