/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.events.translate.ActivityTraceEventEncoderDecoder;
import com.singularity.ee.events.translate.AlertEventEncoderDecoder;
import com.singularity.ee.events.translate.BTEventDataEncoderDecoder;
import com.singularity.ee.events.translate.BTOverflowEventDataEncoderDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import com.singularity.ee.events.translate.ObjectContentSummaryEventEncoderDecoder;
import com.singularity.ee.events.translate.PolicyEventsEncoderDecoder;

public class EventEncoderFactory {
    private IEventDataEncoder btResponseTimeViolationEventEncoder = null;
    private IEventDataEncoder alertEventEncoder = null;
    private IEventDataEncoder activityTraceEventEncoder = null;
    private IEventDataEncoder objectContentSummaryEncoder = null;
    private IEventDataEncoder btOverflowDataEncoder;
    private IEventDataEncoder policyEventEncoder = null;
    private static EventEncoderFactory encoderFactory = new EventEncoderFactory();

    private EventEncoderFactory() {
        try {
            this.btResponseTimeViolationEventEncoder = new BTEventDataEncoderDecoder();
            this.alertEventEncoder = new AlertEventEncoderDecoder();
            this.activityTraceEventEncoder = new ActivityTraceEventEncoderDecoder();
            this.objectContentSummaryEncoder = new ObjectContentSummaryEventEncoderDecoder();
            this.btOverflowDataEncoder = new BTOverflowEventDataEncoderDecoder();
            this.policyEventEncoder = new PolicyEventsEncoderDecoder();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Error in instantiating data encoder", e);
        }
    }

    public static EventEncoderFactory getEncoderFactory() {
        return encoderFactory;
    }

    public IEventDataEncoder getBTResponseTimeViolationEventEncoder() {
        return this.btResponseTimeViolationEventEncoder;
    }

    public IEventDataEncoder getAlertEventEncoder() {
        return this.alertEventEncoder;
    }

    public IEventDataEncoder getActivityTraceEventEncoder() {
        return this.activityTraceEventEncoder;
    }

    public IEventDataEncoder getObjectContentSummaryEncoder() {
        return this.objectContentSummaryEncoder;
    }

    public IEventDataEncoder getBTOverflowDataEncoder() {
        return this.btOverflowDataEncoder;
    }

    public IEventDataEncoder getPolicyEventEncoder() {
        return this.policyEventEncoder;
    }
}

