/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.controller.api.dto.BTOverflowEventDetails;
import com.singularity.ee.controller.api.dto.DroppedTransaction;
import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.events.translate.IEventDataDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import com.singularity.ee.util.collections.CollectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BTOverflowEventDataEncoderDecoder
implements IEventDataEncoder,
IEventDataDecoder {
    @Override
    public Map<String, String> encodeEventData(EventDetails eventDetails) {
        if (eventDetails instanceof BTOverflowEventDetails) {
            return ((BTOverflowEventDetails)eventDetails).toMap();
        }
        throw new IllegalArgumentException(eventDetails + " object is not of type BTOverflowEventDetails");
    }

    @Override
    public EventDetails decodeEventData(NameValuePair[] eventData) {
        if (eventData == null || eventData.length == 0) {
            return null;
        }
        BTOverflowEventDetails details = new BTOverflowEventDetails();
        ArrayList<DroppedTransaction> list = new ArrayList<DroppedTransaction>();
        for (NameValuePair nameValuePair : eventData) {
            this.parseAndAdd(details, list, nameValuePair.getName(), nameValuePair.getValue());
        }
        details.setDroppedTransactions((DroppedTransaction[])CollectionHelper.collectionToArray(list, (Object[])new DroppedTransaction[0]));
        return list.size() == 0 ? null : details;
    }

    @Override
    public EventDetails decodeEventData(Map<String, String> eventData) {
        if (eventData == null || eventData.size() == 0) {
            return null;
        }
        BTOverflowEventDetails details = new BTOverflowEventDetails();
        ArrayList<DroppedTransaction> list = new ArrayList<DroppedTransaction>();
        for (String name : eventData.keySet()) {
            this.parseAndAdd(details, list, name, eventData.get(name));
        }
        details.setDroppedTransactions((DroppedTransaction[])CollectionHelper.collectionToArray(list, (Object[])new DroppedTransaction[0]));
        return list.size() == 0 ? null : details;
    }

    public void parseAndAdd(BTOverflowEventDetails details, List<DroppedTransaction> list, String name, String value) {
        DroppedTransaction parsed = DroppedTransaction.fromString((String)name, (String)value);
        if (parsed != null) {
            parsed.setDroppedCount(parsed.getCount().get());
            if (parsed.getName().equals("Overflow Limit Reached")) {
                details.setOverheadCaptureLimitReached(parsed.getCount().get());
            } else {
                list.add(parsed);
            }
        }
    }
}

