/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.controller.api.constants.SQLStatementType;
import com.singularity.ee.controller.api.dto.BTResponseTimeViolationEventDetails;
import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.SQLStatementDetails;
import com.singularity.ee.events.translate.IEventDataDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.string.StringOperations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BTEventDataEncoderDecoder
implements IEventDataEncoder,
IEventDataDecoder {
    public static final String USER_DATA = "user-data";
    public static final String POJO_DATA_SET = "pojo-data-set";
    public static final String POJO_USER_DATA_NAME = "pojo-data-name";
    public static final String POJO_USER_DATA_VALUE = "pojo-data-value";
    public static final String HTTP_PARAMS = "http-params";
    public static final String HTTP_PARAM_NAME = "http-param-name";
    public static final String HTTP_PARAM_VALUE = "http-param-value";
    public static final String COOKIES = "cookies";
    public static final String COOKIE_NAME = "cookie-name";
    public static final String COOKIE_VALUE = "cookie-value";
    public static final String ERRORS = "errors";
    public static final String ERROR_NAME = "error-name";
    public static final String ERROR_VALUE = "error-value";
    public static final String SQL_QUERIES = "sql-queries";
    public static final String SQL_QUERY_TYPE = "sql-query-type";
    public static final String SQL_QUERY_VALUE = "sql-query-value";
    public static final String SQL_QUERY_TIME = "sql-query-time";
    public static final String OBSERVED_RESPONSE_TIME = "observed-response-time";
    public static final String WARNING_THRESHOLD = "warning-threshold";
    public static final String CRITICAL_THRESHOLD = "critical-threshold";
    public static final String URL = "url";
    public static final String SESSION_ID = "session-id";
    public static final String USER_PRINCIPAL = "user-principal";
    public static final String XML_KEY = "encoded-xml";

    @Override
    public Map<String, String> encodeEventData(EventDetails eventDetails) {
        return this.encodeEventToMap(eventDetails);
    }

    @Override
    public EventDetails decodeEventData(NameValuePair[] eventData) {
        BTResponseTimeViolationEventDetails eventDetails = new BTResponseTimeViolationEventDetails(eventData);
        return this.decodeEventDataInternal(NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventData), eventDetails);
    }

    @Override
    public EventDetails decodeEventData(Map<String, String> eventData) {
        BTResponseTimeViolationEventDetails eventDetails = new BTResponseTimeViolationEventDetails(NameValuePair.convertMap(eventData));
        return this.decodeEventDataInternal(eventData, eventDetails);
    }

    public EventDetails decodeEventDataInternal(Map<String, String> eventMap, BTResponseTimeViolationEventDetails eventDetails) {
        int size;
        int errorSize;
        int pojoDataSize;
        int cookieSize;
        eventDetails.setSessionID(eventMap.get(SESSION_ID));
        eventDetails.setUserPrincipal(eventMap.get(USER_PRINCIPAL));
        eventDetails.setUrl(eventMap.get(URL));
        eventDetails.setObservedRT(eventMap.get(OBSERVED_RESPONSE_TIME));
        eventDetails.setWarningThreshold(eventMap.get(WARNING_THRESHOLD));
        eventDetails.setCriticalThreshold(eventMap.get(CRITICAL_THRESHOLD));
        int httpParamSize = this.safeParseInt(eventMap.get(HTTP_PARAMS));
        if (httpParamSize > 0) {
            eventDetails.setHttpParams(this.extractFromMap(eventMap, httpParamSize, HTTP_PARAM_NAME, HTTP_PARAM_VALUE));
        }
        if ((cookieSize = this.safeParseInt(eventMap.get(COOKIES))) > 0) {
            eventDetails.setCookies(this.extractFromMap(eventMap, cookieSize, COOKIE_NAME, COOKIE_VALUE));
        }
        if ((pojoDataSize = this.safeParseInt(eventMap.get(POJO_DATA_SET))) > 0) {
            eventDetails.setUserData(this.extractFromMap(eventMap, pojoDataSize, POJO_USER_DATA_NAME, POJO_USER_DATA_VALUE));
        }
        if ((errorSize = this.safeParseInt(eventMap.get(ERRORS))) > 0) {
            eventDetails.setErrorDetails(this.extractFromMap(eventMap, errorSize, ERROR_NAME, ERROR_VALUE));
        }
        if ((size = this.safeParseInt(eventMap.get(SQL_QUERIES))) > 0) {
            SQLStatementDetails[] queries = new SQLStatementDetails[size];
            for (int inx = 0; inx < size; ++inx) {
                SQLStatementDetails statementDetails = new SQLStatementDetails();
                statementDetails.setStatementType((SQLStatementType)EnumHelper.getEnum(SQLStatementType.class, (String)eventMap.get("sql-query-type." + inx)));
                statementDetails.setSqlStatement(eventMap.get("sql-query-value." + inx));
                statementDetails.setExecutionTime(Long.parseLong(eventMap.get("sql-query-time." + inx)));
                queries[inx] = statementDetails;
            }
            eventDetails.setSqlStatementDetails(queries);
        }
        return eventDetails;
    }

    private int safeParseInt(String string) {
        return string == null ? 0 : Integer.parseInt(string);
    }

    private Map<String, String> extractFromMap(Map<String, String> eventMap, int size, String key, String val) {
        HashMap<String, String> vals = new HashMap<String, String>(size);
        for (int inx = 0; inx < size; ++inx) {
            String name = eventMap.get(key + "." + inx);
            String value = eventMap.get(val + "." + inx);
            vals.put(name, value);
        }
        return vals;
    }

    private void populateIfNotNull(Map<String, String> eventMap, String key, String val) {
        if (!StringOperations.isEmpty((String)val)) {
            eventMap.put(key, val);
        }
    }

    private Map<String, String> encodeEventToMap(EventDetails event) {
        BTResponseTimeViolationEventDetails eventDetails = (BTResponseTimeViolationEventDetails)event;
        HashMap<String, String> eventMap = new HashMap<String, String>();
        this.populateIfNotNull(eventMap, SESSION_ID, eventDetails.getSessionID());
        this.populateIfNotNull(eventMap, USER_PRINCIPAL, eventDetails.getUserPrincipal());
        this.populateIfNotNull(eventMap, URL, eventDetails.getUrl());
        eventMap.put(OBSERVED_RESPONSE_TIME, String.valueOf(eventDetails.getObservedRT()));
        eventMap.put(WARNING_THRESHOLD, String.valueOf(eventDetails.getWarningThreshold()));
        eventMap.put(CRITICAL_THRESHOLD, eventDetails.getCriticalThreshold());
        Map httpParams = NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventDetails.getHttpParams());
        eventMap.put(HTTP_PARAMS, String.valueOf(httpParams.size()));
        if (!httpParams.isEmpty()) {
            this.populateMap(eventMap, httpParams, HTTP_PARAM_NAME, HTTP_PARAM_VALUE);
        }
        Map cookies = NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventDetails.getCookies());
        eventMap.put(COOKIES, String.valueOf(cookies.size()));
        if (!cookies.isEmpty()) {
            this.populateMap(eventMap, cookies, COOKIE_NAME, COOKIE_VALUE);
        }
        Map userData = NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventDetails.getUserData());
        eventMap.put(POJO_DATA_SET, String.valueOf(userData.size()));
        if (!userData.isEmpty()) {
            this.populateMap(eventMap, userData, POJO_USER_DATA_NAME, POJO_USER_DATA_VALUE);
        }
        Map errorDetails = NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventDetails.getErrorDetails());
        eventMap.put(ERRORS, String.valueOf(errorDetails.size()));
        if (!errorDetails.isEmpty()) {
            this.populateMap(eventMap, errorDetails, ERROR_NAME, ERROR_VALUE);
        }
        List queries = CollectionHelper.asList((Object[])eventDetails.getSqlStatementDetails());
        eventMap.put(SQL_QUERIES, String.valueOf(queries.size()));
        if (!queries.isEmpty()) {
            int index = 0;
            for (SQLStatementDetails sqlDetails : queries) {
                eventMap.put("sql-query-type." + index, EnumHelper.getName((Enum)sqlDetails.getStatementType(), (Enum)sqlDetails.getStatementType()));
                eventMap.put("sql-query-value." + index, sqlDetails.getSqlStatement());
                eventMap.put("sql-query-time." + index, String.valueOf(sqlDetails.getExecutionTime()));
                ++index;
            }
        }
        return eventMap;
    }

    private void populateMap(Map<String, String> eventMap, Map<String, String> map, String name, String val) {
        int index = 0;
        for (String key : map.keySet()) {
            eventMap.put(name + "." + index, key);
            eventMap.put(val + "." + index, map.get(key));
            ++index;
        }
    }
}

