/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.controller.api.constants.ConditionOperator;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.FunctionType;
import com.singularity.ee.controller.api.dto.AggregationScopeTriggeredConditions;
import com.singularity.ee.controller.api.dto.AlertEventDetails;
import com.singularity.ee.controller.api.dto.ConditionValueFunction;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.TriggeredCondition;
import com.singularity.ee.events.translate.IEventDataDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import com.singularity.ee.util.enums.EnumHelper;
import java.util.HashMap;
import java.util.Map;

public class AlertEventEncoderDecoder
implements IEventDataEncoder,
IEventDataDecoder {
    public static final String EVENT_KEY_RULE_NAME = "Rule Name";
    public static final String EVENT_KEY_TIME_INTERVAL_MINS = "Time Interval In Minutes";
    public static final String EVENT_KEY_NUM_CONDITIONS = "Num Conditions";
    public static final String EVENT_KEY_OBSERVED_VALUE = "Observed Value";
    public static final String EVENT_KEY_THRESHOLD_VALUE = "Threshold Value";
    public static final String EVENT_KEY_VALUE_FUNCTION = "Value Function";
    public static final String EVENT_KEY_OPERATOR = "Operator";
    public static final String EVENT_KEY_CONDITION_NAME = "Metric Condition Name";
    public static final String EVENT_KEY_CONDITION_ID = "Condition ID";
    public static final String EVENT_KEY_SCOPE_TYPE = "Scope Type";
    public static final String EVENT_KEY_SCOPE_NAME = "Scope Name";
    public static final String EVENT_KEY_SCOPE_ID = "Scope ID";

    @Override
    public EventDetails decodeEventData(NameValuePair[] eventData) {
        AlertEventDetails alertEventDetails = new AlertEventDetails(eventData);
        return this.decodeEventDataInternal(NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventData), alertEventDetails);
    }

    @Override
    public EventDetails decodeEventData(Map<String, String> eventDetailsMap) {
        AlertEventDetails alertEventDetails = new AlertEventDetails(NameValuePair.convertMap(eventDetailsMap));
        return this.decodeEventDataInternal(eventDetailsMap, alertEventDetails);
    }

    private EventDetails decodeEventDataInternal(Map<String, String> eventDetailsMap, AlertEventDetails alertEventDetails) {
        alertEventDetails.setRuleName(eventDetailsMap.get(EVENT_KEY_RULE_NAME));
        alertEventDetails.setTimeIntervalMinutes(Integer.parseInt(eventDetailsMap.get(EVENT_KEY_TIME_INTERVAL_MINS)));
        AggregationScopeTriggeredConditions astc = new AggregationScopeTriggeredConditions();
        EntityDefinition ed = new EntityDefinition((EntityType)EnumHelper.getEnum(EntityType.class, (String)eventDetailsMap.get(EVENT_KEY_SCOPE_TYPE)), Long.parseLong(eventDetailsMap.get(EVENT_KEY_SCOPE_ID)));
        astc.setEntityDefinition(ed);
        if (eventDetailsMap.get(EVENT_KEY_NUM_CONDITIONS) != null) {
            int numTriggeredConditions = Integer.parseInt(eventDetailsMap.get(EVENT_KEY_NUM_CONDITIONS));
            TriggeredCondition[] conditions = new TriggeredCondition[numTriggeredConditions];
            for (int i = 0; i < conditions.length; ++i) {
                String keyPrefix = i + 1 + ":";
                TriggeredCondition cond = new TriggeredCondition();
                cond.setConditionName(eventDetailsMap.get(keyPrefix + EVENT_KEY_CONDITION_NAME));
                cond.setConditionId(Long.parseLong(eventDetailsMap.get(keyPrefix + EVENT_KEY_CONDITION_ID)));
                cond.setOperator((ConditionOperator)EnumHelper.getEnum(ConditionOperator.class, (String)eventDetailsMap.get(keyPrefix + EVENT_KEY_OPERATOR)));
                ConditionValueFunction valueFunction = new ConditionValueFunction();
                valueFunction.setType((FunctionType)EnumHelper.getEnum(FunctionType.class, (String)eventDetailsMap.get(keyPrefix + EVENT_KEY_VALUE_FUNCTION)));
                cond.setValueFunction(valueFunction);
                cond.setThresholdValue((double)Long.parseLong(eventDetailsMap.get(keyPrefix + EVENT_KEY_THRESHOLD_VALUE)));
                cond.setObservedValue((double)Long.parseLong(eventDetailsMap.get(keyPrefix + EVENT_KEY_OBSERVED_VALUE)));
                conditions[i] = cond;
            }
            astc.setConditions(conditions);
        }
        alertEventDetails.setConditions(astc);
        return alertEventDetails;
    }

    @Override
    public Map<String, String> encodeEventData(EventDetails eventDetails) {
        AlertEventDetails alertEventDetails = (AlertEventDetails)eventDetails;
        HashMap<String, String> eventDetailsMap = new HashMap<String, String>();
        AggregationScopeTriggeredConditions astc = alertEventDetails.getConditions();
        TriggeredCondition[] triggeredConditions = astc.getConditions();
        eventDetailsMap.put(EVENT_KEY_RULE_NAME, alertEventDetails.getRuleName());
        eventDetailsMap.put(EVENT_KEY_TIME_INTERVAL_MINS, String.valueOf(alertEventDetails.getTimeIntervalMinutes()));
        EntityDefinition entityDefinition = astc.getEntityDefinition();
        eventDetailsMap.put(EVENT_KEY_SCOPE_TYPE, EnumHelper.getName((Enum)entityDefinition.getEntityType(), (Enum)entityDefinition.getEntityType()));
        eventDetailsMap.put(EVENT_KEY_SCOPE_ID, String.valueOf(entityDefinition.getEntityId()));
        int counter = 1;
        if (triggeredConditions != null && triggeredConditions.length != 0) {
            for (TriggeredCondition cond : triggeredConditions) {
                String keyPrefix = counter + ":";
                eventDetailsMap.put(keyPrefix + EVENT_KEY_CONDITION_NAME, cond.getConditionName());
                eventDetailsMap.put(keyPrefix + EVENT_KEY_CONDITION_ID, String.valueOf(cond.getConditionId()));
                eventDetailsMap.put(keyPrefix + EVENT_KEY_OPERATOR, EnumHelper.getName((Enum)cond.getOperator(), (Enum)cond.getOperator()));
                eventDetailsMap.put(keyPrefix + EVENT_KEY_VALUE_FUNCTION, EnumHelper.getName((Enum)cond.getValueFunction().getType(), (Enum)cond.getValueFunction().getType()));
                eventDetailsMap.put(keyPrefix + EVENT_KEY_THRESHOLD_VALUE, String.valueOf(cond.getThresholdValue()));
                eventDetailsMap.put(keyPrefix + EVENT_KEY_OBSERVED_VALUE, String.valueOf(cond.getObservedValue()));
                ++counter;
            }
            eventDetailsMap.put(EVENT_KEY_NUM_CONDITIONS, String.valueOf(triggeredConditions.length));
        }
        return eventDetailsMap;
    }
}

