/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events.translate;

import com.singularity.ee.controller.api.dto.ActivityTraceEventDetails;
import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.events.translate.IEventDataDecoder;
import com.singularity.ee.events.translate.IEventDataEncoder;
import java.util.HashMap;
import java.util.Map;

public class ActivityTraceEventEncoderDecoder
implements IEventDataEncoder,
IEventDataDecoder {
    public static final String TARGET_ENTITY_ID = "target-entity-id";
    public static final String NUM_OF_CODE_PATHS_KEY = "num-code-paths";
    public static final String CODE_PATH_KEY = "code-path";
    public static final String CODE_PATH_OCCURENCE_KEY = "code-path-occurrence";
    public static final String NUM_OF_BUSINESS_TRANSACTIONS_KEY = "num-business-transactions";
    public static final String BT_KEY = "business-transaction";
    public static final String BT_OCCURENCE_KEY = "business-transactions-occurence";

    @Override
    public EventDetails decodeEventData(NameValuePair[] eventData) {
        ActivityTraceEventDetails eventDetails = new ActivityTraceEventDetails(eventData);
        return this.decodeEventDataInternal(NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventData), eventDetails);
    }

    @Override
    public EventDetails decodeEventData(Map<String, String> eventData) {
        ActivityTraceEventDetails eventDetails = new ActivityTraceEventDetails(NameValuePair.convertMap(eventData));
        return this.decodeEventDataInternal(eventData, eventDetails);
    }

    private EventDetails decodeEventDataInternal(Map<String, String> eventMap, ActivityTraceEventDetails eventDetails) {
        int noOfBTs;
        int noOfCodePaths = Integer.parseInt(eventMap.get(NUM_OF_CODE_PATHS_KEY));
        if (noOfCodePaths > 0) {
            Map<String, String> codePathsMap = this.extractFromMap(eventMap, noOfCodePaths, CODE_PATH_KEY, CODE_PATH_OCCURENCE_KEY);
            eventDetails.setCodePaths(NameValuePair.convertMap(codePathsMap));
        }
        if ((noOfBTs = Integer.parseInt(eventMap.get(NUM_OF_BUSINESS_TRANSACTIONS_KEY))) > 0) {
            Map<String, String> btsMap = this.extractFromMap(eventMap, noOfBTs, BT_KEY, BT_OCCURENCE_KEY);
            eventDetails.setBusinessTransactions(NameValuePair.convertMap(btsMap));
        }
        return eventDetails;
    }

    @Override
    public Map<String, String> encodeEventData(EventDetails eventDetails) {
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        ActivityTraceEventDetails event = (ActivityTraceEventDetails)eventDetails;
        NameValuePair[] codePaths = event.getCodePaths();
        Map codePathsMap = NameValuePair.convertNameValuePairsToMap((NameValuePair[])codePaths);
        eventDataMap.put(NUM_OF_CODE_PATHS_KEY, String.valueOf(codePathsMap.size()));
        this.populateMap(eventDataMap, codePathsMap, CODE_PATH_KEY, CODE_PATH_OCCURENCE_KEY);
        NameValuePair[] bts = event.getBusinessTransactions();
        Map btsMap = NameValuePair.convertNameValuePairsToMap((NameValuePair[])bts);
        eventDataMap.put(NUM_OF_BUSINESS_TRANSACTIONS_KEY, String.valueOf(btsMap.size()));
        this.populateMap(eventDataMap, btsMap, BT_KEY, BT_OCCURENCE_KEY);
        return eventDataMap;
    }

    private void populateMap(Map<String, String> eventMap, Map<String, String> map, String name, String val) {
        int index = 0;
        for (String key : map.keySet()) {
            eventMap.put(name + "." + index, key);
            eventMap.put(val + "." + index, map.get(key));
            ++index;
        }
    }

    private Map<String, String> extractFromMap(Map<String, String> eventMap, int size, String key, String val) {
        HashMap<String, String> vals = new HashMap<String, String>(size);
        for (int inx = 0; inx < size; ++inx) {
            String name = eventMap.get(key + "." + inx);
            String value = eventMap.get(val + "." + inx);
            vals.put(name, value);
        }
        return vals;
    }
}

