/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events;

import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.events.EventMessage;
import com.singularity.ee.events.EventMessageBundle;
import java.util.Map;

@GenProto
public class MachineEventData
extends AgentEventData
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private long machineID;

    public MachineEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, String summary, long machineID) {
        super(timestamp, notificationSeverity, type, eventDetails, summary);
        this.machineID = machineID;
    }

    public MachineEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, EventMessage message, long machineID) {
        this(timestamp, notificationSeverity, type, eventDetails, EventMessageBundle.getBundle().getMessage(message), machineID);
    }

    public MachineEventData() {
    }

    public long getMachineID() {
        return this.machineID;
    }

    public void setMachineID(long machineID) {
        this.machineID = machineID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineEventData that = (MachineEventData)((Object)o);
        if (this.getSubType() != null && !this.getSubType().equals(that.getSubType())) {
            return false;
        }
        return this.machineID == that.machineID;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + super.hashCode();
        result = 37 * result + (int)(this.machineID ^ this.machineID >>> 32);
        if (this.getSubType() != null) {
            result = 37 * result + this.getSubType().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getSubType() != null) {
            sb.append("Event Data for Sub-Type").append(this.getSubType()).append("]\n");
        }
        sb.append("Event Data for Machine ID[").append(this.machineID).append("]\n");
        return sb.toString() + super.toString();
    }
}

