/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.events;

import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.SingularitySerializable;
import com.singularity.ee.controller.api.dto.annotations.FieldPosition;
import com.singularity.ee.controller.api.dto.annotations.GenProto;
import com.singularity.ee.controller.api.dto.annotations.IgnoreProtoGen;
import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.EqualsUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@GenProto
public class BTEventData
extends AgentEventData
implements SingularitySerializable {
    @IgnoreProtoGen
    private static final long serialVersionUID = 1L;
    @FieldPosition(value=2)
    private Set<Long> btIDs = new HashSet<Long>(1, 1.0f);

    public BTEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, String summary, long btID) {
        super(timestamp, notificationSeverity, type, eventDetails, summary);
        this.addBtID(btID);
    }

    public BTEventData(long timestamp, NotificationSeverity notificationSeverity, EventType type, Map<String, String> eventDetails, String summary) {
        super(timestamp, notificationSeverity, type, eventDetails, summary);
    }

    public BTEventData() {
    }

    public void addBtID(long btID) {
        this.btIDs.add(btID);
    }

    public Set<Long> getBtIDs() {
        return this.btIDs;
    }

    public void setBtIDs(Set<Long> value) {
        this.btIDs = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BTEventData that = (BTEventData)((Object)o);
        return EqualsUtil.safeCompareCollections(this.btIDs, that.btIDs);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + super.hashCode();
        result = 37 * result + CollectionHelper.getJavaAlgorithmCollectionHashCode(this.btIDs);
        return result;
    }

    public String toString() {
        return "Event Data for BT ID[" + CollectionHelper.collectionToString(this.btIDs) + "] " + super.toString();
    }
}

