/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller;

import com.singularity.ee.util.system.SystemUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class KAppServerConstants {
    private static final String APPDYNAMICS_CONTROLLER_CACTUS_TESTING_ENABLED = "appdynamics.controller.cactus.testing.enabled";
    private static final String APPDYNAMICS_CONTROLLER_DB_PASSWORD = "appdynamics.controller.db.password";
    private static final String APPDYNAMICS_CONTROLLER_DB_USER = "appdynamics.controller.db.user";
    private static final String APPDYNAMICS_CONTROLLER_DB_URL = "appdynamics.controller.db.url";
    public static final String INSTRUMENTED_APP = "AppDynamics Controller";
    public static final String INSTRUMENTED_APP_COMPONENT = "App Server";
    public static final String INSTRUMENTED_APP_COMPONENT_NODE = "Node1";
    public static final String DEFAULT_PROCESS_MONITOR_NAME = "ProcessMonitor";
    public static final String DEFAULT_SYSTEM_RESOURCE_MONITOR_NAME = "SystemResourceMonitor";
    public static final String CONTROLLER_REALM = "controller_realm";
    public static final String SYSTEM_USER_AND_ACCOUNT_NAME = "system@system";
    public static final String AGENT_USER_NAME = "singularity-agent";
    public static final String DBMON_DEDICATED_USERNAME = "dbmonservice";
    public static final String SUPPORT_USER_NAME = "support-user";
    public static final String SUPPORT_USER_DISPLAY_NAME = "Support User";
    public static final String SUPPORT_ROLE_NAME = "Support User";
    public static final int MAX_LENGTH_INTERNAL_USER_NAME = 240;
    public static final String SYSTEM_ROOT_USER_NAME = "root";
    public static final String SYSTEM_ACCOUNT_NAME = "system";
    public static final String SYSTEM_ACCOUNT_ID = "1";
    public static final String SYSTEM_USER_NAME = "system";
    public static final String MYSQL_WILDCHARD_CHAR = "%";
    public static final String CONTROLLER_WEB_CONTEXT = "controller";
    public static final String DEFAULT_SMTP_RELAY_PORT = "appdynamics.controller.smtp.relay.port";
    public static final String DEFAULT_CONTROLLER_EMAIL_ADDRESS = "appdynamics.controller.email";
    public static final String DEFAULT_USER_NAME = "user1";
    public static final String DEFAULT_ACCOUNT_NAME = "customer1";
    public static final String DEFAULT_AGENT_PASSWORD = "SJ5b2m7d1$354";
    public static final int DEFAULT_AGENT_PORT = 8293;
    public static final String LINUX_USER_DATA_FILE = ".appdynamics";
    public static final String WINDOWS_USER_DATA_FILE = "appdynamics.txt";
    public static final String LINUX_FULL_PATH_TO_USER_DATA_FILE = "/.appdynamics";
    public static final String WINDOWS_FULL_PATH_TO_USER_DATA_FILE = "C:\\appdynamics.txt";
    public static final String CONTROLLER_HOME_PROPERTY_KEY = "appdynamics.controller.home";
    public static final String CONTROLLER_PROXY_HOST = "appdynamics.controller.http.proxyHost";
    public static final String CONTROLLER_PROXY_PORT = "appdynamics.controller.http.proxyPort";
    public static final String CONTROLLER_PROXY_USER = "appdynamics.controller.http.proxyUser";
    public static final String CONTROLLER_PROXY_PASSWORD_FILE = "appdynamics.controller.http.proxyPasswordFile";
    public static final String ENTITY_CONTEXT_LOGGER_XML_CONFIGURATION_FILE = "com.appdynamics.entity.context.logger.xml.config.path";
    public static final String ENTITY_CONTEXT_LOGGER_DEFAULT_XML_CONFIGURATION_FILE_NAME = "entity-context-logger-config.xml";
    public static final String ENCRYPTION_SCHEME_SCS = "scs";
    public static final String XML_BUILDER_REUSE = "appdynamics.controller.xml.builder.reuse";
    public static final String ANALYTICS_SCHEDULED_QUERIES_BATCH_SIZE = "analytics.scheduledqueries.batch.size";
    public static final String CONTROLLER_APP_SERVER_DIR_PROPERTY = "appdynamics.controller.appserver";
    public static final String CONTROLLER_HOST_NAME_PROPERTY_KEY = "appdynamics.controller.hostName";
    public static final String CONTROLLER_PORT_PROPERTY_KEY = "appdynamics.controller.port";
    public static final String CONTROLLER_SERVICES_HOST_NAME_PROPERTY_KEY = "appdynamics.controller.services.hostName";
    public static final String CONTROLLER_SERVICES_PORT_PROPERTY_KEY = "appdynamics.controller.services.port";
    public static final String CONTROLLER_UI_DEEPLINK_URL = "appdynamics.controller.ui.deeplink.url";
    public static final int DEFAULT_CONTROLLER_PORT_VALUE = 8080;
    public static final String CONTROLLER_HOST_SSL_ENABLED_PROPERTY_KEY = "appdynamics.controller.ssl.enabled";
    public static final String CONTROLLER_MAX_CRASH_LOGS_SIZE_PROPERTY_KEY = "appdynamics.controller.max.crash.logs.size";
    public static final String CONTROLLER_DISABLE_WINDOWS_WATCHDOG_PROPERTY_KEY = "appdynamics.controller.disableWinMySQLWatchdog";
    public static final String CONTROLLER_DATABASE_WINDOWS_SERVICE_NAME_PROPERTY_KEY = "appdynamics.controller.database.windowsServiceName";
    public static final String DEFAULT_CONTROLLER_DATABASE_WINDOWS_SERVICE_NAME = "AppDynamics Database";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String COLON = ":";
    public static final String CONTROLLER_EVENT_FLUSH_PERIOD_SECONDS_KEY = "appdynamics.controller.event.flush.period.seconds";
    public static final String CONTROLLER_EVENT_FLUSH_PERIOD_DEFAULT_VALUE = "15";
    public static final int CONTROLLER_EVENT_FLUSH_PERIOD_MAX_VALUE = 30;
    public static final int CONTROLLER_EVENT_FLUSH_PERIOD_MIN_VALUE = 3;
    public static final String DB_AGENT_DOWN_AFTER_SECONDS_KEY = "appdynamics.controller.dbagent.down.after.seconds";
    private static final String DB_AGENT_DOWN_AFTER_SECONDS_DEFAULT_VALUE = "45";
    public static final String DB_AGENT_RECORD_EXPIRY_MINUTES_KEY = "appdynamics.controller.dbagent.config.request.record.expiry.minutes";
    public static final String DB_AGENT_DELETE_EXPIRED_RECORD_MINUTES_KEY = "appdynamics.controller.dbagent.delete.expired.record.minutes";
    public static final String DB_AGENT_RECORD_EXPIRY_MINUTES_DEFAULT_VALUE = "120";
    public static final String DB_AGENT_DELETE_EXPIRED_RECORD_MINUTES_DEFAULT_VALUE = String.valueOf(TimeUnit.DAYS.toMinutes(5L));

    public static File getControllerHomeDir() {
        return new File(SystemUtils.getProperty((String)CONTROLLER_HOME_PROPERTY_KEY), ".");
    }

    public static int getControllerEventFlushPeriodSeconds() {
        int period = Integer.parseInt(SystemUtils.getProperty((String)CONTROLLER_EVENT_FLUSH_PERIOD_SECONDS_KEY, (String)CONTROLLER_EVENT_FLUSH_PERIOD_DEFAULT_VALUE));
        if (3 > period || 30 < period) {
            period = Integer.parseInt(CONTROLLER_EVENT_FLUSH_PERIOD_DEFAULT_VALUE);
        }
        return period;
    }

    public static int getDBAgentDownAfterSeconds() {
        int minutes = Integer.parseInt(SystemUtils.getProperty((String)DB_AGENT_DOWN_AFTER_SECONDS_KEY, (String)DB_AGENT_DOWN_AFTER_SECONDS_DEFAULT_VALUE));
        return minutes;
    }

    public static int getDBAgentRecordExpiryMinutes() {
        int minutes = Integer.parseInt(SystemUtils.getProperty((String)DB_AGENT_RECORD_EXPIRY_MINUTES_KEY, (String)DB_AGENT_RECORD_EXPIRY_MINUTES_DEFAULT_VALUE));
        return minutes;
    }

    public static int getDBAgentDeleteExpiredRecordMinutes() {
        int minutes = Integer.parseInt(SystemUtils.getProperty((String)DB_AGENT_DELETE_EXPIRED_RECORD_MINUTES_KEY, (String)DB_AGENT_DELETE_EXPIRED_RECORD_MINUTES_DEFAULT_VALUE));
        return minutes;
    }

    public static File getAppAgentOperationLogsDir() {
        return new File(KAppServerConstants.getControllerHomeDir(), "app_agent_operation_logs");
    }

    public static File getDBAgentOperationLogsDir() {
        return new File(KAppServerConstants.getControllerHomeDir(), "db_agent_operation_logs");
    }

    public static File getMachineAgentOperationLogsDir() {
        return new File(KAppServerConstants.getControllerHomeDir(), "machine_agent_operation_logs");
    }

    public static File getAgentBinariesDir() {
        return new File(KAppServerConstants.getControllerHomeDir(), "agent_binaries");
    }

    public static File getAppAgentCrashLogsDir() {
        return new File(KAppServerConstants.getControllerHomeDir(), "app_agent_crash_logs");
    }

    public static String getControllerHost() {
        try {
            return SystemUtils.getProperty((String)CONTROLLER_SERVICES_HOST_NAME_PROPERTY_KEY, (String)SystemUtils.getLocalHostName());
        }
        catch (Exception e) {
            throw new RuntimeException("Bad controller host value", e);
        }
    }

    public static String getControllerDbUrl(String defaultDbUrl) {
        return SystemUtils.getProperty((String)APPDYNAMICS_CONTROLLER_DB_URL, (String)defaultDbUrl);
    }

    public static String getControllerDbUser() {
        return SystemUtils.getProperty((String)APPDYNAMICS_CONTROLLER_DB_USER, (String)CONTROLLER_WEB_CONTEXT);
    }

    public static boolean isCactusTestingEnabled() {
        return Boolean.parseBoolean(SystemUtils.getProperty((String)APPDYNAMICS_CONTROLLER_CACTUS_TESTING_ENABLED, (String)"false"));
    }

    public static String getConnectorsRootDir() {
        StringBuilder sb = new StringBuilder();
        sb.append(KAppServerConstants.getControllerHomeDir()).append(File.separator);
        sb.append("lib").append(File.separator).append("connectors");
        return sb.toString();
    }

    public static String getProxyHost() {
        return SystemUtils.getProperty((String)CONTROLLER_PROXY_HOST);
    }

    public static Integer getProxyPort() {
        String proxyPortStr = SystemUtils.getProperty((String)CONTROLLER_PROXY_PORT);
        if (proxyPortStr == null) {
            return null;
        }
        return Integer.parseInt(proxyPortStr);
    }

    public static String getProxyUser() {
        return SystemUtils.getProperty((String)CONTROLLER_PROXY_USER);
    }

    public static String getProxyPasswordFile() {
        return SystemUtils.getProperty((String)CONTROLLER_PROXY_PASSWORD_FILE);
    }

    public static Boolean isTssAggregatorEnabled() {
        return Boolean.parseBoolean(SystemUtils.getProperty((String)"appdynamics.controller.tss.aggregator", (String)"true"));
    }

    public static boolean isTssRollupTypeV0() {
        return Boolean.parseBoolean(SystemUtils.getProperty((String)"appdynamics.controller.tss.rollup.v0", (String)"false"));
    }

    public static void setTssRollupTypeV0(boolean flag) {
        SystemUtils.setProperty((String)"appdynamics.controller.tss.rollup.v0", (String)Boolean.valueOf(flag).toString());
    }

    public static File getControllerAppServerDir() {
        return new File(SystemUtils.getProperty((String)CONTROLLER_APP_SERVER_DIR_PROPERTY, (String)"./"));
    }

    public static String getScsKeyStoreFileName() {
        String scsKeystoreFileName = new File(KAppServerConstants.getControllerHomeDir(), ".appd.scskeystore").getAbsolutePath();
        return scsKeystoreFileName;
    }

    public static File getControllerAppServerConfigDir() {
        return new File(KAppServerConstants.getControllerAppServerDir(), "/config/");
    }

    public static File getEntityContextLoggerXmlConfigurationFile() {
        File configFile = new File(SystemUtils.getProperty((String)ENTITY_CONTEXT_LOGGER_XML_CONFIGURATION_FILE, (String)KAppServerConstants.getDefaultFileLocationAbsolutePath()));
        return configFile;
    }

    private static String getDefaultFileLocationAbsolutePath() {
        File file = new File(KAppServerConstants.getControllerAppServerConfigDir().getAbsolutePath(), ENTITY_CONTEXT_LOGGER_DEFAULT_XML_CONFIGURATION_FILE_NAME);
        return file.getAbsolutePath();
    }
}

