/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller;

import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.transactionmonitor.GenericExitPointTypes;
import com.singularity.ee.controller.api.dto.transactionmonitor.TransactionExitPointType;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BackendDiscoveryConfig;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.BackendIdentityOption;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.javaspecific.frameworks.GenericExitPointTypeUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DefaultBackendDiscoveryConfigs {
    public static final NameValuePair[] USE_COMPLETE_STRING = new NameValuePair[]{new NameValuePair("use-entire-string", "true")};
    public static final BackendIdentityOption[] JAVA_MQ_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Destination", USE_COMPLETE_STRING, null), new BackendIdentityOption("DestinationType", USE_COMPLETE_STRING, null), new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Major Version", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_JMS_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Destination", USE_COMPLETE_STRING, null), new BackendIdentityOption("DestinationType", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_KAFKA_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null), new BackendIdentityOption("Topic Name", USE_COMPLETE_STRING, null), new BackendIdentityOption("Broker URL", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] JAVA_AXON_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null), new BackendIdentityOption("Bus Cluster Name", USE_COMPLETE_STRING, null), new BackendIdentityOption("Bus Connector Type", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_AMAZON_SQS_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Destination", USE_COMPLETE_STRING, null), new BackendIdentityOption("DestinationType", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_AMAZON_S3_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Bucket Name", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null), new BackendIdentityOption("Object Key", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] JAVA_AMAZON_SNS_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null), new BackendIdentityOption("Topic ARN", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_AMAZON_DYNAMO_BACKEND_ID_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null), new BackendIdentityOption("Service", USE_COMPLETE_STRING, null), new BackendIdentityOption("Endpoint", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_MONGODB_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Database", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] DOTNET_MONGODB_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Database", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] DOTNET_SERVICE_FABRIC_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("URL", USE_COMPLETE_STRING, null), new BackendIdentityOption("OperationContract", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("ServiceContract", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] DOTNET_JMS_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Destination", USE_COMPLETE_STRING, null), new BackendIdentityOption("DestinationType", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] JAVA_WEBSERVICE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Service", USE_COMPLETE_STRING, null), new BackendIdentityOption("URL", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Operation", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Soap Action", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] DOTNET_WEBSERVICE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Service", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("URL", USE_COMPLETE_STRING, null), new BackendIdentityOption("Operation", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Soap Action", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] NODEJS_WEBSERVICE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Service", USE_COMPLETE_STRING, null), new BackendIdentityOption("URL", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Operation", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Soap Action", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_RMI_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("URL", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_HTTP_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("URL", new NameValuePair[]{new NameValuePair("use-segments", Boolean.TRUE.toString()), new NameValuePair("split-delimiter", "/"), new NameValuePair("merge-delimiter", "/")}, new NameValuePair[]{new NameValuePair("segment-type", "first-n"), new NameValuePair("segment-count", "2")}, false), new BackendIdentityOption("Query String", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] MODULE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Mod Name", USE_COMPLETE_STRING, null), new BackendIdentityOption("Version", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] DOTNET_HTTP_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("URL", new NameValuePair[]{new NameValuePair("use-segments", Boolean.TRUE.toString()), new NameValuePair("split-delimiter", "/"), new NameValuePair("merge-delimiter", "/")}, new NameValuePair[]{new NameValuePair("segment-type", "first-n"), new NameValuePair("segment-count", "2")}, false), new BackendIdentityOption("Query String", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] JAVA_JDBC_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("URL", USE_COMPLETE_STRING, null), new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Database", USE_COMPLETE_STRING, null), new BackendIdentityOption("Version", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_THRIFT_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("transport", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_CASSANDRA_CQL_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Cluster Name", USE_COMPLETE_STRING, null), new BackendIdentityOption("keyspace", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Data Center", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Rack", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] JAVA_JOLT_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Service", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_VERTX_MESSAGE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Address Type", USE_COMPLETE_STRING, null), new BackendIdentityOption("Address", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_VERTX_ASYNC_MESSAGE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Address Type", USE_COMPLETE_STRING, null), new BackendIdentityOption("Address", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] DOTNET_ADO_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Database", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("ConnectionString", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] WCF_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Remote Address", USE_COMPLETE_STRING, null), new BackendIdentityOption("OperationContract", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("ServiceContract", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("URL", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Host", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Soap Action", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] DOTNET_REMOTING_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("URL", USE_COMPLETE_STRING, null)};
    private static final BackendIdentityOption[] DEFAULT_HTTP_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("URL", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Query String", USE_COMPLETE_STRING, null, false)};
    private static final BackendIdentityOption[] DEFAULT_DB_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("URL", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Database", USE_COMPLETE_STRING, null), new BackendIdentityOption("Version", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    private static final BackendIdentityOption[] DEFAULT_DB_BACKEND_IDENTITY_OPTIONS_NO_URL = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Database", USE_COMPLETE_STRING, null), new BackendIdentityOption("Version", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    private static final BackendIdentityOption[] DEFAULT_CACHE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Server Pool", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null)};
    private static final BackendIdentityOption[] DEFAULT_RABBITMQ_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Routing Key", USE_COMPLETE_STRING, null, false), new BackendIdentityOption("Exchange", USE_COMPLETE_STRING, null, false)};
    public static final BackendIdentityOption[] DEFAULT_COUCHBASE_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Server Pool", USE_COMPLETE_STRING, null), new BackendIdentityOption("Vendor", USE_COMPLETE_STRING, null), new BackendIdentityOption("Bucket Name", USE_COMPLETE_STRING, null)};
    private static final BackendIdentityOption[] PHP_HTTP_BACKEND_IDENTITY_OPTIONS = DEFAULT_HTTP_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PHP_DB_BACKEND_IDENTITY_OPTIONS = DEFAULT_DB_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PHP_CACHE_BACKEND_IDENTITY_OPTIONS = DEFAULT_CACHE_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PHP_WEBSERVICE_BACKEND_IDENTITY_OPTIONS = JAVA_WEBSERVICE_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PHP_RABBITMQ_BACKEND_IDENTITY_OPTIONS = DEFAULT_RABBITMQ_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] NODEJS_HTTP_BACKEND_IDENTITY_OPTIONS = DEFAULT_HTTP_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] NODEJS_DB_BACKEND_IDENTITY_OPTIONS = DEFAULT_DB_BACKEND_IDENTITY_OPTIONS_NO_URL;
    private static final BackendIdentityOption[] NODEJS_MONGO_BACKEND_IDENTITY_OPTIONS = JAVA_MONGODB_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] NODEJS_CACHE_BACKEND_IDENTITY_OPTIONS = DEFAULT_CACHE_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PYTHON_HTTP_BACKEND_IDENTITY_OPTIONS = DEFAULT_HTTP_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PYTHON_DB_BACKEND_IDENTITY_OPTIONS = DEFAULT_DB_BACKEND_IDENTITY_OPTIONS_NO_URL;
    private static final BackendIdentityOption[] PYTHON_CACHE_BACKEND_IDENTITY_OPTIONS = DEFAULT_CACHE_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] PYTHON_MONGO_BACKEND_IDENTITY_OPTIONS = JAVA_MONGODB_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] RUBY_HTTP_BACKEND_IDENTITY_OPTIONS = DEFAULT_HTTP_BACKEND_IDENTITY_OPTIONS;
    private static final BackendIdentityOption[] RUBY_DB_BACKEND_IDENTITY_OPTIONS = DEFAULT_DB_BACKEND_IDENTITY_OPTIONS_NO_URL;
    private static final BackendIdentityOption[] RUBY_CACHE_BACKEND_IDENTITY_OPTIONS = DEFAULT_CACHE_BACKEND_IDENTITY_OPTIONS;
    public static final BackendIdentityOption[] JAVA_RABBITMQ_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Host", USE_COMPLETE_STRING, null), new BackendIdentityOption("Port", USE_COMPLETE_STRING, null), new BackendIdentityOption("Routing Key", USE_COMPLETE_STRING, null), new BackendIdentityOption("Exchange", USE_COMPLETE_STRING, null)};
    public static final BackendIdentityOption[] JAVA_WEBSOCKET_BACKEND_IDENTITY_OPTIONS = new BackendIdentityOption[]{new BackendIdentityOption("Endpoint", USE_COMPLETE_STRING, null)};
    public static final BackendDiscoveryConfig dbConfig = new BackendDiscoveryConfig("Default JDBC configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.JDBC, (Enum)TransactionExitPointType.JDBC), JAVA_JDBC_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig httpConfig = new BackendDiscoveryConfig("Default HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), JAVA_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig defaultHttpConfig = new BackendDiscoveryConfig("Default HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), DEFAULT_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig rmiConfig = new BackendDiscoveryConfig("Default RMI configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.RMI, (Enum)TransactionExitPointType.RMI), JAVA_RMI_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig webServiceConfig = new BackendDiscoveryConfig("Default WebService configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.WEB_SERVICE, (Enum)TransactionExitPointType.WEB_SERVICE), JAVA_WEBSERVICE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig amazonSQSConfig = new BackendDiscoveryConfig("Default Amazon SQS configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Amazon SQS", JAVA_AMAZON_SQS_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig mongoConfig = new BackendDiscoveryConfig("Default MongoDB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Mongo DB", JAVA_MONGODB_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig amazonSNSConfig = new BackendDiscoveryConfig("Default Amazon SNS configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Amazon SNS", JAVA_AMAZON_SNS_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig jmsServiceConfig = new BackendDiscoveryConfig("Default JMS configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.JMS, (Enum)TransactionExitPointType.JMS), JAVA_JMS_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig kafkaServiceConfig = new BackendDiscoveryConfig("Default Kafka configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Kafka", JAVA_KAFKA_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig axonServiceConfig = new BackendDiscoveryConfig("Default Axon configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Axon", JAVA_AXON_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig amazonS3Config = new BackendDiscoveryConfig("Default Amazon S3 configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Amazon S3", JAVA_AMAZON_S3_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig amazonDynamoDBConfig = new BackendDiscoveryConfig("Default AWS configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Amazon Web Services", JAVA_AMAZON_DYNAMO_BACKEND_ID_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig mqServiceConfig = new BackendDiscoveryConfig("Default MQ configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.MQ, (Enum)TransactionExitPointType.MQ), JAVA_MQ_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig couchbaseServiceConfig = new BackendDiscoveryConfig("Default Couchbase configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Couchbase", DEFAULT_COUCHBASE_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig cassandraCQLServiceConfig = new BackendDiscoveryConfig("Default Cassandra CQL configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Cassandra CQL", JAVA_CASSANDRA_CQL_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig joltServiceConfig = new BackendDiscoveryConfig("Default Jolt configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Jolt", JAVA_JOLT_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig vertxMessageServiceConfig = new BackendDiscoveryConfig("Default Vertx Message configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Vertx-Msg", JAVA_VERTX_MESSAGE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig vertxMessageAsyncServiceConfig = new BackendDiscoveryConfig("Default Vertx Message Async configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Vertx-Msg-Async", JAVA_VERTX_ASYNC_MESSAGE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig thriftServiceConfig = new BackendDiscoveryConfig("Default Thrift configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.THRIFT, (Enum)TransactionExitPointType.THRIFT), JAVA_THRIFT_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig dotnethttpConfig = new BackendDiscoveryConfig("Default .NET HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), DOTNET_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig adoDotNetConfig = new BackendDiscoveryConfig("Default ADO.NET configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.ADODOTNET, (Enum)TransactionExitPointType.ADODOTNET), DOTNET_ADO_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig dotNetWebServiceConfig = new BackendDiscoveryConfig("Default .NET WebService configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.WEB_SERVICE, (Enum)TransactionExitPointType.WEB_SERVICE), DOTNET_WEBSERVICE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig dotNetJMSConfig = new BackendDiscoveryConfig("Default .NET JMS configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.JMS, (Enum)TransactionExitPointType.JMS), DOTNET_JMS_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig dotNetWCFServiceConfig = new BackendDiscoveryConfig("Default .NET WCF configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.WCF, (Enum)TransactionExitPointType.WCF), WCF_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig dotNetRemotingConfig = new BackendDiscoveryConfig("Default .NET Remoting configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.DOTNETRemoting, (Enum)TransactionExitPointType.DOTNETRemoting), DOTNET_REMOTING_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig dotNetMongoConfig = new BackendDiscoveryConfig("Default MongoDB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Mongo DB", DOTNET_MONGODB_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig dotNetServiceFabricConfig = new BackendDiscoveryConfig("Default .NET Azure Service Fabric configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Azure Service Fabric", DOTNET_SERVICE_FABRIC_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig phpHttpConfig = new BackendDiscoveryConfig("Default PHP HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), PHP_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig phpDBConfig = new BackendDiscoveryConfig("Default PHP DB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.DB, (Enum)TransactionExitPointType.DB), PHP_DB_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig phpCacheConfig = new BackendDiscoveryConfig("Default PHP Cache configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CACHE, (Enum)TransactionExitPointType.CACHE), PHP_CACHE_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig phpWebServiceConfig = new BackendDiscoveryConfig("Default PHP WebService configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.WEB_SERVICE, (Enum)TransactionExitPointType.WEB_SERVICE), PHP_WEBSERVICE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig phpRabbitMQConfig = new BackendDiscoveryConfig("Default PHP RabbitMQ configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.RABBITMQ, (Enum)TransactionExitPointType.RABBITMQ), PHP_RABBITMQ_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig nodeJSHttpConfig = new BackendDiscoveryConfig("Default NodeJS HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), NODEJS_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig nodeJSDBConfig = new BackendDiscoveryConfig("Default NodeJS DB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.DB, (Enum)TransactionExitPointType.DB), NODEJS_DB_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig nodeJSCacheConfig = new BackendDiscoveryConfig("Default NodeJS Cache configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CACHE, (Enum)TransactionExitPointType.CACHE), NODEJS_CACHE_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig nodejsMongoConfig = new BackendDiscoveryConfig("Default Nodejs MongoDB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Mongo DB", NODEJS_MONGO_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig nodejsWebServiceConfig = new BackendDiscoveryConfig("Default Nodejs WebService configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.WEB_SERVICE, (Enum)TransactionExitPointType.WEB_SERVICE), NODEJS_WEBSERVICE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig pythonHttpConfig = new BackendDiscoveryConfig("Default Python HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), PYTHON_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig pythonDBConfig = new BackendDiscoveryConfig("Default Python DB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.DB, (Enum)TransactionExitPointType.DB), PYTHON_DB_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig pythonCacheConfig = new BackendDiscoveryConfig("Default Python Cache configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CACHE, (Enum)TransactionExitPointType.CACHE), PYTHON_CACHE_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig pythonMongoConfig = new BackendDiscoveryConfig("Default Python MongoDB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "Mongo DB", PYTHON_MONGO_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig rubyHttpConfig = new BackendDiscoveryConfig("Default Ruby HTTP configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.HTTP, (Enum)TransactionExitPointType.HTTP), RUBY_HTTP_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig rubyDBConfig = new BackendDiscoveryConfig("Default Ruby DB configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.DB, (Enum)TransactionExitPointType.DB), RUBY_DB_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig rubyCacheConfig = new BackendDiscoveryConfig("Default Ruby Cache configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CACHE, (Enum)TransactionExitPointType.CACHE), RUBY_CACHE_BACKEND_IDENTITY_OPTIONS, true, false, false);
    public static final BackendDiscoveryConfig defaultDBConfig = new BackendDiscoveryConfig("Default Database configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.DB, (Enum)TransactionExitPointType.DB), DEFAULT_DB_BACKEND_IDENTITY_OPTIONS_NO_URL, true, false, false);
    public static final BackendDiscoveryConfig rabbitMQConfig = new BackendDiscoveryConfig("Default RabbitMQ configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.RABBITMQ, (Enum)TransactionExitPointType.RABBITMQ), JAVA_RABBITMQ_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig moduleConfig = new BackendDiscoveryConfig("Default Module configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.CUSTOM, (Enum)TransactionExitPointType.CUSTOM), "MODULE", MODULE_BACKEND_IDENTITY_OPTIONS, true, true, true);
    public static final BackendDiscoveryConfig webSocketConfig = new BackendDiscoveryConfig("Default WebSocket configuration", EnumHelper.getNameForEnumConstant((Enum)TransactionExitPointType.WEBSOCKET, (Enum)TransactionExitPointType.WEBSOCKET), JAVA_WEBSOCKET_BACKEND_IDENTITY_OPTIONS, true, false, false);
    private static final Map<String, String> exitTypeQualifierVsSupportedAgentVersion = DefaultBackendDiscoveryConfigs.createAgentCompatibilityVersionMap();

    public static String getSupportedAgentVersion(String exitTypeQualifier) {
        return exitTypeQualifierVsSupportedAgentVersion.get(exitTypeQualifier);
    }

    private static Map<String, String> createAgentCompatibilityVersionMap() {
        HashMap<String, String> agentCompatibilityVersionMap = new HashMap<String, String>();
        TransactionExitPointType type = TransactionExitPointType.RABBITMQ;
        String exitQualifier = EnumHelper.getName((Enum)type, (Enum)type);
        agentCompatibilityVersionMap.put(exitQualifier, "3.7.8.0");
        type = TransactionExitPointType.WEBSOCKET;
        exitQualifier = EnumHelper.getName((Enum)type, (Enum)type);
        agentCompatibilityVersionMap.put(exitQualifier, "3.9.0.0");
        String exitQualifier2 = "Amazon SQS";
        agentCompatibilityVersionMap.put(exitQualifier2, "4.1.0.0");
        exitQualifier2 = "MODULE";
        agentCompatibilityVersionMap.put(exitQualifier2, "4.1.0.0");
        exitQualifier2 = "Amazon S3";
        agentCompatibilityVersionMap.put(exitQualifier2, "4.2.0.0");
        exitQualifier2 = "Amazon SNS";
        agentCompatibilityVersionMap.put(exitQualifier2, "4.2.0.0");
        exitQualifier2 = "Mongo DB";
        agentCompatibilityVersionMap.put(exitQualifier2, "4.2.0.0");
        exitQualifier2 = "Couchbase";
        agentCompatibilityVersionMap.put(exitQualifier2, "4.4.1.0");
        for (Field field : GenericExitPointTypeUtils.getGenericExitPointTypeFields(GenericExitPointTypes.class)) {
            GenericExitPointTypeUtils.addGenericExitPointSupportedVersionToMap((Field)field, agentCompatibilityVersionMap);
        }
        return CollectionHelper.unmodifiableMap(agentCompatibilityVersionMap);
    }

    private static BackendDiscoveryConfig deepCopy(BackendDiscoveryConfig source) {
        BackendDiscoveryConfig copy = new BackendDiscoveryConfig();
        source.deepCopy(copy);
        return copy;
    }

    public static BackendDiscoveryConfig[] getJavaDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(dbConfig), DefaultBackendDiscoveryConfigs.deepCopy(httpConfig), DefaultBackendDiscoveryConfigs.deepCopy(rmiConfig), DefaultBackendDiscoveryConfigs.deepCopy(webServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(jmsServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(mqServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(thriftServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(cassandraCQLServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(rabbitMQConfig), DefaultBackendDiscoveryConfigs.deepCopy(webSocketConfig), DefaultBackendDiscoveryConfigs.deepCopy(amazonSQSConfig), DefaultBackendDiscoveryConfigs.deepCopy(amazonS3Config), DefaultBackendDiscoveryConfigs.deepCopy(amazonSNSConfig), DefaultBackendDiscoveryConfigs.deepCopy(mongoConfig), DefaultBackendDiscoveryConfigs.deepCopy(amazonDynamoDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(joltServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(kafkaServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(vertxMessageServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(vertxMessageAsyncServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(axonServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(couchbaseServiceConfig)};
    }

    public static BackendDiscoveryConfig[] getDOTNetDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(dotnethttpConfig), DefaultBackendDiscoveryConfigs.deepCopy(adoDotNetConfig), DefaultBackendDiscoveryConfigs.deepCopy(dotNetWebServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(dotNetJMSConfig), DefaultBackendDiscoveryConfigs.deepCopy(dotNetWCFServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(dotNetRemotingConfig), DefaultBackendDiscoveryConfigs.deepCopy(dotNetMongoConfig), DefaultBackendDiscoveryConfigs.deepCopy(dotNetServiceFabricConfig)};
    }

    public static BackendDiscoveryConfig[] getPHPDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(phpDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(phpHttpConfig), DefaultBackendDiscoveryConfigs.deepCopy(phpCacheConfig), DefaultBackendDiscoveryConfigs.deepCopy(phpWebServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(phpRabbitMQConfig)};
    }

    public static BackendDiscoveryConfig[] getNodeJSDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(nodeJSDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(nodeJSHttpConfig), DefaultBackendDiscoveryConfigs.deepCopy(nodeJSCacheConfig), DefaultBackendDiscoveryConfigs.deepCopy(nodejsMongoConfig), DefaultBackendDiscoveryConfigs.deepCopy(amazonDynamoDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(couchbaseServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(cassandraCQLServiceConfig), DefaultBackendDiscoveryConfigs.deepCopy(nodejsWebServiceConfig)};
    }

    public static BackendDiscoveryConfig[] getPythonDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(pythonDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(pythonHttpConfig), DefaultBackendDiscoveryConfigs.deepCopy(pythonCacheConfig), DefaultBackendDiscoveryConfigs.deepCopy(pythonMongoConfig)};
    }

    public static BackendDiscoveryConfig[] getRubyDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(rubyDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(rubyHttpConfig), DefaultBackendDiscoveryConfigs.deepCopy(rubyCacheConfig)};
    }

    public static BackendDiscoveryConfig[] getDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(defaultDBConfig), DefaultBackendDiscoveryConfigs.deepCopy(defaultHttpConfig)};
    }

    public static BackendDiscoveryConfig[] getNativeWebServerDefaultConfigs() {
        return new BackendDiscoveryConfig[]{DefaultBackendDiscoveryConfigs.deepCopy(moduleConfig)};
    }
}

