/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller;

import com.singularity.ee.controller.api.constants.PropertyType;
import com.singularity.ee.controller.api.dto.Property;
import com.singularity.ee.controller.api.dto.PropertyDefinition;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.LinkedListImpl;
import java.util.Collection;
import java.util.List;

public class ApplicationComponentNodeProperties {
    public static final String INTERCEPTOR_CALL_TRACING = "interceptor-call-tracing";
    public static final String INTERCEPTOR_STATS_TRACKING_ENABLED = "interceptor-stats-tracking-enabled";
    public static final String REST_STATS_TRACKING_FREQUENCY_IN_SECONDS = "rest-stats-tracking-frequency-in-seconds";
    public static final String REST_STATS_TRACKING_ENABLED = "rest-stats-tracking-enabled";
    public static final String DISABLE_AGENT = "disable-agent";
    public static final String CONFIG_POLL_INTERVAL = "config-poll-interval";
    public static final String ENABLE_XML_BCI_RULES = "enable-xml-bci-rules";
    public static final String ENABLE_JSON_BCI_RULES = "enable-json-bci-rules";
    public static final String ADAPTIVE_CALLGRAPH_GRANULARITY = "adaptive-callgraph-granularity";
    public static final String MAX_JDBC_CALLS_PER_SNAPSHOT = "max-jdbc-calls-per-snapshot";
    public static final String MAX_JDBC_CALLS_PER_CALLGRAPH = "max-jdbc-calls-per-callgraph";
    public static final String MIN_DURATION_FOR_JDBC_CALL_IN_MS = "min-duration-for-jdbc-call-in-ms";
    public static final String DONT_SHOW_PACKAGES = "dont-show-packages";
    public static final String SHOW_PACKAGES = "show-packages";
    public static final String CALLGRAPH_GRANULARITY_IN_MS = "callgraph-granularity-in-ms";
    public static final String ON_DEMAND_SNAPSHOTS = "on-demand-snapshots";
    public static final String ENABLE_STARTUP_SNAPSHOT_POLICY = "enable-startup-snapshot-policy";
    public static final String API_THREAD_ACTIVITY_TIMEOUT_IN_SECONDS = "api-thread-activity-timeout-in-seconds";
    public static final String API_TRANSACTION_TIMEOUT_IN_SECONDS = "api-transaction-timeout-in-seconds";
    public static final String SLOW_REQUEST_DEVIATION = "slow-request-deviation";
    public static final String SLOW_REQUEST_THRESHOLD = "slow-request-threshold";
    public static final String SLOW_REQUEST_MONITOR_INTERVAL = "slow-request-monitor-interval";
    public static final String MIN_LOAD_PER_MINUTE_DIAGNOSTIC_SESSION_TRIGGER = "min-load-per-minute-diagnostic-session-trigger";
    public static final String MAX_BUSINESS_TRANSACTIONS = "max-business-transactions";
    public static final String DISABLE_EXIT_CALL_METRICS_FOR = "disable-exit-call-metrics-for";
    public static final String JDBC_CALLABLE_STATEMENTS = "jdbc-callable-statements";
    public static final String JDBC_PREPARED_STATEMENTS = "jdbc-prepared-statements";
    public static final String JDBC_CONNECTIONS = "jdbc-connections";
    public static final String JDBC_STATEMENTS = "jdbc-statements";
    public static final String COLLECT_USER_DATA_SYNC = "collect-user-data-sync";
    public static final String CAPTURE_RAW_SQL = "capture-raw-sql";
    public static final String ENABLE_TRANSACTION_CORRELATION = "enable-transaction-correlation";
    public static final String ENABLE_SOAP_HEADER_CORRELATION = "enable-soap-header-correlation";
    public static final String JMX_GC_MAJOR_COLLECTION_BEAN = "jmx-gc-majorCollectionBean";
    public static final String JMX_GC_MINOR_COLLECTION_BEAN = "jmx-gc-minorCollectionBean";
    public static final String CALL_TRACER_METHODS = "call-tracer-methods";
    public static final String CALL_TRACER_ENABLE = "call-tracer-enable";
    public static final String MEMORY_MONITOR_OBJECTS_TO_LOG = "memory-monitor-objects-to-log";
    public static final String MEMORY_MONITOR_ENABLE_OBJECT_LOGGING = "memory-monitor-enable-object-logging";
    public static final String MEMORY_MONITOR_CLASSES = "memory-monitor-classes";
    public static final String MEMORY_MONITOR_STATIC_FIELDS = "memory-monitor-static-fields";
    public static final String MEMORY_MONITOR_CLASS_FILTER = "memory-monitor-class-filter";
    public static final String MEMORY_MONITOR_METHODS = "memory-monitor-methods";
    public static final String MEMORY_MONITORING_INTERVAL_IN_MINUTES = "memory-monitoring-interval-in-minutes";
    public static final String MEMORY_MONITORING_ENABLE = "memory-monitoring-enable";
    public static final String ENABLE_COLLECTION_MONITORING = "enable-collection-monitoring";
    public static final String ENABLE_INSTANCE_MONITORING = "enable-instance-monitoring";
    public static final String ENABLE_OBJECT_SIZE_MONITORING = "enable-object-size-monitoring";
    public static final String MINIMUM_SIZE_FOR_EVALUATION_MB = "minimum-size-for-evaluation-in-mb";
    public static final String COLLECTION_CAPTURE_PERIOD_IN_MINUTES = "collection-capture-period-in-minutes";
    public static final String MINIMUM_AGE_FOR_EVALUATION_IN_MINUTES = "minimum-age-for-evaluation-in-minutes";
    public static final String EVALUATE_RUNTIME_BCI_RULES = "evaluate-runtime-bci-rules";
    public static final String BCIFIXER_BATCH_TIME_LIMIT = "bcifixer-batch-time-limit";
    public static final String BCIFIXER_BATCH_PERIOD = "bcifixer-batch-period";
    public static final String END_TO_END_MESSAGE_LATENCY_THRESHOLD_MS = "end-to-end-message-latency-threshold-millis";
    public static final String ASYNC_TRANSACTION_DEMARCATOR = "async-transaction-demarcator";
    public static final String LEAK_DIAGNOSTIC_INTERVAL_IN_MINUTES = "leak-diagnostic-interval-in-minutes";
    public static final String ENABLE_LATENCY_MONITORING = "enable-latency-monitoring";
    public static final String ENABLE_DEFAULT_HTTP_ERROR_CODES = "enable-default-http-error-code-reporter";
    public static final String CAPTURE_ERROR_URLS = "capture-error-urls";
    public static final String DISABLE_EXIT_CALL_CORRELATION = "disable-exit-call-correlation-for";
    public static final String DOWNSTREAM_TX_DETECTION_ENABLED = "downstream-tx-detection-enabled";
    public static final String LOG_REQUEST_PAYLOAD = "log-request-payload";
    public static final String FIND_ENTRY_POINTS = "find-entry-points";
    public static final String DISABLE_CUSTOM_EXIT_POINTS_FOR = "disable-custom-exit-points-for";
    public static final String MONITORED_APP_IS_CONTROLLER = "monitored-app-is-controller";
    public static final String REST_TRANSACTION_NAMING = "rest-transaction-naming";
    public static final String REST_URI_SEGMENT_SCHEME = "rest-uri-segment-scheme";
    public static final String REST_NUM_SEGMENTS = "rest-num-segments";

    public static Property[] getDefaultAgentConfiguration() {
        LinkedListImpl properties = new LinkedListImpl();
        ApplicationComponentNodeProperties.addBCIEngineServiceProperties((List<Property>)properties);
        ApplicationComponentNodeProperties.addSnapshotServiceProperties((List<Property>)properties);
        ApplicationComponentNodeProperties.addTransactionMonitoringServiceProperties((List<Property>)properties);
        ApplicationComponentNodeProperties.addObjectMonitoringProperties((List<Property>)properties);
        return (Property[])CollectionHelper.collectionToArray((Collection)properties, (Object[])new Property[properties.size()]);
    }

    private static void addObjectMonitoringProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(ENABLE_OBJECT_SIZE_MONITORING);
        definition.setDescription("Enables / Disables Object Size monitoring feature on this node. Doesn't need a restart for JVM version 1.6 upwards");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ENABLE_INSTANCE_MONITORING);
        definition.setDescription("Enables / Disables Instance tracking feature on this node. Doesn't need a JVM restart.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ENABLE_COLLECTION_MONITORING);
        definition.setDescription("Enables / Disables Collection monitoring feature on this node. Feature available only on JVMs versions 1.6 upwards and requires restart.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MINIMUM_SIZE_FOR_EVALUATION_MB);
        definition.setDescription("Minimum initial size in mega bytes for a collection to qualify to show up in Automatic Leak Detection tab. The collection must also survive for the period specified in property [minimum-age-for-evaluation-in-minutes]. Default value is 5 MB. ");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("5");
        definition.setLowerNumericBound("1");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MINIMUM_AGE_FOR_EVALUATION_IN_MINUTES);
        definition.setDescription("Minimum age of the collection in minutes to qualify the collection as a Automatic Leak Detection candidate. The property takes effect after node restart.");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("30");
        definition.setLowerNumericBound("5");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(COLLECTION_CAPTURE_PERIOD_IN_MINUTES);
        definition.setDescription("Total interval in minutes since server restart for which collections will be captured for leak evaluation. The property takes effect only after the node restart.");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("30");
        definition.setLowerNumericBound("5");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(LEAK_DIAGNOSTIC_INTERVAL_IN_MINUTES);
        definition.setDescription("Interval at which diagnostic data (content summary and activity trace) will be captured for leaking collections");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("30");
        definition.setLowerNumericBound("2");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }

    private static void addDiagnosticsServiceProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITORING_ENABLE);
        definition.setDescription("Enables Memory monitoring feature on this node. This flag can be used for global enable / disable of the feature.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITORING_INTERVAL_IN_MINUTES);
        definition.setDescription("Interval in minutes at which monitored object's size will be calculated and reported. ");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("10");
        definition.setLowerNumericBound("1");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITOR_METHODS);
        definition.setDescription("Comma separated list of object accessor methods, whose return value needs to be monitored, typically static methods or singleton accessor methods,\ne.g. com.Foo.MyCache#getMyCache, com.Foo.AnotherCache#getAnotherCache. New definitions can be added, exiting ones can be removed without needing to restart If the return value is implementation of an interface, then all classes implementing the interface will be identified as candidate for memory server JVM for JVM Versions 1.6 or higher. The class objects identified from return value can be filtered by adding class names to  'memory-monitor-class-filter' property. Refer to the property description below. Static fields are not included in size computation. Use 'memory-monitor-static-fields' to track static objects");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITOR_CLASS_FILTER);
        definition.setDescription("A comma separated list of fully qualified class names to filter the list of classes that needs to be monitored based on the return value of 'memory-monitor-methods', e.g. If the defined method returns 20 different implementations of an ICache interface but only two implementations of ICache needs to be monitored then set the fully qualified class names 'com.foo.ACache, com.foo.BCache' You may add or remove new class names without needing to restart server JVM");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITOR_STATIC_FIELDS);
        definition.setDescription("Comma separated list of fully qualified class name and static field name(s) that needs to be monitored, e.g. com.Foo.MyCache#myHashMap, com.Foo.AnotherCache#myOtherHashTable. New Fields can be added or removed without server JVM restart.");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITOR_CLASSES);
        definition.setDescription("A comma seprate list of fully qualified class names. All instances of these class objects will be monitored, e.g. com.Foo.MyCache, com.Foo.AnotherCache. New class names can be added only in servers running JDK 1.6 and upwards.");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITOR_ENABLE_OBJECT_LOGGING);
        definition.setDescription("Enable logging of objects being monitored. Map<> objects contained in each of the object (upto 20 maps / object) will be logged in a file named by the object name in the agent logs directory. ");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MEMORY_MONITOR_OBJECTS_TO_LOG);
        definition.setDescription("A comma separated list of object names (as shown in metric browser) that needs to be monitored. ");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(CALL_TRACER_ENABLE);
        definition.setDescription("Enable or disable call tracer feature. This feature enables tracing calls to specific class and methods, doesn't need a JVM restart to take effect");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(CALL_TRACER_METHODS);
        definition.setDescription("Comma separated list of fully qualified class name and method name(s) whose caller needs to be traced, e.g. com.Foo.MyCache#getMyCache, com.Foo.AnotherCache#getAnotherCache. New definitions can be added without the need for JVM restart for JVMs 1.6 upwards. Traces are sent every minute as an APPLICATION_INFO event viewable on Event viewer. Data will be collected as long as 'call-tracer-enable' is set to true. It is recommended to set call-tracer-enable to false or delete the call-trace methods after necessary data is obtained.");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }

    private static void addJMXServiceProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(JMX_GC_MINOR_COLLECTION_BEAN);
        definition.setDescription("set the jmx ");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(JMX_GC_MAJOR_COLLECTION_BEAN);
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }

    private static void addTransactionMonitoringServiceProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(ENABLE_TRANSACTION_CORRELATION);
        definition.setDescription("Disable/enable transaction correlation, default value is true, doesn't require restart");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.TRUE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ENABLE_SOAP_HEADER_CORRELATION);
        definition.setDescription("Disable/enable web service transaction correlation, default value is false, doesn't require restart");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(COLLECT_USER_DATA_SYNC);
        definition.setDescription("Collect user data from diagnostic pojo data collectors synchronously,  default value is true, doesn't require restart");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.TRUE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(CAPTURE_RAW_SQL);
        definition.setDescription("Capture Raw SQLs for this node. eg. select * from user where ssn = '123-123-1234'");
        definition.setDefaultStringValue("false");
        definition.setType(PropertyType.BOOLEAN);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(JDBC_STATEMENTS);
        definition.setDescription("Implementation classes of the java.sql.Statement interface");
        definition.setDefaultStringValue("");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(JDBC_CONNECTIONS);
        definition.setDescription("Implementation classes of the java.sql.Connection interface");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(JDBC_PREPARED_STATEMENTS);
        definition.setDescription("Implementation classes of the java.sql.PreparedStatement interface");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(JDBC_CALLABLE_STATEMENTS);
        definition.setDescription("Implementation classes of the java.sql.CallableStatement interface");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(DISABLE_EXIT_CALL_METRICS_FOR);
        definition.setDescription("Disable exit call monitoring for a specific type i.e JDBC, HTTP, JMS, WEB_SERVICE. If set the average data (calls /min, Avg response time for the specific exit call type will not  be collected. However on a snapshot all details will be collected.  Set this if the app makes a large number of exit calls per transaction and the avg metrics is not important. By default all exit call metrics are enabled.");
        definition.setDefaultStringValue("");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(DISABLE_EXIT_CALL_CORRELATION);
        definition.setDescription("Disable exit call correlation for a specific type i.e HTTP, JMS, RMI. By default all exit call correlation are enabled.");
        definition.setDefaultStringValue("");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(DISABLE_CUSTOM_EXIT_POINTS_FOR);
        definition.setDescription("Disable Out of the box custom exit points by specifying the type here, e.g. ehcache For multiple, use a comma separated list from the following SAP,Mail,LDAP,MongoDB");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MAX_BUSINESS_TRANSACTIONS);
        definition.setDescription("Number of business transactions discovered once an agent is started. This is done to prevent business transaction metric explosion as an unsuitable discovery scheme can potentially produce thousands of transactions, Default value is 50.");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("50");
        definition.setUpperNumericBound("300");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MIN_LOAD_PER_MINUTE_DIAGNOSTIC_SESSION_TRIGGER);
        definition.setDescription("Number of requests per Business Transaction to evaluate before triggering a diagnostic session. This is to prevent diagnostic sessions when there is not enough load. ");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("10");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(SLOW_REQUEST_THRESHOLD);
        definition.setType(PropertyType.INTEGER);
        definition.setDescription("In flight requests taking more time than this threshold (in ms) and with a deviation greater than 'slow-request-deviation' from the current average response time will be monitored to capture hotspots. ");
        definition.setDefaultStringValue("500");
        definition.setLowerNumericBound("0");
        definition.setUpperNumericBound("3600");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(SLOW_REQUEST_MONITOR_INTERVAL);
        definition.setType(PropertyType.INTEGER);
        definition.setDescription("In flight requests are checked for slowness in intervals (in ms) specified by this property.");
        definition.setDefaultStringValue("100");
        definition.setLowerNumericBound("0");
        definition.setUpperNumericBound("3600");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(SLOW_REQUEST_DEVIATION);
        definition.setType(PropertyType.INTEGER);
        definition.setDescription("Value (in ms) for the deviation from the current average response time, used for evaluation of slow inflight transactions. Also see 'slow-request-threshold' property for more details.");
        definition.setDefaultStringValue("200");
        definition.setLowerNumericBound("10");
        definition.setUpperNumericBound("3600");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(API_TRANSACTION_TIMEOUT_IN_SECONDS);
        definition.setType(PropertyType.INTEGER);
        definition.setDescription("Timeout value in seconds for global transactions initiated by appdynamics api. The endTransaction api  will be invoked after the specified timeout period. Default value is 15 seconds");
        definition.setDefaultStringValue("300");
        definition.setLowerNumericBound("1");
        definition.setUpperNumericBound("3600");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(API_THREAD_ACTIVITY_TIMEOUT_IN_SECONDS);
        definition.setType(PropertyType.INTEGER);
        definition.setDescription("Timeout value in seconds for threads participating in a global transaction added by appdynamics api.  The removeCurrentThread api will be invoked after the specified timeout period. Default value is 10 seconds");
        definition.setDefaultStringValue("300");
        definition.setLowerNumericBound("1");
        definition.setUpperNumericBound("3600");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ENABLE_DEFAULT_HTTP_ERROR_CODES);
        definition.setDescription("Disable/enable automatic HTTP error code reporting for error codes between 400 - 505, default TRUE.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.TRUE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(CAPTURE_ERROR_URLS);
        definition.setDescription("Disable/enable capturing the URLs causing HTTP errors. The URLs are reported as ERROR events every 15 minutes, viewable through Event Viewer. Default TRUE. JVM needs restart if re-transformation is not supported for the JVM version. ");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.TRUE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(END_TO_END_MESSAGE_LATENCY_THRESHOLD_MS);
        definition.setDescription("Enable end to end message latency monitoring for distributed asynchronouse systems by setting up a threshold any message taking more than the threshold is viewable through Event Viewer.");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("0");
        definition.setLowerNumericBound("0");
        definition.setUpperNumericBound("36000");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ASYNC_TRANSACTION_DEMARCATOR);
        definition.setDescription("This Class Name/method name combination marks the end of an async distributed transaction \nUse the format ClassName/Method Name e.g. foo/bar where foo is class name and bar is method name");
        definition.setType(PropertyType.STRING);
        definition.setDefaultStringValue("");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(DOWNSTREAM_TX_DETECTION_ENABLED);
        definition.setDescription("If the agent cannot reach the controller for a prolonged period, it turns off most services, and notifies the continuing tiers that upstream transaction was detected and is not being monitored. Defaults to false.Set this to true if you wish the continuing tiers to detect thier own transactions in the event of network failure on the upstream tiers.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(FIND_ENTRY_POINTS);
        definition.setDescription("When there is a chance that not all traffic/no traffic is being detected as business transactions, turn this flag on to log all potential entry points that are hitting instrumented exit points or loggers to the BusinessTransactions log file.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(LOG_REQUEST_PAYLOAD);
        definition.setDescription("Turn this on to log request payload(HTTP parameters/cookies/session keys etc) as part of a request snapshot. ");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(REST_TRANSACTION_NAMING);
        definition.setDescription("Controls how JAX-RS transactions are named. Does not need a restart ");
        definition.setDefaultStringValue("{class-annotation}/{method-annotation}.{http-method}");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(REST_URI_SEGMENT_SCHEME);
        definition.setDescription("Segment scheme to process the URI of JAX-RS transactions. Does not need a restart ");
        definition.setDefaultStringValue("first-n-segments");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(REST_NUM_SEGMENTS);
        definition.setDescription("Number of segments to be used by rest-uri-segment-scheme. Does not need a restart ");
        definition.setDefaultStringValue("2");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }

    private static void addSnapshotServiceProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(ENABLE_STARTUP_SNAPSHOT_POLICY);
        definition.setDescription("Disable/enable the policy for startup request snapshots which will mean snapshots will be collected for all BTs forall invocations for the first 2 minutes of an application server start. Default value is false.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ON_DEMAND_SNAPSHOTS);
        definition.setDescription("Collect snapshots for all business transactions executed in this node. Default value is false. Does not need a restart.");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(CALLGRAPH_GRANULARITY_IN_MS);
        definition.setDescription("Granularity for call graphs only for this node. The global configuration will be ignored if this is used. The value is ignored if 'adaptive-callgraph-granularity' is set to true. A value of zero (default) implies the global configuration (from Configuration --> Callgraph Settings) will be used. Does not need a restart");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("0");
        definition.setLowerNumericBound("0");
        definition.setUpperNumericBound(String.valueOf(5000));
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(SHOW_PACKAGES);
        definition.setDescription("Show these packages / class names in addition to the ones configured in the global callgraph configuration, for the callgraphs captured on this node. Does not need a restart");
        definition.setDefaultStringValue("");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(DONT_SHOW_PACKAGES);
        definition.setDescription("Do not show these packages / class names in addition to the ones configured in the global callgraph configuration, for the callgraphs captured on this node. Does not need a restart");
        definition.setDefaultStringValue("");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MIN_DURATION_FOR_JDBC_CALL_IN_MS);
        definition.setDescription("JDBC call taking more time than the specified time (in milliseconds) will be captured in Callgraph. The quesry will continue to show up in request snapshot. Setting this value too low (< 10ms) may affect application response times. Does not need a restart");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue(String.valueOf(10));
        definition.setLowerNumericBound("0");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MAX_JDBC_CALLS_PER_CALLGRAPH);
        definition.setDescription("Maximum number of sql queries  that will be reported per callgraph. Note - Only queries taking more time than 'min-duration-for-jdbc-callsample' wil be reported. Does not need a restart");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("100");
        definition.setLowerNumericBound("1");
        definition.setUpperNumericBound("1000");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(MAX_JDBC_CALLS_PER_SNAPSHOT);
        definition.setDescription("Maximum number of unique sql queries that will be reported per snapshot. Does not need a restart");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("500");
        definition.setLowerNumericBound("1");
        definition.setUpperNumericBound("5000");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ADAPTIVE_CALLGRAPH_GRANULARITY);
        definition.setDescription("Callgraph granularity based on average response time for the business transaction in last 1 minute. The following distribution is used. Granularity of 10ms for avg response time of <= 10 seconds; 50 ms for 10 to 60 secs; 100 ms for 60 to 600 secs; 200ms for > 600 seconds");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }

    private static void addBCIEngineServiceProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(ENABLE_JSON_BCI_RULES);
        definition.setDescription(" set this property to true to enable JSON Byte Code Instrumentation rules 'org.json.JSONObject'.'get/getString', default value is 'true', needs JVM restart. ");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.TRUE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(ENABLE_XML_BCI_RULES);
        definition.setDescription(" set this property to true to enable Java XML Binding and DOM Parser Byte Code Instrumentation rules, default value is 'true', needs JVM restart. ");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.TRUE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }

    private static void addKernelProperties(List<Property> properties) {
        PropertyDefinition definition = new PropertyDefinition();
        definition.setName(CONFIG_POLL_INTERVAL);
        definition.setDescription("Interval in seconds for the agent to poll for the new configuration from the controller. Needs a restart");
        definition.setType(PropertyType.INTEGER);
        definition.setDefaultStringValue("60");
        definition.setLowerNumericBound("10");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(DISABLE_AGENT);
        definition.setDescription("Stops the agent from monitoring the server. Does not need a restart");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(REST_STATS_TRACKING_ENABLED);
        definition.setDescription("Timing stats for agent and controller rest communication. Does not need a restart");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(REST_STATS_TRACKING_FREQUENCY_IN_SECONDS);
        definition.setType(PropertyType.INTEGER);
        definition.setDescription("Frequency for printing REST stats. Does not need a restart");
        definition.setDefaultStringValue("60");
        definition.setLowerNumericBound("30");
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(INTERCEPTOR_STATS_TRACKING_ENABLED);
        definition.setDescription("Enable timing stats for interceptors. Does not need a restart");
        definition.setType(PropertyType.BOOLEAN);
        definition.setDefaultStringValue(Boolean.FALSE.toString());
        properties.add(new Property(definition, definition.getDefaultStringValue()));
        definition = new PropertyDefinition();
        definition.setName(INTERCEPTOR_CALL_TRACING);
        definition.setDescription("To log where a specified interceptor is being called from periodically. Does not need a restart ");
        definition.setDefaultStringValue("");
        definition.setType(PropertyType.STRING);
        properties.add(new Property(definition, definition.getDefaultStringValue()));
    }
}

