/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.collection.hppc;

import com.singularity.ee.agent.util.collection.hppc.AbstractIterator;
import com.singularity.ee.agent.util.collection.hppc.AbstractLongCollection;
import com.singularity.ee.agent.util.collection.hppc.HashContainerUtils;
import com.singularity.ee.agent.util.collection.hppc.Internals;
import com.singularity.ee.agent.util.collection.hppc.LongCollection;
import com.singularity.ee.agent.util.collection.hppc.LongContainer;
import com.singularity.ee.agent.util.collection.hppc.LongCursor;
import com.singularity.ee.agent.util.collection.hppc.LongLongAssociativeContainer;
import com.singularity.ee.agent.util.collection.hppc.LongLongCursor;
import com.singularity.ee.agent.util.collection.hppc.LongLongMap;
import com.singularity.ee.agent.util.collection.hppc.LongLongProcedure;
import com.singularity.ee.agent.util.collection.hppc.LongLookupContainer;
import com.singularity.ee.agent.util.collection.hppc.LongPredicate;
import com.singularity.ee.agent.util.collection.hppc.LongProcedure;
import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import java.util.Iterator;

public class LongLongOpenHashMap
implements LongLongMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public long[] _keys;
    public long[] _values;
    public boolean[] allocated = null;
    public int assigned;
    public final float loadFactor;
    private int resizeAt;
    private int lastSlot;

    public LongLongOpenHashMap() {
        this(16);
    }

    public LongLongOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongLongOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public LongLongOpenHashMap(LongLongAssociativeContainer container) {
        this((int)((float)container.Size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public long put(long key, long value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this._keys[slot]) {
                long oldValue = this._values[slot];
                this._values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this._keys[slot] = key;
            this._values[slot] = value;
        }
        return 0L;
    }

    @Override
    public int putAll(LongLongAssociativeContainer container) {
        int count = this.assigned;
        ADIterator iterator = new ADIterator((Iterable)container);
        while (iterator.hasNext()) {
            LongLongCursor c = (LongLongCursor)iterator.next();
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<LongLongCursor> iterable) {
        int count = this.assigned;
        ADIterator i = new ADIterator(iterable);
        while (i.hasNext()) {
            LongLongCursor c = (LongLongCursor)i.next();
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(long key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public long putOrAdd(long key, long putValue, long additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this._keys[slot]) {
                this._values[slot] = this._values[slot] + additionValue;
                return this._values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this._keys[slot] = key;
            this._values[slot] = putValue;
        }
        return putValue;
    }

    public long addTo(long key, long additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(long pendingKey, long pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        long[] oldKeys = this._keys;
        long[] oldValues = this._values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this._keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        long[] keys = this._keys;
        long[] values = this._values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            long k = oldKeys[i];
            long v = oldValues[i];
            int slot = Internals.rehash(k) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        long[] keys = new long[capacity];
        long[] values = new long[capacity];
        boolean[] allocated = new boolean[capacity];
        this._keys = keys;
        this._values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
    }

    @Override
    public long remove(long key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this._keys[slot]) {
                --this.assigned;
                long v = this._values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0L;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this._keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this._keys[slotPrev] = this._keys[slotCurr];
            this._values[slotPrev] = this._values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public int removeAll(LongContainer container) {
        int before = this.assigned;
        ADIterator iterator = new ADIterator((Iterable)container);
        while (iterator.hasNext()) {
            LongCursor c = (LongCursor)iterator.next();
            this.remove(c.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.assigned;
        long[] keys = this._keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public long get(long key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this._keys[slot]) {
                return this._values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0L;
    }

    public long lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this._values[this.lastSlot];
    }

    public long lset(long key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        long previous = this._values[this.lastSlot];
        this._values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(long key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this._keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        ArrayUtilsHelper.fill((boolean[])this.allocated, (boolean)false);
    }

    @Override
    public int Size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.Size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        ADIterator iterator = new ADIterator((Iterable)this);
        while (iterator.hasNext()) {
            LongLongCursor c = (LongLongCursor)iterator.next();
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            LongLongMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongLongMap && (other = (LongLongMap)obj).Size() == this.Size()) {
                ADIterator iterator = new ADIterator((Iterable)this);
                while (iterator.hasNext()) {
                    long v;
                    LongLongCursor c = (LongLongCursor)iterator.next();
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<LongLongCursor> iterator() {
        return new EntryIterator(this);
    }

    @Override
    public LongLongProcedure forEach(LongLongProcedure procedure) {
        long[] keys = this._keys;
        long[] values = this._values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public LongCollection keys() {
        return new KeysContainer(this);
    }

    @Override
    public LongContainer values() {
        return new ValuesContainer(this);
    }

    public Object clone() {
        try {
            LongLongOpenHashMap cloned = (LongLongOpenHashMap)super.clone();
            cloned._keys = (long[])this._keys.clone();
            cloned._values = (long[])this._values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        ADIterator i = new ADIterator((Iterable)this);
        while (i.hasNext()) {
            LongLongCursor cursor = (LongLongCursor)i.next();
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static LongLongOpenHashMap from(long[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongLongOpenHashMap map = new LongLongOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static LongLongOpenHashMap from(LongLongAssociativeContainer container) {
        return new LongLongOpenHashMap(container);
    }

    public static LongLongOpenHashMap newInstance() {
        return new LongLongOpenHashMap();
    }

    public static LongLongOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new LongLongOpenHashMap(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<LongLongCursor> {
        private final LongLongCursor cursor = new LongLongCursor();
        private final LongLongOpenHashMap owner;

        public EntryIterator(LongLongOpenHashMap owner) {
            this.cursor.index = -1;
            this.owner = owner;
        }

        @Override
        protected LongLongCursor fetch() {
            int i;
            int max = this.owner._keys.length;
            for (i = this.cursor.index + 1; i < max && !this.owner.allocated[i]; ++i) {
            }
            if (i == max) {
                this.done();
                return null;
            }
            this.cursor.index = i;
            this.cursor.key = this.owner._keys[i];
            this.cursor.value = this.owner._values[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongLongOpenHashMap owner;

        public KeysContainer(LongLongOpenHashMap owner) {
            this.owner = owner;
        }

        @Override
        public boolean Contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public LongProcedure forEach(LongProcedure procedure) {
            long[] localKeys = this.owner._keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public LongPredicate forEach(LongPredicate predicate) {
            long[] localKeys = this.owner._keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator(this.owner);
        }

        @Override
        public int Size() {
            return this.owner.Size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(long e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final LongLongOpenHashMap owner;

        public ValuesContainer(LongLongOpenHashMap owner) {
            this.owner = owner;
        }

        @Override
        public int Size() {
            return this.owner.Size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean Contains(long value) {
            boolean[] allocated = this.owner.allocated;
            long[] values = this.owner._values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public LongProcedure forEach(LongProcedure procedure) {
            boolean[] allocated = this.owner.allocated;
            long[] values = this.owner._values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public LongPredicate forEach(LongPredicate predicate) {
            boolean[] allocated = this.owner.allocated;
            long[] values = this.owner._values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator(this.owner);
        }

        @Override
        public int removeAllOccurrences(long e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final LongLongOpenHashMap owner;

        public ValuesIterator(LongLongOpenHashMap owner) {
            this.cursor.index = -1;
            this.owner = owner;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            int max = this.owner._keys.length;
            for (i = this.cursor.index + 1; i < max && !this.owner.allocated[i]; ++i) {
            }
            if (i == max) {
                this.done();
                return null;
            }
            this.cursor.index = i;
            this.cursor.value = this.owner._values[i];
            return this.cursor;
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final LongLongOpenHashMap owner;

        public KeysIterator(LongLongOpenHashMap owner) {
            this.cursor.index = -1;
            this.owner = owner;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            int max = this.owner._keys.length;
            for (i = this.cursor.index + 1; i < max && !this.owner.allocated[i]; ++i) {
            }
            if (i == max) {
                this.done();
                return null;
            }
            this.cursor.index = i;
            this.cursor.value = this.owner._keys[i];
            return this.cursor;
        }
    }
}

