/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.collection.hppc;

import com.singularity.ee.agent.util.collection.hppc.AbstractIterator;
import com.singularity.ee.agent.util.collection.hppc.AbstractLongCollection;
import com.singularity.ee.agent.util.collection.hppc.ArraySizingStrategy;
import com.singularity.ee.agent.util.collection.hppc.BoundedProportionalArraySizingStrategy;
import com.singularity.ee.agent.util.collection.hppc.Internals;
import com.singularity.ee.agent.util.collection.hppc.LongContainer;
import com.singularity.ee.agent.util.collection.hppc.LongCursor;
import com.singularity.ee.agent.util.collection.hppc.LongIndexedContainer;
import com.singularity.ee.agent.util.collection.hppc.LongPredicate;
import com.singularity.ee.agent.util.collection.hppc.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongArrayList
extends AbstractLongCollection
implements LongIndexedContainer,
Cloneable {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = new long[0];
    public long[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public LongArrayList() {
        this(5);
    }

    public LongArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public LongArrayList(LongContainer container) {
        this(container.Size());
        this.addAll(container);
    }

    @Override
    public void add(long e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(long e1, long e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(long[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(long ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(LongContainer container) {
        int size = container.Size();
        this.ensureBufferSpace(size);
        for (LongCursor cursor : container) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.add(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, long e1) {
        assert (index >= 0 && index <= this.Size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.Size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public long get(int index) {
        assert (index >= 0 && index < this.Size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.Size() + ").";
        return this.buffer[index];
    }

    @Override
    public long set(int index, long e1) {
        assert (index >= 0 && index < this.Size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.Size() + ").";
        long v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public long remove(int index) {
        assert (index >= 0 && index < this.Size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.Size() + ").";
        long v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0L;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.Size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.Size() + ").";
        assert (toIndex >= 0 && toIndex <= this.Size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.Size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, 0L);
    }

    @Override
    public int removeFirstOccurrence(long e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLastOccurrence(long e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAllOccurrences(long e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0L;
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = 0L;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean Contains(long e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(long e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.Size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            long[] newBuffer = new long[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0L);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0L);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int Size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.Size() != this.buffer.length) {
            this.buffer = this.ToArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0L);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = (long[])EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public long[] ToArray() {
        long[] copy = new long[this.elementsCount];
        System.arraycopy(this.buffer, 0, copy, 0, Math.min(this.buffer.length, this.elementsCount));
        return copy;
    }

    public LongArrayList clone() {
        try {
            LongArrayList cloned = (LongArrayList)super.clone();
            cloned.buffer = (long[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof LongArrayList) {
                LongArrayList other = (LongArrayList)obj;
                return other.Size() == this.Size() && this.rangeEquals(other.buffer, this.buffer, this.Size());
            }
            if (obj instanceof LongIndexedContainer) {
                LongIndexedContainer other = (LongIndexedContainer)obj;
                return other.Size() == this.Size() && this.allIndexesEqual(this, other, this.Size());
            }
        }
        return false;
    }

    private boolean rangeEquals(long[] b1, long[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(LongIndexedContainer b1, LongIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            long o2;
            long o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator(this.buffer, this.Size());
    }

    @Override
    public LongProcedure forEach(LongProcedure procedure) {
        return this.forEach(procedure, 0, this.Size());
    }

    public LongProcedure forEach(LongProcedure procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.Size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.Size() + ").";
        assert (toIndex >= 0 && toIndex <= this.Size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.Size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        long[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0L;
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0L;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0L;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public LongPredicate forEach(LongPredicate predicate) {
        return this.forEach(predicate, 0, this.Size());
    }

    public LongPredicate forEach(LongPredicate predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.Size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.Size() + ").";
        assert (toIndex >= 0 && toIndex <= this.Size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.Size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        long[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static LongArrayList newInstance() {
        return new LongArrayList();
    }

    public static LongArrayList newInstanceWithCapacity(int initialCapacity) {
        return new LongArrayList(initialCapacity);
    }

    public static LongArrayList from(long ... elements) {
        LongArrayList list = new LongArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static LongArrayList from(LongContainer container) {
        return new LongArrayList(container);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        Iterator<LongCursor> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    static final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final long[] buffer;
        private final int size;

        public ValueIterator(long[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                this.done();
                return null;
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

