/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.collection.hppc;

import com.singularity.ee.agent.util.collection.hppc.BitUtil;
import com.singularity.ee.agent.util.collection.hppc.MurmurHash3;
import com.singularity.ee.util.math.LongUtils;

final class HashContainerUtils {
    static final int MAX_CAPACITY = 0x40000000;
    static final int MIN_CAPACITY = 4;
    static final int DEFAULT_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int[] PERTURBATIONS = new PerturbationsCallable().call();

    HashContainerUtils() {
    }

    static int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    static int nextCapacity(int current) {
        assert (current > 0 && LongUtils.bitCount((long)current) == 1) : "Capacity must be a power of two.";
        if (current < 2) {
            current = 2;
        }
        if ((current <<= 1) < 0) {
            throw new RuntimeException("Maximum capacity exceeded.");
        }
        return current;
    }

    private static class PerturbationsCallable {
        private PerturbationsCallable() {
        }

        public int[] call() {
            int[] result = new int[32];
            for (int i = 0; i < result.length; ++i) {
                result[i] = MurmurHash3.hash(17 + i);
            }
            return result;
        }
    }
}

