/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util.collection.hppc;

import com.singularity.ee.agent.util.collection.hppc.LongCollection;
import com.singularity.ee.agent.util.collection.hppc.LongContainer;
import com.singularity.ee.agent.util.collection.hppc.LongCursor;
import com.singularity.ee.agent.util.collection.hppc.LongLookupContainer;
import com.singularity.ee.agent.util.collection.hppc.LongPredicate;
import com.singularity.ee.agent.util.collection.hppc.LongProcedure;
import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import java.util.Iterator;

public abstract class AbstractLongCollection
implements LongCollection {
    @Override
    public int removeAll(LongLookupContainer c) {
        return this.removeAll(new RemoveAllLongPredicate(c));
    }

    @Override
    public int retainAll(LongLookupContainer c) {
        return this.removeAll(new RetainAllLongLookupContainerLongPredicate(c));
    }

    @Override
    public int retainAll(LongPredicate predicate) {
        return this.removeAll(new RetainAllLongPredicate(predicate));
    }

    @Override
    public long[] ToArray() {
        int size = this.Size();
        long[] array = new long[size];
        int i = 0;
        ADIterator iterator = new ADIterator((Iterable)this);
        if (iterator.hasNext()) {
            array[i++] = ((LongCursor)iterator.next()).value;
        }
        return array;
    }

    public String toString() {
        return ArrayUtilsHelper.arrayOfCustomObjectsToString((Object)this.ToArray());
    }

    @Override
    public abstract void clear();

    @Override
    public abstract boolean Contains(long var1);

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract Iterator<LongCursor> iterator();

    @Override
    public abstract LongProcedure forEach(LongProcedure var1);

    @Override
    public abstract LongPredicate forEach(LongPredicate var1);

    @Override
    public abstract int removeAll(LongPredicate var1);

    @Override
    public abstract int removeAllOccurrences(long var1);

    @Override
    public abstract int Size();

    private class RemoveAllLongPredicate
    implements LongPredicate {
        private final LongContainer c;

        public RemoveAllLongPredicate(LongContainer c) {
            this.c = c;
        }

        @Override
        public boolean apply(long k) {
            return this.c.Contains(k);
        }
    }

    private class RetainAllLongLookupContainerLongPredicate
    implements LongPredicate {
        private final LongContainer c;

        public RetainAllLongLookupContainerLongPredicate(LongContainer c) {
            this.c = c;
        }

        @Override
        public boolean apply(long k) {
            return !this.c.Contains(k);
        }
    }

    private class RetainAllLongPredicate
    implements LongPredicate {
        private LongPredicate predicate;

        public RetainAllLongPredicate(LongPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(long value) {
            return !this.predicate.apply(value);
        }
    }
}

