/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.util;

import com.singularity.ee.util.httpclient.HttpClientUtils;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SystemInfo {
    public static final String OS_NAME = "os.name";
    public static final String OS_VERSION = "os.version";
    public static final String OS_ARCH = "os.arch";
    public static final String USER_NAME = "user.name";
    public static final String USER_HOME = "user.home";
    public static final String USER_DIR = "user.dir";
    public static final String USER_LANGUAGE = "user.language";
    public static final String USER_COUNTRY = "user.country";
    public static final String USER_VARIANT = "user.variant";
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    public static final String JVM_NAME = "java.vm.name";
    public static final String JVM_VENDOR = "java.vendor";
    public static final String JAVA_JVM_VENDOR = "java.vm.vendor";
    public static final String JVM_VERSION = "java.version";
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String JVM_SPECIFICATION_VERSION = "java.specification.version";
    private static StringBuilder osInfo = null;
    private static StringBuilder vmInfo = null;

    public static String getDefaultHttpsProtocol(ILogger logger) {
        String tlsProtocol = null;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            SSLSocketFactory factory = context.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket();
            String[] supportedProtocols = socket.getSupportedProtocols();
            tlsProtocol = HttpClientUtils.getMostSecureCompatibleProtocol(supportedProtocols, logger);
        }
        catch (Exception exception) {
            logger.error("Error in getting a valid TLS protocol version from JDK, there might be issues in establishing an HTTPS connection because of this, check JDK Security settings:", (Throwable)exception);
        }
        return StringOperations.isEmpty(tlsProtocol) ? "TLSv1.2" : tlsProtocol;
    }

    public static String getMachineInfo() {
        if (osInfo == null) {
            StringBuilder newOsInfo = new StringBuilder();
            newOsInfo.append(OS_NAME).append("=").append(System.getProperty(OS_NAME, "unknown")).append("|");
            newOsInfo.append(OS_ARCH).append("=").append(System.getProperty(OS_ARCH, "unknown")).append("|");
            newOsInfo.append(OS_VERSION).append("=").append(System.getProperty(OS_VERSION, "unknown"));
            osInfo = newOsInfo;
        }
        return osInfo.toString();
    }

    public static String getVMInfo() {
        if (vmInfo == null) {
            StringBuilder newVmInfo = new StringBuilder();
            newVmInfo.append(JVM_NAME).append("=").append(System.getProperty(JVM_NAME, "unknown")).append("|");
            newVmInfo.append(JVM_VENDOR).append("=").append(System.getProperty(JVM_VENDOR, "unknown")).append("|");
            newVmInfo.append(JVM_VERSION).append("=").append(System.getProperty(JVM_VERSION, "unknown")).append("|");
            newVmInfo.append(USER_LANGUAGE).append("=").append(System.getProperty(USER_LANGUAGE, "unknown")).append("|");
            newVmInfo.append(USER_COUNTRY).append("=").append(System.getProperty(USER_COUNTRY, "unknown")).append("|");
            newVmInfo.append(USER_VARIANT).append("=").append(System.getProperty(USER_VARIANT, "unknown"));
            vmInfo = newVmInfo;
        }
        return vmInfo.toString();
    }

    public static boolean isWindowsMachine() {
        String osName = System.getProperty(OS_NAME);
        if (osName != null) {
            return osName.toLowerCase().contains("windows");
        }
        return false;
    }
}

