/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.httpclient.TrustManagerShouldDoDefaultValidation;
import com.singularity.ee.util.javaspecific.mutable.ADBoolean;
import com.singularity.ee.util.object.ObjectComparisonUtils;
import com.singularity.ee.util.string.StringOperations;

public class ControllerInfo {
    public static final String SAAS_CONTROLLER_NAME = "saas.appdynamics.com";
    public static final String DEFAULT_KEYSTORE_FILE_NAME = "cacerts.jks";
    private final String controllerHostName;
    private final int controllerPort;
    private final ADBoolean sslEnabled;
    private final boolean useEncryptedCredentials;
    private final ADBoolean useSslClientAuth;
    private final String keystoreFileName;
    private final String keystorePassword;
    private final String credentialStoreFilename;
    private final String credentialStorePassword;
    private final String credentialStoreFormat;
    private final String asymmetricKeysStoreFilename;
    private final String asymmetricKeysStorePassword;
    private final String asymmetricKeyPassword;
    private final String asymmetricKeyAlias;
    private final TrustManagerShouldDoDefaultValidation validation;

    public ControllerInfo(String controllerHostName, int controllerPort, boolean sslEnabled) {
        this(controllerHostName, controllerPort, new ADBoolean(sslEnabled));
    }

    public ControllerInfo(String controllerHostName, int controllerPort, ADBoolean sslEnabled) {
        this(controllerHostName, controllerPort, sslEnabled, null, null, false, null, null, null, null, null, null, null, null, TrustManagerShouldDoDefaultValidation.UNSPECIFIED);
    }

    public ControllerInfo(String controllerHostName, int controllerPort, ADBoolean sslEnabled, String keystoreFileName, String keystorePassword, boolean useEncryptedCredentials, String credentialStoreFilename, String credentialStorePassword, ADBoolean useSslClientAuth, String asymmetricKeysStoreFilename, String asymmetricKeysStorePassword, String asymmetricKeyPassword, String asymmetricKeyAlias, TrustManagerShouldDoDefaultValidation validation) {
        this(controllerHostName, controllerPort, sslEnabled, keystoreFileName, keystorePassword, useEncryptedCredentials, credentialStoreFilename, credentialStorePassword, null, useSslClientAuth, asymmetricKeysStoreFilename, asymmetricKeysStorePassword, asymmetricKeyPassword, asymmetricKeyAlias, validation);
    }

    public ControllerInfo(String controllerHostName, int controllerPort, ADBoolean sslEnabled, String keystoreFileName, String keystorePassword, boolean useEncryptedCredentials, String credentialStoreFilename, String credentialStorePassword, String credentialStoreFormat, ADBoolean useSslClientAuth, String asymmetricKeysStoreFilename, String asymmetricKeysStorePassword, String asymmetricKeyPassword, String asymmetricKeyAlias, TrustManagerShouldDoDefaultValidation validation) {
        if (controllerHostName == null) {
            throw new NullPointerException("controller host name is null");
        }
        if (controllerPort < 1 || controllerPort > 65535) {
            throw new IllegalArgumentException("controller port is out of valid range: " + controllerPort);
        }
        this.controllerHostName = controllerHostName;
        this.controllerPort = controllerPort;
        this.sslEnabled = sslEnabled;
        this.keystoreFileName = keystoreFileName;
        this.keystorePassword = keystorePassword;
        this.useEncryptedCredentials = useEncryptedCredentials;
        this.credentialStoreFilename = credentialStoreFilename;
        this.credentialStorePassword = credentialStorePassword;
        this.credentialStoreFormat = credentialStoreFormat;
        this.useSslClientAuth = useSslClientAuth;
        this.asymmetricKeysStoreFilename = asymmetricKeysStoreFilename;
        this.asymmetricKeysStorePassword = asymmetricKeysStorePassword;
        this.asymmetricKeyPassword = asymmetricKeyPassword;
        this.asymmetricKeyAlias = asymmetricKeyAlias;
        this.validation = validation;
    }

    public boolean hasTrustStoreInfo() {
        return StringOperations.isNotEmpty((String)this.keystoreFileName) && StringOperations.isNotEmpty((String)this.keystorePassword);
    }

    public boolean hasSslClientAuthInfo() {
        return this.useSslClientAuth != null && StringOperations.isNotEmpty((String)this.asymmetricKeysStoreFilename) && StringOperations.isNotEmpty((String)this.asymmetricKeysStorePassword) && StringOperations.isNotEmpty((String)this.asymmetricKeyPassword);
    }

    public ControllerInfo(String controllerHostName, String controllerPort, String sslEnabled) {
        this(controllerHostName, ControllerInfo.parseControllerPort(controllerPort), ADBoolean.parse((String)sslEnabled));
    }

    private static int parseControllerPort(String controllerPort) {
        try {
            return Integer.parseInt(controllerPort);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("controller port is not an integer value: " + controllerPort);
        }
    }

    public String getControllerHostName() {
        return this.controllerHostName;
    }

    public int getControllerPort() {
        return this.controllerPort;
    }

    public ADBoolean getSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled != null && this.sslEnabled.get();
    }

    public boolean getUseEncryptedCredentials() {
        return this.useEncryptedCredentials;
    }

    public ADBoolean getUseSslClientAuth() {
        return this.useSslClientAuth;
    }

    public boolean isSslClientAuthEnabled() {
        return this.useSslClientAuth != null && this.useSslClientAuth.get();
    }

    public String toString() {
        return "ControllerInfo:: host:[" + this.controllerHostName + "] port:[" + this.controllerPort + "] sslEnabled:[" + (this.sslEnabled != null ? this.sslEnabled.toString() : "unknown") + "] keystoreFile:[" + (StringOperations.isNotEmpty((String)this.keystoreFileName) ? this.keystoreFileName : "DEFAULT:cacerts.jks") + "] use-encrypted-credentials:[" + this.useEncryptedCredentials + "] secureCredentialStoreFileName:[" + this.credentialStoreFilename + "] secureCredentialStorePassword:[" + this.credentialStorePassword + "] secureCredentialStoreFormat:[" + this.credentialStoreFormat + "] use-ssl-client-auth:[" + (this.useSslClientAuth != null ? this.useSslClientAuth.toString() : "unknown") + "] asymmetricKeysStoreFilename:[" + this.asymmetricKeysStoreFilename + "] asymmetricKeysStorePassword:[" + this.asymmetricKeysStorePassword + "] asymmetricKeyPassword:[" + this.asymmetricKeyPassword + "] asymmetricKeyAlias:[" + this.asymmetricKeyAlias + "] validation:[" + (Object)((Object)this.validation) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ControllerInfo) {
            ControllerInfo other = (ControllerInfo)obj;
            return ObjectComparisonUtils.compareEquals((Object)this.controllerHostName, (Object)other.controllerHostName) && this.controllerPort == other.controllerPort && ObjectComparisonUtils.compareEquals((Object)this.sslEnabled, (Object)other.sslEnabled) && ObjectComparisonUtils.compareEquals((Object)this.keystoreFileName, (Object)other.keystoreFileName) && ObjectComparisonUtils.compareEquals((Object)this.keystorePassword, (Object)other.keystorePassword) && this.useEncryptedCredentials == other.useEncryptedCredentials && ObjectComparisonUtils.compareEquals((Object)this.credentialStoreFilename, (Object)other.credentialStoreFilename) && ObjectComparisonUtils.compareEquals((Object)this.credentialStorePassword, (Object)other.credentialStorePassword) && ObjectComparisonUtils.compareEquals((Object)this.credentialStoreFormat, (Object)other.credentialStoreFormat) && ObjectComparisonUtils.compareEquals((Object)this.useSslClientAuth, (Object)other.useSslClientAuth) && ObjectComparisonUtils.compareEquals((Object)this.asymmetricKeysStoreFilename, (Object)other.asymmetricKeysStoreFilename) && ObjectComparisonUtils.compareEquals((Object)this.asymmetricKeysStorePassword, (Object)other.asymmetricKeysStorePassword) && ObjectComparisonUtils.compareEquals((Object)this.asymmetricKeyPassword, (Object)other.asymmetricKeyPassword) && ObjectComparisonUtils.compareEquals((Object)this.asymmetricKeyAlias, (Object)other.asymmetricKeyAlias);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.controllerHostName != null ? this.controllerHostName.hashCode() : 0);
        result = 37 * result + this.controllerPort;
        result = 37 * result + (this.sslEnabled != null ? this.sslEnabled.hashCode() : 0);
        result = 37 * result + (this.keystoreFileName != null ? this.keystoreFileName.hashCode() : 0);
        result = 37 * result + (this.keystorePassword != null ? this.keystorePassword.hashCode() : 0);
        result = 37 * result + (this.useEncryptedCredentials ? 1 : 0);
        result = 37 * result + (this.credentialStoreFilename != null ? this.credentialStoreFilename.hashCode() : 0);
        result = 37 * result + (this.credentialStorePassword != null ? this.credentialStorePassword.hashCode() : 0);
        result = 37 * result + (this.credentialStoreFormat != null ? this.credentialStoreFormat.hashCode() : 0);
        result = 37 * result + (this.useSslClientAuth != null ? this.useSslClientAuth.hashCode() : 0);
        result = 37 * result + (this.asymmetricKeysStoreFilename != null ? this.asymmetricKeysStoreFilename.hashCode() : 0);
        result = 37 * result + (this.asymmetricKeysStorePassword != null ? this.asymmetricKeysStorePassword.hashCode() : 0);
        result = 37 * result + (this.asymmetricKeyPassword != null ? this.asymmetricKeyPassword.hashCode() : 0);
        result = 37 * result + (this.asymmetricKeyAlias != null ? this.asymmetricKeyAlias.hashCode() : 0);
        return result;
    }

    private String getKeystoreFileName() {
        return this.keystoreFileName;
    }

    public String getResolvedKeystoreFileName() {
        if (StringOperations.isEmpty((String)this.keystoreFileName)) {
            return DEFAULT_KEYSTORE_FILE_NAME;
        }
        return this.keystoreFileName;
    }

    public String getCredentialStoreFilename() {
        return this.credentialStoreFilename;
    }

    public String getCredentialStorePassword() {
        return this.credentialStorePassword;
    }

    public String getCredentialStoreFormat() {
        return this.credentialStoreFormat;
    }

    public String getAsymmetricKeysStoreFilename() {
        return this.asymmetricKeysStoreFilename;
    }

    public String getAsymmetricKeysStorePassword() {
        return this.asymmetricKeysStorePassword;
    }

    public String getAsymmetricKeyPassword() {
        return this.asymmetricKeyPassword;
    }

    public String getAsymmetricKeyAlias() {
        return this.asymmetricKeyAlias;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public boolean isSaaS() {
        return this.controllerHostName != null && this.controllerHostName.contains(SAAS_CONTROLLER_NAME);
    }

    public TrustManagerShouldDoDefaultValidation getValidation() {
        return this.validation;
    }

    public static class ControllerInfoMemento {
        ControllerInfo controllerInfo = null;
        private int[] controllerInfoValidFields = new int[EnumHelper.getValuesCount(ValidField.class)];

        public ControllerInfoMemento(String controllerHostName, String controllerPort, String sslEnabled) {
            this(controllerHostName, controllerPort, sslEnabled, null, null, null, null, null, null, null, null, null, null, null, TrustManagerShouldDoDefaultValidation.UNSPECIFIED);
        }

        public ControllerInfoMemento(String controllerHostName, String controllerPort, String sslEnabled, String keystoreFileName, String keystorePassword, String useEncryptedCredentials, String credentialStoreFilename, String credentialStorePassword, String useSslClientAuth, String asymmetricKeysStoreFilename, String asymmetricKeysStorePassword, String asymmetricKeyPassword, String asymmetricKeyAlias, TrustManagerShouldDoDefaultValidation validation) {
            this(controllerHostName, controllerPort, sslEnabled, keystoreFileName, keystorePassword, useEncryptedCredentials, credentialStoreFilename, credentialStorePassword, null, useSslClientAuth, asymmetricKeysStoreFilename, asymmetricKeysStorePassword, asymmetricKeyPassword, asymmetricKeyAlias, TrustManagerShouldDoDefaultValidation.UNSPECIFIED);
        }

        public ControllerInfoMemento(String controllerHostName, String controllerPort, String sslEnabled, String keystoreFileName, String keystorePassword, String useEncryptedCredentials, String credentialStoreFilename, String credentialStorePassword, String credentialStoreFormat, String useSslClientAuth, String asymmetricKeysStoreFilename, String asymmetricKeysStorePassword, String asymmetricKeyPassword, String asymmetricKeyAlias, TrustManagerShouldDoDefaultValidation validation) {
            for (ValidField vf : (ValidField[])EnumHelper.getValues(ValidField.class)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)vf)] = EnumHelper.getOrdinal((Enum)vf);
            }
            if (StringOperations.isEmpty((String)controllerHostName)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.CONTROLLER_HOST)] = -1;
                controllerHostName = "";
            }
            if (StringOperations.isEmpty((String)controllerPort) || controllerPort.equals("-1")) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.CONTROLLER_PORT)] = -1;
                controllerPort = "1";
            }
            if (StringOperations.isEmpty((String)keystoreFileName)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.KEYSTORE_FILENAME)] = -1;
                keystoreFileName = "";
            }
            if (keystorePassword == null || keystorePassword.equals("")) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.KEYSTORE_PASSWORD)] = -1;
                keystorePassword = "";
            }
            if (StringOperations.isEmpty((String)useEncryptedCredentials)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.USE_ENCRYPTED_CREDENTIALS)] = -1;
                useEncryptedCredentials = "";
            }
            if (StringOperations.isEmpty((String)credentialStoreFilename)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.SECURE_CREDENTIAL_STORE_NAME)] = -1;
                credentialStoreFilename = "";
            }
            if (StringOperations.isEmpty((String)credentialStorePassword)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.SECURE_CREDENTIAL_PASSWORD)] = -1;
                credentialStorePassword = "";
            }
            if (StringOperations.isEmpty((String)credentialStoreFormat)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.SECURE_CREDENTIAL_FORMAT)] = -1;
                credentialStoreFormat = "";
            }
            if (ADBoolean.parse((String)useSslClientAuth) == null) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.USE_SSL_CLIENT_AUTH)] = -1;
                useSslClientAuth = "";
            }
            if (StringOperations.isEmpty((String)asymmetricKeysStoreFilename)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.ASYMMETRIC_KEYS_STORE_NAME)] = -1;
                asymmetricKeysStoreFilename = "";
            }
            if (StringOperations.isEmpty((String)asymmetricKeysStorePassword)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.ASYMMETRIC_KEYS_STORE_PASSWORD)] = -1;
                asymmetricKeysStorePassword = "";
            }
            if (StringOperations.isEmpty((String)asymmetricKeyPassword)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.ASYMMETRIC_KEY_PASSWORD)] = -1;
                asymmetricKeyPassword = "";
            }
            if (StringOperations.isEmpty((String)asymmetricKeyAlias)) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.ASYMMETRIC_KEY_ALIAS)] = -1;
                asymmetricKeyAlias = "";
            }
            if (ADBoolean.parse((String)sslEnabled) == null) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.SSL_ENABLED)] = -1;
                sslEnabled = "";
            }
            if (validation == null || validation == TrustManagerShouldDoDefaultValidation.UNSPECIFIED) {
                this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)ValidField.TRUST_MANAGER_VALIDATION)] = -1;
                validation = TrustManagerShouldDoDefaultValidation.UNSPECIFIED;
            }
            this.controllerInfo = new ControllerInfo(controllerHostName, ControllerInfo.parseControllerPort(controllerPort), ADBoolean.parse((String)sslEnabled), keystoreFileName, keystorePassword, StringOperations.safeParseBoolean((String)useEncryptedCredentials, (boolean)false), credentialStoreFilename, credentialStorePassword, credentialStoreFormat, ADBoolean.parse((String)useSslClientAuth), asymmetricKeysStoreFilename, asymmetricKeysStorePassword, asymmetricKeyPassword, asymmetricKeyAlias, validation);
        }

        public ControllerInfo getControllerInfo() {
            if (this.isPrimitiveInfoResolved()) {
                return this.controllerInfo;
            }
            return null;
        }

        public boolean isFullyResolved() {
            for (ValidField vf : (ValidField[])EnumHelper.getValues(ValidField.class)) {
                if (this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)vf)] == EnumHelper.getOrdinal((Enum)vf)) continue;
                return false;
            }
            return true;
        }

        public boolean isPrimitiveInfoResolved() {
            return this.isValid(ValidField.CONTROLLER_HOST) && this.isValid(ValidField.CONTROLLER_PORT);
        }

        public boolean isSecureCredentialInfoResolved() {
            return !this.isValid(ValidField.USE_ENCRYPTED_CREDENTIALS) || !this.controllerInfo.getUseEncryptedCredentials() || this.isValid(ValidField.SECURE_CREDENTIAL_STORE_NAME) && this.isValid(ValidField.SECURE_CREDENTIAL_PASSWORD);
        }

        public boolean isSslClientAuthInfoResolved() {
            return !this.isValid(ValidField.USE_SSL_CLIENT_AUTH) || !this.controllerInfo.isSslClientAuthEnabled() || this.controllerInfo.isSslEnabled() && this.isValid(ValidField.ASYMMETRIC_KEYS_STORE_NAME) && this.isValid(ValidField.ASYMMETRIC_KEYS_STORE_PASSWORD) && this.isValid(ValidField.ASYMMETRIC_KEY_PASSWORD);
        }

        private boolean isValid(ValidField field) {
            return this.controllerInfoValidFields[EnumHelper.getOrdinal((Enum)field)] == EnumHelper.getOrdinal((Enum)field);
        }

        public static ControllerInfoMemento merge(ControllerInfoMemento primary, ControllerInfoMemento secondary) {
            TrustManagerShouldDoDefaultValidation validation;
            if (primary == null) {
                return secondary;
            }
            String hostname = primary.isValid(ValidField.CONTROLLER_HOST) ? primary.controllerInfo.getControllerHostName() : "";
            String port = primary.isValid(ValidField.CONTROLLER_PORT) ? String.valueOf(primary.controllerInfo.getControllerPort()) : "";
            String sslenabled = primary.isValid(ValidField.SSL_ENABLED) ? ADBoolean.toString((ADBoolean)primary.controllerInfo.getSslEnabled()) : null;
            String keystoreFilename = primary.isValid(ValidField.KEYSTORE_FILENAME) ? primary.controllerInfo.getKeystoreFileName() : "";
            String keystorePassword = primary.isValid(ValidField.KEYSTORE_PASSWORD) ? primary.controllerInfo.getKeystorePassword() : "";
            String useEncryptedCredentials = primary.isValid(ValidField.USE_ENCRYPTED_CREDENTIALS) ? String.valueOf(primary.controllerInfo.getUseEncryptedCredentials()) : "";
            String credentialStoreFilename = primary.isValid(ValidField.SECURE_CREDENTIAL_STORE_NAME) ? primary.controllerInfo.getCredentialStoreFilename() : "";
            String credentialStorePassword = primary.isValid(ValidField.SECURE_CREDENTIAL_PASSWORD) ? primary.controllerInfo.getCredentialStorePassword() : "";
            String credentialStoreFormat = primary.isValid(ValidField.SECURE_CREDENTIAL_FORMAT) ? primary.controllerInfo.getCredentialStoreFormat() : "";
            String useSslClientAuth = primary.isValid(ValidField.USE_SSL_CLIENT_AUTH) ? ADBoolean.toString((ADBoolean)primary.controllerInfo.getUseSslClientAuth()) : null;
            String asymmetricKeysStoreFilename = primary.isValid(ValidField.ASYMMETRIC_KEYS_STORE_NAME) ? primary.controllerInfo.getAsymmetricKeysStoreFilename() : "";
            String asymmetricKeysStorePassword = primary.isValid(ValidField.ASYMMETRIC_KEYS_STORE_PASSWORD) ? primary.controllerInfo.getAsymmetricKeysStorePassword() : "";
            String asymmetricKeyPassword = primary.isValid(ValidField.ASYMMETRIC_KEY_PASSWORD) ? primary.controllerInfo.getAsymmetricKeyPassword() : "";
            String asymmetricKeyAlias = primary.isValid(ValidField.ASYMMETRIC_KEY_ALIAS) ? primary.controllerInfo.getAsymmetricKeyAlias() : "";
            TrustManagerShouldDoDefaultValidation trustManagerShouldDoDefaultValidation = validation = primary.isValid(ValidField.TRUST_MANAGER_VALIDATION) ? primary.controllerInfo.getValidation() : TrustManagerShouldDoDefaultValidation.UNSPECIFIED;
            if (!primary.isValid(ValidField.CONTROLLER_HOST) && secondary.isValid(ValidField.CONTROLLER_HOST)) {
                hostname = secondary.controllerInfo.getControllerHostName();
            }
            if (!primary.isValid(ValidField.CONTROLLER_PORT) && secondary.isValid(ValidField.CONTROLLER_PORT)) {
                port = String.valueOf(secondary.controllerInfo.getControllerPort());
            }
            if (!primary.isValid(ValidField.SSL_ENABLED) && secondary.isValid(ValidField.SSL_ENABLED)) {
                sslenabled = ADBoolean.toString((ADBoolean)secondary.controllerInfo.getSslEnabled());
            }
            if (!primary.isValid(ValidField.KEYSTORE_FILENAME) && secondary.isValid(ValidField.KEYSTORE_FILENAME)) {
                keystoreFilename = secondary.controllerInfo.getKeystoreFileName();
            }
            if (!primary.isValid(ValidField.KEYSTORE_PASSWORD) && secondary.isValid(ValidField.KEYSTORE_PASSWORD)) {
                keystorePassword = secondary.controllerInfo.getKeystorePassword();
            }
            if (!primary.isValid(ValidField.USE_ENCRYPTED_CREDENTIALS) && secondary.isValid(ValidField.USE_ENCRYPTED_CREDENTIALS)) {
                useEncryptedCredentials = String.valueOf(secondary.controllerInfo.getUseEncryptedCredentials());
            }
            if (!primary.isValid(ValidField.SECURE_CREDENTIAL_STORE_NAME) && secondary.isValid(ValidField.SECURE_CREDENTIAL_STORE_NAME)) {
                credentialStoreFilename = secondary.controllerInfo.getCredentialStoreFilename();
            }
            if (!primary.isValid(ValidField.SECURE_CREDENTIAL_PASSWORD) && secondary.isValid(ValidField.SECURE_CREDENTIAL_PASSWORD)) {
                credentialStorePassword = secondary.controllerInfo.getCredentialStorePassword();
            }
            if (!primary.isValid(ValidField.SECURE_CREDENTIAL_FORMAT) && secondary.isValid(ValidField.SECURE_CREDENTIAL_FORMAT)) {
                credentialStoreFormat = secondary.controllerInfo.getCredentialStoreFormat();
            }
            if (!primary.isValid(ValidField.USE_SSL_CLIENT_AUTH) && secondary.isValid(ValidField.USE_SSL_CLIENT_AUTH)) {
                useSslClientAuth = ADBoolean.toString((ADBoolean)secondary.controllerInfo.getUseSslClientAuth());
            }
            if (!primary.isValid(ValidField.ASYMMETRIC_KEYS_STORE_NAME) && secondary.isValid(ValidField.ASYMMETRIC_KEYS_STORE_NAME)) {
                asymmetricKeysStoreFilename = secondary.controllerInfo.getAsymmetricKeysStoreFilename();
            }
            if (!primary.isValid(ValidField.ASYMMETRIC_KEYS_STORE_PASSWORD) && secondary.isValid(ValidField.ASYMMETRIC_KEYS_STORE_PASSWORD)) {
                asymmetricKeysStorePassword = secondary.controllerInfo.getAsymmetricKeysStorePassword();
            }
            if (!primary.isValid(ValidField.ASYMMETRIC_KEY_PASSWORD) && secondary.isValid(ValidField.ASYMMETRIC_KEY_PASSWORD)) {
                asymmetricKeyPassword = secondary.controllerInfo.getAsymmetricKeyPassword();
            }
            if (!primary.isValid(ValidField.ASYMMETRIC_KEY_ALIAS) && secondary.isValid(ValidField.ASYMMETRIC_KEY_ALIAS)) {
                asymmetricKeyAlias = secondary.controllerInfo.getAsymmetricKeyAlias();
            }
            if (!primary.isValid(ValidField.TRUST_MANAGER_VALIDATION) && secondary.isValid(ValidField.TRUST_MANAGER_VALIDATION)) {
                validation = secondary.controllerInfo.getValidation();
            }
            return new ControllerInfoMemento(hostname, port, sslenabled, keystoreFilename, keystorePassword, useEncryptedCredentials, credentialStoreFilename, credentialStorePassword, credentialStoreFormat, useSslClientAuth, asymmetricKeysStoreFilename, asymmetricKeysStorePassword, asymmetricKeyPassword, asymmetricKeyAlias, validation);
        }

        public static ControllerInfo merge(ControllerInfoMemento primary, ControllerInfo secondary) {
            ControllerInfoMemento secondaryMemento = new ControllerInfoMemento(secondary.getControllerHostName(), String.valueOf(secondary.getControllerPort()), ADBoolean.toString((ADBoolean)secondary.getSslEnabled()), secondary.getKeystoreFileName(), secondary.getKeystorePassword(), String.valueOf(secondary.getUseEncryptedCredentials()), secondary.getCredentialStoreFilename(), secondary.getCredentialStorePassword(), secondary.getCredentialStoreFormat(), ADBoolean.toString((ADBoolean)secondary.getUseSslClientAuth()), secondary.getAsymmetricKeysStoreFilename(), secondary.getAsymmetricKeysStorePassword(), secondary.getAsymmetricKeyPassword(), secondary.getAsymmetricKeyAlias(), secondary.getValidation());
            ControllerInfoMemento mergedControllerInfoMemento = ControllerInfoMemento.merge(primary, secondaryMemento);
            return mergedControllerInfoMemento.getControllerInfo();
        }

        private static enum ValidField {
            CONTROLLER_HOST,
            CONTROLLER_PORT,
            SSL_ENABLED,
            KEYSTORE_FILENAME,
            KEYSTORE_PASSWORD,
            USE_ENCRYPTED_CREDENTIALS,
            SECURE_CREDENTIAL_STORE_NAME,
            SECURE_CREDENTIAL_PASSWORD,
            SECURE_CREDENTIAL_FORMAT,
            USE_SSL_CLIENT_AUTH,
            ASYMMETRIC_KEYS_STORE_NAME,
            ASYMMETRIC_KEYS_STORE_PASSWORD,
            ASYMMETRIC_KEY_PASSWORD,
            ASYMMETRIC_KEY_ALIAS,
            TRUST_MANAGER_VALIDATION;

        }
    }
}

