/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.util.string.MapEncoder;
import com.singularity.ee.util.uuid.UUIDUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class AgentResolutionEncoder {
    private final ControllerInfo controllerInfo;
    private final String uniqueHostId;
    private final AgentAccountInfo agentAccountInfo;

    public AgentResolutionEncoder(String controllerHost, int controllerPort, String accountName, String accountAccessKey) {
        this.controllerInfo = new ControllerInfo(controllerHost, controllerPort, null);
        this.uniqueHostId = UUIDUtils.getRandomUUID();
        this.agentAccountInfo = new AgentAccountInfo(accountName, accountAccessKey);
    }

    public ControllerInfo getControllerHostInfo() {
        return this.controllerInfo;
    }

    public String getUniqueHostIdentifier() {
        return this.uniqueHostId;
    }

    public AgentAccountInfo getAgentAccountInfo() {
        return this.agentAccountInfo;
    }

    public String encodeAgentResolutionInfo() {
        LinkedHashMap<String, String> agentResolutionInfo = new LinkedHashMap<String, String>();
        agentResolutionInfo.put("provider", "singularity");
        agentResolutionInfo.put("controllerHost", this.controllerInfo.getControllerHostName());
        agentResolutionInfo.put("controllerPort", String.valueOf(this.controllerInfo.getControllerPort()));
        agentResolutionInfo.put("controllerSSLEnabled", String.valueOf(this.controllerInfo.getSslEnabled()));
        agentResolutionInfo.put("uniqueHostId", this.uniqueHostId);
        agentResolutionInfo.put("accountName", this.agentAccountInfo.getAccountName());
        agentResolutionInfo.put("accountAccessKey", this.agentAccountInfo.getAccountAccessKey());
        return MapEncoder.mapToString(agentResolutionInfo);
    }

    public static boolean isValidEncoding(String string) {
        if (string != null && string.length() > 0) {
            HashMap<String, String> providerInfo = new HashMap<String, String>();
            providerInfo.put("provider", "singularity");
            String requiredPrefix = MapEncoder.mapToString(providerInfo);
            return string.startsWith(requiredPrefix);
        }
        return false;
    }
}

