/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.AgentAccountInfo;
import com.singularity.ee.agent.resolver.AgentResolutionEncoder;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.MapEncoder;
import java.util.Map;

public class AgentResolutionDecoder {
    private final ControllerInfo controllerInfo;
    private final String uniqueHostId;
    private final AgentAccountInfo agentAccountInfo;
    private final boolean validAgentResolutionInfo;

    public AgentResolutionDecoder(String encodedAgentResolutionInfo, ILogger logger) {
        Map decodedAgentResolutionInfo = null;
        if (AgentResolutionEncoder.isValidEncoding(encodedAgentResolutionInfo)) {
            try {
                decodedAgentResolutionInfo = MapEncoder.stringToMap((String)encodedAgentResolutionInfo);
            }
            catch (Exception e) {
                logger.error("The agent resolution info is recognized as valid but was not parseable [" + encodedAgentResolutionInfo + "]", (Throwable)e);
            }
        }
        if (decodedAgentResolutionInfo != null) {
            ControllerInfo controllerInfo = null;
            try {
                String controllerHost = (String)decodedAgentResolutionInfo.get("controllerHost");
                String controllerPort = (String)decodedAgentResolutionInfo.get("controllerPort");
                String sslEnabled = (String)decodedAgentResolutionInfo.get("controllerSSLEnabled");
                controllerInfo = new ControllerInfo(controllerHost, controllerPort, sslEnabled);
            }
            catch (Exception e) {
                logger.error("The agent resolution info did not contain correctly formatted controller info [" + encodedAgentResolutionInfo + "]", (Throwable)e);
            }
            this.controllerInfo = controllerInfo;
            this.uniqueHostId = (String)decodedAgentResolutionInfo.get("uniqueHostId");
            if (this.uniqueHostId == null) {
                logger.error("The agent resolution info did not contain a correctly formatted unique host identifier [" + encodedAgentResolutionInfo + "]");
            }
            AgentAccountInfo accountInfo = null;
            try {
                String accountName = (String)decodedAgentResolutionInfo.get("accountName");
                String accountAccessKey = (String)decodedAgentResolutionInfo.get("accountAccessKey");
                accountInfo = new AgentAccountInfo(accountName, accountAccessKey);
            }
            catch (Exception e) {
                logger.error("The agent resolution info did not contain correctly formatted agent account info [" + encodedAgentResolutionInfo + "]", (Throwable)e);
            }
            this.agentAccountInfo = accountInfo;
            this.validAgentResolutionInfo = this.controllerInfo != null && this.uniqueHostId != null && this.agentAccountInfo != null;
        } else {
            this.controllerInfo = null;
            this.uniqueHostId = null;
            this.agentAccountInfo = null;
            this.validAgentResolutionInfo = false;
        }
    }

    public boolean isValidAgentResolutionInfo() {
        return this.validAgentResolutionInfo;
    }

    public ControllerInfo getControllerHostInfo() {
        return this.controllerInfo;
    }

    public String getUniqueHostIdentifier() {
        return this.uniqueHostId;
    }

    public AgentAccountInfo getAgentAccountInfo() {
        return this.agentAccountInfo;
    }
}

