/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.agent.resolver.ISelfServiceNameProvider;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.util.string.StringOperations;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AgentRegistrationInfo {
    private final Set<String> applicationNames;
    private volatile String applicationComponentName;
    private final String applicationComponentNodeName;
    private final String agentRuntimeDir;
    private String nodeNameFromController = null;
    private final boolean forceAgentRegistrationConfig;
    private final boolean autoResolution;
    private final boolean selfService;
    private final boolean deferredRegistration;
    private final boolean componentNameGenerated;
    private final boolean ephemeralNode;
    private ISelfServiceNameProvider selfServiceNameProvider;

    public AgentRegistrationInfo(String applicationName, String applicationComponentName, String applicationComponentNodeName, boolean forceAgentRegistrationConfig) {
        this(applicationName, applicationComponentName, applicationComponentNodeName, null, forceAgentRegistrationConfig, false, false, false, false, null);
    }

    public AgentRegistrationInfo(String applicationName, String applicationComponentName, String applicationComponentNodeName, boolean forceAgentRegistrationConfig, boolean ephemeralNode) {
        this(new HashSet<String>(Arrays.asList(applicationName)), applicationComponentName, applicationComponentNodeName, null, forceAgentRegistrationConfig, false, false, false, false, ephemeralNode, null);
    }

    public AgentRegistrationInfo(String applicationName, String applicationComponentName, String applicationComponentNodeName, String agentBaseDir, boolean forceAgentRegistrationConfig) {
        this(applicationName, applicationComponentName, applicationComponentNodeName, agentBaseDir, forceAgentRegistrationConfig, false, false, false, false, null);
    }

    public AgentRegistrationInfo(String applicationName, String applicationComponentName, String applicationComponentNodeName, String agentBaseDir, boolean forceAgentRegistrationConfig, boolean autoResolution, boolean selfService, boolean deferredRegistration, boolean componentNameGenerated, ISelfServiceNameProvider selfServiceNameProvider) {
        this(new HashSet<String>(), applicationComponentName, applicationComponentNodeName, agentBaseDir, forceAgentRegistrationConfig, autoResolution, selfService, deferredRegistration, componentNameGenerated, selfServiceNameProvider);
        if (applicationName != null) {
            this.applicationNames.add(applicationName);
        }
    }

    public AgentRegistrationInfo(Set<String> applicationNames, String applicationComponentName, String applicationComponentNodeName, String agentBaseDir, boolean forceAgentRegistrationConfig, boolean autoResolution, boolean selfService, boolean deferredRegistration, boolean componentNameGenerated, ISelfServiceNameProvider selfServiceNameProvider) {
        this(applicationNames, applicationComponentName, applicationComponentNodeName, agentBaseDir, forceAgentRegistrationConfig, autoResolution, selfService, deferredRegistration, componentNameGenerated, false, selfServiceNameProvider);
    }

    public AgentRegistrationInfo(Set<String> applicationNames, String applicationComponentName, String applicationComponentNodeName, String agentBaseDir, boolean forceAgentRegistrationConfig, boolean autoResolution, boolean selfService, boolean deferredRegistration, boolean componentNameGenerated, boolean ephemeralNode, ISelfServiceNameProvider selfServiceNameProvider) {
        if (applicationNames == null) {
            throw new IllegalArgumentException("applicationNames must not be null");
        }
        this.applicationNames = applicationNames;
        this.applicationComponentName = applicationComponentName;
        this.applicationComponentNodeName = applicationComponentNodeName;
        this.agentRuntimeDir = agentBaseDir;
        this.forceAgentRegistrationConfig = forceAgentRegistrationConfig;
        this.autoResolution = autoResolution;
        this.selfService = selfService;
        this.deferredRegistration = deferredRegistration;
        this.componentNameGenerated = componentNameGenerated;
        this.ephemeralNode = ephemeralNode;
        this.selfServiceNameProvider = selfServiceNameProvider;
    }

    public boolean isMultipleApplicationRegistration() {
        return this.applicationNames.size() > 1;
    }

    public String getApplicationName() {
        Iterator<String> iterator = this.applicationNames.iterator();
        if (iterator.hasNext()) {
            String applicationName = iterator.next();
            return applicationName;
        }
        return null;
    }

    public Set<String> getApplicationNames() {
        return this.applicationNames;
    }

    public String getApplicationComponentName() {
        return this.applicationComponentName;
    }

    public String getApplicationComponentNodeName() {
        return this.nodeNameFromController == null ? this.applicationComponentNodeName : this.nodeNameFromController;
    }

    public void setApplicationComponentName(String applicationComponentName) {
        this.applicationComponentName = applicationComponentName;
    }

    public boolean isFullAgentRegistrationInfoSpecified(AgentType agentType) {
        if (agentType == null) {
            return false;
        }
        switch (agentType) {
            case APP_AGENT: 
            case PHP_APP_AGENT: 
            case NODEJS_APP_AGENT: 
            case PYTHON_APP_AGENT: 
            case RUBY_APP_AGENT: 
            case DB_AGENT: 
            case DB_COLLECTOR: {
                return this.applicationNames.size() > 0 && this.applicationComponentName != null && this.applicationComponentNodeName != null;
            }
            case MACHINE_AGENT: 
            case DOT_NET_MACHINE_AGENT: 
            case PHP_MACHINE_AGENT: 
            case NODEJS_MACHINE_AGENT: {
                return this.applicationNames.size() > 0 && this.applicationComponentName != null;
            }
        }
        throw new IllegalStateException("Agent type " + agentType + " not supported");
    }

    public boolean isForceAgentRegistrationConfig() {
        return this.forceAgentRegistrationConfig;
    }

    public boolean isAutoResolution() {
        return this.autoResolution;
    }

    public String getAgentRuntimeDir() {
        return this.agentRuntimeDir;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AgentRegistrationInfo) {
            AgentRegistrationInfo other = (AgentRegistrationInfo)obj;
            return this.getApplicationNames().equals(other.getApplicationNames()) && (this.getApplicationComponentName() == null ? other.getApplicationComponentName() == null : this.getApplicationComponentName().equals(other.getApplicationComponentName())) && (this.getApplicationComponentNodeName() == null ? other.getApplicationComponentNodeName() == null : this.getApplicationComponentNodeName().equals(other.getApplicationComponentNodeName()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getApplicationNames().hashCode();
        result = 37 * result + (this.getApplicationComponentName() == null ? -1 : this.getApplicationComponentName().hashCode());
        result = 37 * result + (this.getApplicationComponentNodeName() == null ? -1 : this.getApplicationComponentNodeName().hashCode());
        return result;
    }

    public void setApplicationComponentNodeName(String nodeName) {
        this.nodeNameFromController = nodeName;
    }

    public String getApplicationNamesAsString() {
        return StringOperations.convertToCommaSeparateString(this.applicationNames);
    }

    public boolean isSelfService() {
        return this.selfService;
    }

    public boolean isDeferredRegistration() {
        return this.deferredRegistration;
    }

    public boolean isEphemeralNode() {
        return this.ephemeralNode;
    }

    public ISelfServiceNameProvider getSelfServiceNameProvider() {
        return this.selfServiceNameProvider;
    }

    public void setSelfServiceNameProvider(ISelfServiceNameProvider selfServiceNameProvider) {
        this.selfServiceNameProvider = selfServiceNameProvider;
    }

    public boolean isComponentNameGenerated() {
        return this.componentNameGenerated;
    }

    public String toString() {
        return "Agent registration [NodeName:" + this.applicationComponentNodeName + ", agentRuntimeDir:" + this.agentRuntimeDir + ", Tier:" + this.applicationComponentName + ", App:" + this.getApplicationNamesAsString();
    }
}

