/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.resolver;

import com.singularity.ee.util.string.StringOperations;

public class AgentAccountInfo {
    private String accountName;
    private String accountAccessKey;

    public AgentAccountInfo(String accountName, String accountAccessKey) {
        this(accountName, accountAccessKey, true);
    }

    public AgentAccountInfo(String accountName, String accountAccessKey, boolean enforceNotNullValues) {
        if (enforceNotNullValues) {
            if (accountName == null) {
                throw new NullPointerException("account name is null");
            }
            if (accountAccessKey == null) {
                throw new NullPointerException("account access key is not specified");
            }
        }
        this.accountName = accountName;
        this.accountAccessKey = accountAccessKey;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountAccessKey() {
        return this.accountAccessKey;
    }

    public boolean isAccountSpecified() {
        return this.accountName != null && !this.accountName.equals("customer1") && this.accountAccessKey != null && !this.accountAccessKey.equals("SJ5b2m7d1$354");
    }

    public void merge(AgentAccountInfo info) {
        if (StringOperations.isEmptyAfterTrim((String)this.accountName) && !StringOperations.isEmptyAfterTrim((String)info.getAccountName())) {
            this.accountName = info.getAccountName();
        }
        if (StringOperations.isEmptyAfterTrim((String)this.accountAccessKey) && !StringOperations.isEmptyAfterTrim((String)info.getAccountAccessKey())) {
            this.accountAccessKey = info.getAccountAccessKey();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AgentAccountInfo) {
            AgentAccountInfo other = (AgentAccountInfo)obj;
            return (this.getAccountName() == null ? other.getAccountName() == null : this.getAccountName().equals(other.getAccountName())) && (this.getAccountAccessKey() == null ? other.getAccountAccessKey() == null : this.getAccountAccessKey().equals(other.getAccountAccessKey()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getAccountName() == null ? -1 : this.getAccountName().hashCode());
        result = 37 * result + (this.getAccountAccessKey() == null ? -1 : this.getAccountAccessKey().hashCode());
        return result;
    }
}

